/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.BambooItemFrame;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.TropiBeeEntity;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import net.tropicraft.core.common.entity.egg.SeaUrchinEggEntity;
import net.tropicraft.core.common.entity.egg.StarfishEggEntity;
import net.tropicraft.core.common.entity.egg.TropiSpiderEggEntity;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.entity.hostile.TropiSkellyEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.entity.neutral.EIHEntity;
import net.tropicraft.core.common.entity.neutral.IguanaEntity;
import net.tropicraft.core.common.entity.neutral.JaguarEntity;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.entity.passive.CowktailEntity;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FailgullEntity;
import net.tropicraft.core.common.entity.passive.FiddlerCrabEntity;
import net.tropicraft.core.common.entity.passive.HummingbirdEntity;
import net.tropicraft.core.common.entity.passive.TapirEntity;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;
import net.tropicraft.core.common.entity.passive.WhiteLippedPeccaryEntity;
import net.tropicraft.core.common.entity.passive.basilisk.BasiliskLizardEntity;
import net.tropicraft.core.common.entity.passive.monkey.SpiderMonkeyEntity;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.entity.placeable.UmbrellaEntity;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import net.tropicraft.core.common.entity.projectile.ExplodingCoconutEntity;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.entity.underdasea.CuberaEntity;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;
import net.tropicraft.core.common.entity.underdasea.ManOWarEntity;
import net.tropicraft.core.common.entity.underdasea.MarlinEntity;
import net.tropicraft.core.common.entity.underdasea.PiranhaEntity;
import net.tropicraft.core.common.entity.underdasea.SardineEntity;
import net.tropicraft.core.common.entity.underdasea.SeaUrchinEntity;
import net.tropicraft.core.common.entity.underdasea.SeahorseEntity;
import net.tropicraft.core.common.entity.underdasea.SharkEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftDolphinEntity;
import net.tropicraft.core.common.entity.underdasea.TropicraftTropicalFishEntity;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TropicraftEntities {
    private static final float EGG_WIDTH = 0.4f;
    private static final float EGG_HEIGHT = 0.5f;
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"tropicraft");
    public static final RegistryObject<EntityType<EntityKoaHunter>> KOA_HUNTER = TropicraftEntities.register("koa", TropicraftEntities::koaHunter);
    public static final RegistryObject<EntityType<TropiCreeperEntity>> TROPI_CREEPER = TropicraftEntities.register("tropicreeper", TropicraftEntities::tropicreeper);
    public static final RegistryObject<EntityType<IguanaEntity>> IGUANA = TropicraftEntities.register("iguana", TropicraftEntities::iguana);
    public static final RegistryObject<EntityType<UmbrellaEntity>> UMBRELLA = TropicraftEntities.register("umbrella", TropicraftEntities::umbrella);
    public static final RegistryObject<EntityType<ChairEntity>> CHAIR = TropicraftEntities.register("chair", TropicraftEntities::chair);
    public static final RegistryObject<EntityType<BeachFloatEntity>> BEACH_FLOAT = TropicraftEntities.register("beach_float", TropicraftEntities::beachFloat);
    public static final RegistryObject<EntityType<TropiSkellyEntity>> TROPI_SKELLY = TropicraftEntities.register("tropiskelly", TropicraftEntities::tropiskelly);
    public static final RegistryObject<EntityType<EIHEntity>> EIH = TropicraftEntities.register("eih", TropicraftEntities::eih);
    public static final RegistryObject<EntityType<WallItemEntity>> WALL_ITEM = TropicraftEntities.register("wall_item", TropicraftEntities::wallItem);
    public static final RegistryObject<EntityType<BambooItemFrame>> BAMBOO_ITEM_FRAME = TropicraftEntities.register("bamboo_item_frame", TropicraftEntities::bambooItemFrame);
    public static final RegistryObject<EntityType<LavaBallEntity>> LAVA_BALL = null;
    public static final RegistryObject<EntityType<SeaTurtleEntity>> SEA_TURTLE = TropicraftEntities.register("turtle", TropicraftEntities::turtle);
    public static final RegistryObject<EntityType<MarlinEntity>> MARLIN = TropicraftEntities.register("marlin", TropicraftEntities::marlin);
    public static final RegistryObject<EntityType<FailgullEntity>> FAILGULL = TropicraftEntities.register("failgull", TropicraftEntities::failgull);
    public static final RegistryObject<EntityType<TropicraftDolphinEntity>> DOLPHIN = TropicraftEntities.register("dolphin", TropicraftEntities::dolphin);
    public static final RegistryObject<EntityType<SeahorseEntity>> SEAHORSE = TropicraftEntities.register("seahorse", TropicraftEntities::seahorse);
    public static final RegistryObject<EntityType<PoisonBlotEntity>> POISON_BLOT = TropicraftEntities.register("poison_blot", TropicraftEntities::poisonBlot);
    public static final RegistryObject<EntityType<TreeFrogEntity>> TREE_FROG = TropicraftEntities.register("tree_frog", TropicraftEntities::treeFrog);
    public static final RegistryObject<EntityType<SeaUrchinEntity>> SEA_URCHIN = TropicraftEntities.register("sea_urchin", TropicraftEntities::seaUrchin);
    public static final RegistryObject<EntityType<SeaUrchinEggEntity>> SEA_URCHIN_EGG_ENTITY = TropicraftEntities.register("sea_urchin_egg", TropicraftEntities::seaUrchinEgg);
    public static final RegistryObject<EntityType<StarfishEntity>> STARFISH = TropicraftEntities.register("starfish", TropicraftEntities::starfish);
    public static final RegistryObject<EntityType<StarfishEggEntity>> STARFISH_EGG = TropicraftEntities.register("starfish_egg", TropicraftEntities::starfishEgg);
    public static final RegistryObject<EntityType<VMonkeyEntity>> V_MONKEY = TropicraftEntities.register("v_monkey", TropicraftEntities::vervetMonkey);
    public static final RegistryObject<EntityType<SardineEntity>> RIVER_SARDINE = TropicraftEntities.register("sardine", TropicraftEntities::riverSardine);
    public static final RegistryObject<EntityType<PiranhaEntity>> PIRANHA = TropicraftEntities.register("piranha", TropicraftEntities::piranha);
    public static final RegistryObject<EntityType<TropicraftTropicalFishEntity>> TROPICAL_FISH = TropicraftEntities.register("tropical_fish", TropicraftEntities::tropicalFish);
    public static final RegistryObject<EntityType<EagleRayEntity>> EAGLE_RAY = TropicraftEntities.register("eagle_ray", TropicraftEntities::eagleRay);
    public static final RegistryObject<EntityType<TropiSpiderEntity>> TROPI_SPIDER = TropicraftEntities.register("tropi_spider", TropicraftEntities::tropiSpider);
    public static final RegistryObject<EntityType<TropiSpiderEggEntity>> TROPI_SPIDER_EGG = TropicraftEntities.register("tropi_spider_egg", TropicraftEntities::tropiSpiderEgg);
    public static final RegistryObject<EntityType<AshenMaskEntity>> ASHEN_MASK = TropicraftEntities.register("ashen_mask", TropicraftEntities::ashenMask);
    public static final RegistryObject<EntityType<AshenEntity>> ASHEN = TropicraftEntities.register("ashen", TropicraftEntities::ashen);
    public static final RegistryObject<EntityType<ExplodingCoconutEntity>> EXPLODING_COCONUT = TropicraftEntities.register("exploding_coconut", TropicraftEntities::explodingCoconut);
    public static final RegistryObject<EntityType<SharkEntity>> HAMMERHEAD = TropicraftEntities.register("hammerhead", TropicraftEntities::hammerhead);
    public static final RegistryObject<EntityType<SeaTurtleEggEntity>> SEA_TURTLE_EGG = TropicraftEntities.register("turtle_egg", TropicraftEntities::turtleEgg);
    public static final RegistryObject<EntityType<TropiBeeEntity>> TROPI_BEE = TropicraftEntities.register("tropibee", TropicraftEntities::tropiBee);
    public static final RegistryObject<EntityType<CowktailEntity>> COWKTAIL = TropicraftEntities.register("cowktail", TropicraftEntities::cowktail);
    public static final RegistryObject<EntityType<ManOWarEntity>> MAN_O_WAR = TropicraftEntities.register("man_o_war", TropicraftEntities::manOWar);
    public static final RegistryObject<EntityType<TapirEntity>> TAPIR = TropicraftEntities.register("tapir", TropicraftEntities::tapir);
    public static final RegistryObject<EntityType<JaguarEntity>> JAGUAR = TropicraftEntities.register("jaguar", TropicraftEntities::jaguar);
    public static final RegistryObject<EntityType<BasiliskLizardEntity>> BROWN_BASILISK_LIZARD = TropicraftEntities.register("brown_basilisk_lizard", TropicraftEntities::basiliskLizard);
    public static final RegistryObject<EntityType<BasiliskLizardEntity>> GREEN_BASILISK_LIZARD = TropicraftEntities.register("green_basilisk_lizard", TropicraftEntities::basiliskLizard);
    public static final RegistryObject<EntityType<HummingbirdEntity>> HUMMINGBIRD = TropicraftEntities.register("hummingbird", TropicraftEntities::hummingbird);
    public static final RegistryObject<EntityType<FiddlerCrabEntity>> FIDDLER_CRAB = TropicraftEntities.register("fiddler_crab", TropicraftEntities::fiddlerCrab);
    public static final RegistryObject<EntityType<SpiderMonkeyEntity>> SPIDER_MONKEY = TropicraftEntities.register("spider_monkey", TropicraftEntities::spiderMonkey);
    public static final RegistryObject<EntityType<WhiteLippedPeccaryEntity>> WHITE_LIPPED_PECCARY = TropicraftEntities.register("white_lipped_peccary", TropicraftEntities::whiteLippedPeccary);
    public static final RegistryObject<EntityType<CuberaEntity>> CUBERA = TropicraftEntities.register("cubera", TropicraftEntities::cubera);

    private static <E extends Entity, T extends EntityType<E>> RegistryObject<EntityType<E>> register(String name, Supplier<EntityType.Builder<E>> sup) {
        return ENTITIES.register(name, () -> ((EntityType.Builder)sup.get()).func_206830_a(name));
    }

    private static EntityType.Builder<CowktailEntity> cowktail() {
        return EntityType.Builder.func_220322_a(CowktailEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 1.4f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<ManOWarEntity> manOWar() {
        return EntityType.Builder.func_220322_a(ManOWarEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.6f, 0.8f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiBeeEntity> tropiBee() {
        return EntityType.Builder.func_220322_a(TropiBeeEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaTurtleEggEntity> turtleEgg() {
        return EntityType.Builder.func_220322_a(SeaTurtleEggEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<SharkEntity> hammerhead() {
        return EntityType.Builder.func_220322_a(SharkEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(2.4f, 1.4f).setTrackingRange(5).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<ExplodingCoconutEntity> explodingCoconut() {
        return EntityType.Builder.func_220322_a(ExplodingCoconutEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<AshenMaskEntity> ashenMask() {
        return EntityType.Builder.func_220322_a(AshenMaskEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.8f, 0.2f).setTrackingRange(6).setUpdateInterval(100).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<AshenEntity> ashen() {
        return EntityType.Builder.func_220322_a(AshenEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 1.3f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSpiderEntity> tropiSpider() {
        return EntityType.Builder.func_220322_a(TropiSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSpiderEggEntity> tropiSpiderEgg() {
        return EntityType.Builder.func_220322_a(TropiSpiderEggEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<EagleRayEntity> eagleRay() {
        return EntityType.Builder.func_220322_a(EagleRayEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(2.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropicraftTropicalFishEntity> tropicalFish() {
        return EntityType.Builder.func_220322_a(TropicraftTropicalFishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SardineEntity> riverSardine() {
        return EntityType.Builder.func_220322_a(SardineEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<PiranhaEntity> piranha() {
        return EntityType.Builder.func_220322_a(PiranhaEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(0.3f, 0.4f).setTrackingRange(4).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<VMonkeyEntity> vervetMonkey() {
        return EntityType.Builder.func_220322_a(VMonkeyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<StarfishEggEntity> starfishEgg() {
        return EntityType.Builder.func_220322_a(StarfishEggEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<StarfishEntity> starfish() {
        return EntityType.Builder.func_220322_a(StarfishEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(15).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaUrchinEggEntity> seaUrchinEgg() {
        return EntityType.Builder.func_220322_a(SeaUrchinEggEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.4f, 0.5f).setTrackingRange(6).setUpdateInterval(15).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<SeaUrchinEntity> seaUrchin() {
        return EntityType.Builder.func_220322_a(SeaUrchinEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TreeFrogEntity> treeFrog() {
        return EntityType.Builder.func_220322_a(TreeFrogEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<PoisonBlotEntity> poisonBlot() {
        return EntityType.Builder.func_220322_a(PoisonBlotEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeahorseEntity> seahorse() {
        return EntityType.Builder.func_220322_a(SeahorseEntity::new, (EntityClassification)EntityClassification.WATER_AMBIENT).func_220321_a(0.5f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropicraftDolphinEntity> dolphin() {
        return EntityType.Builder.func_220322_a(TropicraftDolphinEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(1.4f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<FailgullEntity> failgull() {
        return EntityType.Builder.func_220322_a(FailgullEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.4f, 0.6f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<MarlinEntity> marlin() {
        return EntityType.Builder.func_220322_a(MarlinEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(1.4f, 0.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SeaTurtleEntity> turtle() {
        return EntityType.Builder.func_220322_a(SeaTurtleEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 0.35f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<BambooItemFrame> bambooItemFrame() {
        return EntityType.Builder.func_220322_a(BambooItemFrame::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<LavaBallEntity> lavaBall() {
        return EntityType.Builder.func_220322_a(LavaBallEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<WallItemEntity> wallItem() {
        return EntityType.Builder.func_220322_a(WallItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<EIHEntity> eih() {
        return EntityType.Builder.func_220322_a(EIHEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 3.25f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiSkellyEntity> tropiskelly() {
        return EntityType.Builder.func_220322_a(TropiSkellyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 1.95f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<UmbrellaEntity> umbrella() {
        return EntityType.Builder.func_220322_a(UmbrellaEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 4.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<ChairEntity> chair() {
        return EntityType.Builder.func_220322_a(ChairEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.5f, 0.5f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<BeachFloatEntity> beachFloat() {
        return EntityType.Builder.func_220322_a(BeachFloatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.0f, 0.175f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false);
    }

    private static EntityType.Builder<IguanaEntity> iguana() {
        return EntityType.Builder.func_220322_a(IguanaEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 0.4f).setTrackingRange(8).setUpdateInterval(3).func_220320_c().setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<EntityKoaHunter> koaHunter() {
        return EntityType.Builder.func_220322_a(EntityKoaHunter::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f).setTrackingRange(8).setUpdateInterval(3).func_220320_c().setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TropiCreeperEntity> tropicreeper() {
        return EntityType.Builder.func_220322_a(TropiCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.7f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<TapirEntity> tapir() {
        return EntityType.Builder.func_220322_a(TapirEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<JaguarEntity> jaguar() {
        return EntityType.Builder.func_220322_a(JaguarEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.9f, 1.0f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<BasiliskLizardEntity> basiliskLizard() {
        return EntityType.Builder.func_220322_a(BasiliskLizardEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 0.4f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<HummingbirdEntity> hummingbird() {
        return EntityType.Builder.func_220322_a(HummingbirdEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<FiddlerCrabEntity> fiddlerCrab() {
        return EntityType.Builder.func_220322_a(FiddlerCrabEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 0.2f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<SpiderMonkeyEntity> spiderMonkey() {
        return EntityType.Builder.func_220322_a(SpiderMonkeyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 0.6f).setTrackingRange(10).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<WhiteLippedPeccaryEntity> whiteLippedPeccary() {
        return EntityType.Builder.func_220322_a(WhiteLippedPeccaryEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.7f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    private static EntityType.Builder<CuberaEntity> cubera() {
        return EntityType.Builder.func_220322_a(CuberaEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).func_220321_a(1.2f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true);
    }

    public static void registerSpawns() {
        TropicraftEntities.registerWaterSpawn((EntityType)TROPICAL_FISH.get(), AbstractFishEntity::func_223363_b);
        TropicraftEntities.registerWaterSpawn((EntityType)RIVER_SARDINE.get(), AbstractFishEntity::func_223363_b);
        TropicraftEntities.registerWaterSpawn((EntityType)PIRANHA.get(), AbstractFishEntity::func_223363_b);
        TropicraftEntities.registerWaterSpawn((EntityType)DOLPHIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)EAGLE_RAY.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)MARLIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)SEAHORSE.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)SEA_URCHIN.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)STARFISH.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)HAMMERHEAD.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerWaterSpawn((EntityType)MAN_O_WAR.get(), TropicraftEntities::canSpawnSurfaceOceanWaterMob);
        TropicraftEntities.registerLandSpawn((EntityType)KOA_HUNTER.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_CREEPER.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)IGUANA.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_SKELLY.get(), MonsterEntity::func_223325_c);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_SPIDER.get(), MonsterEntity::func_223325_c);
        TropicraftEntities.registerLandSpawn((EntityType)EIH.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)SEA_TURTLE.get(), SeaTurtleEntity::canSpawnOnLand);
        TropicraftEntities.registerLandSpawn((EntityType)TREE_FROG.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)V_MONKEY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)COWKTAIL.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)TAPIR.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)JAGUAR.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)BROWN_BASILISK_LIZARD.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)GREEN_BASILISK_LIZARD.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)HUMMINGBIRD.get(), HummingbirdEntity::canHummingbirdSpawnOn);
        TropicraftEntities.registerNoRestrictionSpawn((EntityType)FIDDLER_CRAB.get(), FiddlerCrabEntity::canCrabSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)SPIDER_MONKEY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerLandSpawn((EntityType)WHITE_LIPPED_PECCARY.get(), TropicraftEntities::canAnimalSpawn);
        TropicraftEntities.registerWaterSpawn((EntityType)CUBERA.get(), TropicraftEntities::canSpawnOceanWaterMob);
        TropicraftEntities.registerLandSpawn((EntityType)ASHEN.get(), MobEntity::func_223315_a);
        TropicraftEntities.registerLandSpawn((EntityType)FAILGULL.get(), MobEntity::func_223315_a);
        TropicraftEntities.registerLandSpawn((EntityType)TROPI_BEE.get(), MobEntity::func_223315_a);
    }

    public static boolean canAnimalSpawn(EntityType<? extends MobEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockState groundState = worldIn.func_180495_p(pos.func_177977_b());
        return groundState.func_177230_c() == Blocks.field_196658_i || groundState.func_185904_a() == Material.field_151595_p || groundState.func_235714_a_(TropicraftTags.Blocks.MUD);
    }

    private static <T extends MobEntity> void registerLandSpawn(EntityType<T> type, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        EntitySpawnPlacementRegistry.func_209343_a(type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    private static <T extends MobEntity> void registerWaterSpawn(EntityType<T> type, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        EntitySpawnPlacementRegistry.func_209343_a(type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    private static <T extends MobEntity> void registerNoRestrictionSpawn(EntityType<T> type, EntitySpawnPlacementRegistry.IPlacementPredicate<T> predicate) {
        EntitySpawnPlacementRegistry.func_209343_a(type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, predicate);
    }

    public static <T extends MobEntity> boolean canSpawnOceanWaterMob(EntityType<T> waterMob, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((IWorldReader)world);
        return pos.func_177956_o() > 90 && pos.func_177956_o() < seaLevel && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static <T extends MobEntity> boolean canSpawnSurfaceOceanWaterMob(EntityType<T> waterMob, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        int seaLevel = TropicraftDimension.getSeaLevel((IWorldReader)world);
        return pos.func_177956_o() > seaLevel - 3 && pos.func_177956_o() < seaLevel && world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    @SubscribeEvent
    public static void onCreateEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)KOA_HUNTER.get(), EntityKoaBase.createAttributes().func_233813_a_());
        event.put((EntityType)TROPI_CREEPER.get(), TropiCreeperEntity.createAttributes().func_233813_a_());
        event.put((EntityType)IGUANA.get(), IguanaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TROPI_SKELLY.get(), TropiSkellyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)EIH.get(), EIHEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SEA_TURTLE.get(), SeaTurtleEntity.func_234228_eK_().func_233813_a_());
        event.put((EntityType)MARLIN.get(), MarlinEntity.createAttributes().func_233813_a_());
        event.put((EntityType)FAILGULL.get(), FailgullEntity.createAttributes().func_233813_a_());
        event.put((EntityType)DOLPHIN.get(), TropicraftDolphinEntity.func_234190_eK_().func_233813_a_());
        event.put((EntityType)SEAHORSE.get(), SeahorseEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TREE_FROG.get(), TreeFrogEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SEA_URCHIN.get(), SeaUrchinEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SEA_URCHIN_EGG_ENTITY.get(), EggEntity.createAttributes().func_233813_a_());
        event.put((EntityType)STARFISH.get(), StarfishEntity.createAttributes().func_233813_a_());
        event.put((EntityType)STARFISH_EGG.get(), EggEntity.createAttributes().func_233813_a_());
        event.put((EntityType)V_MONKEY.get(), VMonkeyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)RIVER_SARDINE.get(), SardineEntity.createAttributes().func_233813_a_());
        event.put((EntityType)PIRANHA.get(), PiranhaEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TROPICAL_FISH.get(), TropicraftTropicalFishEntity.createAttributes().func_233813_a_());
        event.put((EntityType)EAGLE_RAY.get(), EagleRayEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TROPI_SPIDER.get(), TropiSpiderEntity.func_234305_eI_().func_233813_a_());
        event.put((EntityType)TROPI_SPIDER_EGG.get(), EggEntity.createAttributes().func_233813_a_());
        event.put((EntityType)ASHEN.get(), AshenEntity.createAttributes().func_233813_a_());
        event.put((EntityType)HAMMERHEAD.get(), SharkEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SEA_TURTLE_EGG.get(), EggEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TROPI_BEE.get(), TropiBeeEntity.func_234182_eX_().func_233813_a_());
        event.put((EntityType)COWKTAIL.get(), CowktailEntity.func_234188_eI_().func_233813_a_());
        event.put((EntityType)MAN_O_WAR.get(), ManOWarEntity.createAttributes().func_233813_a_());
        event.put((EntityType)TAPIR.get(), TapirEntity.createAttributes().func_233813_a_());
        event.put((EntityType)JAGUAR.get(), JaguarEntity.createAttributes().func_233813_a_());
        event.put((EntityType)BROWN_BASILISK_LIZARD.get(), BasiliskLizardEntity.createAttributes().func_233813_a_());
        event.put((EntityType)GREEN_BASILISK_LIZARD.get(), BasiliskLizardEntity.createAttributes().func_233813_a_());
        event.put((EntityType)HUMMINGBIRD.get(), HummingbirdEntity.createAttributes().func_233813_a_());
        event.put((EntityType)FIDDLER_CRAB.get(), FiddlerCrabEntity.createAttributes().func_233813_a_());
        event.put((EntityType)SPIDER_MONKEY.get(), SpiderMonkeyEntity.createAttributes().func_233813_a_());
        event.put((EntityType)WHITE_LIPPED_PECCARY.get(), WhiteLippedPeccaryEntity.createAttributes().func_233813_a_());
        event.put((EntityType)CUBERA.get(), CuberaEntity.createAttributes().func_233813_a_());
    }
}

