/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class SeaTurtleEntity
extends TurtleEntity {
    private static final DataParameter<Boolean> IS_MATURE = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TURTLE_TYPE = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> NO_BRAKES = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAN_FLY = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIGGING = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_EGG = EntityDataManager.func_187226_a(SeaTurtleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final int NUM_TYPES = 6;
    private double lastPosY;
    private int digCounter;
    private float swimSpeedCurrent;

    public SeaTurtleEntity(EntityType<? extends TurtleEntity> type, World world) {
        super(type, world);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.15f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData data, @Nullable CompoundNBT nbt) {
        this.setRandomTurtleType();
        this.lastPosY = this.func_226278_cu_();
        return super.func_213386_a(world, difficultyInstance, spawnReason, data, nbt);
    }

    protected void func_184651_r() {
        Optional<PrioritizedGoal> mateGoal;
        super.func_184651_r();
        GoalSelector goalSelector = (GoalSelector)ObfuscationReflectionHelper.getPrivateValue(MobEntity.class, (Object)((Object)this), (String)"field_70714_bg");
        Set goalSet = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)goalSelector, (String)"field_220892_d");
        Optional<PrioritizedGoal> eggGoal = goalSet.stream().filter(p -> p.func_220772_j().toString().contains("Egg")).findFirst();
        if (eggGoal.isPresent()) {
            goalSelector.func_85156_a(eggGoal.get().func_220772_j());
            goalSelector.func_75776_a(1, (Goal)new BetterLayEggGoal(this, 1.0));
        }
        if ((mateGoal = goalSet.stream().filter(p -> p.func_220772_j().toString().contains("Mate")).findFirst()).isPresent()) {
            goalSelector.func_85156_a(mateGoal.get().func_220772_j());
            goalSelector.func_75776_a(1, (Goal)new BetterMateGoal(this, 1.0));
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_MATURE, (Object)true);
        this.func_184212_Q().func_187214_a(TURTLE_TYPE, (Object)1);
        this.func_184212_Q().func_187214_a(NO_BRAKES, (Object)false);
        this.func_184212_Q().func_187214_a(CAN_FLY, (Object)false);
        this.func_184212_Q().func_187214_a(IS_DIGGING, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_EGG, (Object)false);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("TurtleType", this.getTurtleType());
        nbt.func_74757_a("IsMature", this.isMature());
        nbt.func_74757_a("NoBrakesOnThisTrain", this.getNoBrakes());
        nbt.func_74757_a("LongsForTheSky", this.getCanFly());
        nbt.func_74757_a("HasEgg", this.func_203020_dx());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("TurtleType")) {
            this.setTurtleType(nbt.func_74762_e("TurtleType"));
        } else {
            this.setRandomTurtleType();
        }
        if (nbt.func_74764_b("IsMature")) {
            this.setIsMature(nbt.func_74767_n("IsMature"));
        } else {
            this.setIsMature(true);
        }
        this.setNoBrakes(nbt.func_74767_n("NoBrakesOnThisTrain"));
        this.setCanFly(nbt.func_74767_n("LongsForTheSky"));
        this.setHasEgg(nbt.func_74767_n("HasEgg"));
        this.lastPosY = this.func_226278_cu_();
    }

    public boolean isMature() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_MATURE);
    }

    public SeaTurtleEntity setIsMature(boolean mature) {
        this.func_184212_Q().func_187227_b(IS_MATURE, (Object)mature);
        return this;
    }

    public int getTurtleType() {
        return (Integer)this.func_184212_Q().func_187225_a(TURTLE_TYPE);
    }

    public void setRandomTurtleType() {
        this.setTurtleType(this.field_70146_Z.nextInt(6) + 1);
    }

    public SeaTurtleEntity setTurtleType(int type) {
        this.func_184212_Q().func_187227_b(TURTLE_TYPE, (Object)MathHelper.func_76125_a((int)type, (int)1, (int)6));
        return this;
    }

    public boolean getNoBrakes() {
        return (Boolean)this.func_184212_Q().func_187225_a(NO_BRAKES);
    }

    public SeaTurtleEntity setNoBrakes(boolean noBrakes) {
        this.func_184212_Q().func_187227_b(NO_BRAKES, (Object)noBrakes);
        return this;
    }

    public boolean getCanFly() {
        return (Boolean)this.func_184212_Q().func_187225_a(CAN_FLY);
    }

    public SeaTurtleEntity setCanFly(boolean canFly) {
        this.func_184212_Q().func_187227_b(CAN_FLY, (Object)canFly);
        return this;
    }

    @Nullable
    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public static boolean canSpawnOnLand(EntityType<SeaTurtleEntity> turtle, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() < TropicraftDimension.getSeaLevel((IWorldReader)world) + 4 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m && world.func_226659_b_(pos, 0) > 8;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.1;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity partner) {
        return ((SeaTurtleEntity)((EntityType)TropicraftEntities.SEA_TURTLE.get()).func_200721_a(this.field_70170_p)).setTurtleType(this.field_70146_Z.nextBoolean() && partner instanceof SeaTurtleEntity ? ((SeaTurtleEntity)partner).getTurtleType() : this.getTurtleType()).setIsMature(false);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ActionResultType result = super.func_230254_b_(player, hand);
        if (result != ActionResultType.PASS) {
            return result;
        }
        if (!this.field_70170_p.field_72995_K && !player.func_225608_bj_() && this.func_184219_q((Entity)player) && this.isMature()) {
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_145770_h(double x, double y, double z) {
        Entity controller = this.func_184179_bs();
        if (controller != null) {
            return controller.func_145770_h(x, y, z);
        }
        return super.func_145770_h(x, y, z);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.lastPosY = this.func_226278_cu_();
    }

    public void func_70636_d() {
        BlockPos pos;
        super.func_70636_d();
        if (this.func_70089_S() && this.func_203023_dy() && this.digCounter >= 1 && this.digCounter % 5 == 0 && this.field_70170_p.func_180495_p((pos = this.func_233580_cy_()).func_177977_b()).func_185904_a() == Material.field_151595_p) {
            this.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)Blocks.field_150354_m.func_176223_P()));
        }
        if (this.field_70170_p.field_72995_K && this.func_184207_aI() && this.func_82171_bF() && (this.func_70090_H() || this.getCanFly())) {
            Vector3d movement = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_178786_a(this.field_70169_q, this.field_70167_r, this.field_70166_s);
            double speed = movement.func_72433_c();
            Vector3d particleOffset = movement.func_216371_e().func_186678_a(2.0);
            if (speed > 0.05) {
                int maxParticles = MathHelper.func_76143_f((double)(speed * 5.0));
                int particlesToSpawn = this.field_70146_Z.nextInt(1 + maxParticles);
                BasicParticleType particle = this.func_70090_H() ? ParticleTypes.field_197612_e : ParticleTypes.field_197624_q;
                for (int i = 0; i < particlesToSpawn; ++i) {
                    Vector3d particleMotion = movement.func_186678_a(1.0);
                    this.field_70170_p.func_195590_a((IParticleData)particle, true, particleOffset.func_82615_a() + this.func_226277_ct_() - 0.25 + this.field_70146_Z.nextDouble() * 0.5, particleOffset.func_82617_b() + this.func_226278_cu_() + 0.1 + this.field_70146_Z.nextDouble() * 0.1, particleOffset.func_82616_c() + this.func_226281_cx_() - 0.25 + this.field_70146_Z.nextDouble() * 0.5, particleMotion.field_72450_a, particleMotion.field_72448_b, particleMotion.field_72449_c);
                }
            }
        }
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * MathHelper.func_76142_g((float)(x2 - x1));
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            if (passenger instanceof PlayerEntity) {
                PlayerEntity p = (PlayerEntity)passenger;
                if (this.func_70090_H()) {
                    if (p.field_191988_bg > 0.0f) {
                        this.field_70125_A = this.lerp(this.field_70125_A, -(passenger.field_70125_A * 0.5f), 6.0f);
                        this.field_70177_z = this.lerp(this.field_70177_z, -passenger.field_70177_z, 6.0f);
                        this.swimSpeedCurrent += 0.05f;
                        if (this.swimSpeedCurrent > 4.0f) {
                            this.swimSpeedCurrent = 4.0f;
                        }
                    }
                    if (p.field_191988_bg < 0.0f) {
                        this.swimSpeedCurrent *= 0.89f;
                        if (this.swimSpeedCurrent < 0.1f) {
                            this.swimSpeedCurrent = 0.1f;
                        }
                    }
                    if (p.field_191988_bg == 0.0f) {
                        if (this.swimSpeedCurrent > 1.0f) {
                            this.swimSpeedCurrent *= 0.94f;
                            if (this.swimSpeedCurrent <= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                        if (this.swimSpeedCurrent < 1.0f) {
                            this.swimSpeedCurrent *= 1.06f;
                            if (this.swimSpeedCurrent >= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                    }
                }
            } else if (passenger instanceof MobEntity) {
                MobEntity mobentity = (MobEntity)passenger;
                this.field_70761_aq = mobentity.field_70761_aq;
                this.field_70758_at = mobentity.field_70758_at;
            }
        }
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_213352_e(Vector3d input) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                Entity controllingPassenger = this.func_184179_bs();
                if (!(controllingPassenger instanceof LivingEntity)) {
                    return;
                }
                LivingEntity controllingEntity = (LivingEntity)controllingPassenger;
                this.field_70126_B = this.field_70177_z = controllingPassenger.field_70177_z;
                this.field_70125_A = controllingPassenger.field_70125_A;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                float strafe = controllingEntity.field_70702_br;
                float forward = this.getNoBrakes() ? 1.0f : controllingEntity.field_191988_bg;
                float vertical = controllingEntity.field_70701_bs;
                double verticalFromPitch = -Math.sin(Math.toRadians(this.field_70125_A)) * (double)forward;
                forward *= MathHelper.func_76131_a((float)(1.0f - Math.abs(this.field_70125_A) / 90.0f), (float)0.01f, (float)1.0f);
                if (!this.func_70090_H()) {
                    if (this.getCanFly()) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111126_e() * 0.05, 0.0));
                    } else {
                        this.func_213317_d(this.func_213322_ci().func_216372_d(0.9, 0.99, 0.9).func_72441_c(0.0, -this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111126_e(), 0.0));
                    }
                }
                if (this.func_184186_bw()) {
                    Vector3d travel = new Vector3d((double)strafe, verticalFromPitch + (double)vertical, (double)forward).func_186678_a(this.func_110148_a(Attributes.field_233821_d_).func_111126_e()).func_186678_a((double)0.025f);
                    this.func_213309_a(1.0f, travel);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(forward > 0.0f || !this.func_70090_H() ? 0.975 : 0.9));
                } else {
                    this.field_70143_R = (float)Math.max(0.0, (this.func_226278_cu_() - this.lastPosY) * -8.0);
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.func_226277_ct_() - this.field_70169_q;
                double d0 = this.func_226281_cx_() - this.field_70166_s;
                float swinger = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (swinger > 1.0f) {
                    swinger = 1.0f;
                }
                this.field_70721_aZ += (swinger - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(input);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)TropicraftItems.SEA_TURTLE_SPAWN_EGG.get());
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    private void setDigging(boolean digging) {
        this.digCounter = digging ? 1 : 0;
        this.field_70180_af.func_187227_b(IS_DIGGING, (Object)digging);
    }

    public boolean func_203023_dy() {
        return this.digCounter > 0;
    }

    private void setHasEgg(boolean hasEgg) {
        this.field_70180_af.func_187227_b(HAS_EGG, (Object)hasEgg);
    }

    public boolean func_203020_dx() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EGG);
    }

    static class BetterMateGoal
    extends BreedGoal {
        private final SeaTurtleEntity turtle;

        BetterMateGoal(SeaTurtleEntity turtle, double speedIn) {
            super((AnimalEntity)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.turtle.func_203020_dx();
        }

        protected void func_75388_i() {
            ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
            if (serverplayerentity == null && this.field_75391_e.func_191993_do() != null) {
                serverplayerentity = this.field_75391_e.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.field_75390_d, this.field_75391_e, null);
            }
            this.turtle.setHasEgg(true);
            this.field_75390_d.func_70875_t();
            this.field_75391_e.func_70875_t();
            Random random = this.field_75390_d.func_70681_au();
            if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.field_75394_a.func_217376_c((Entity)new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), random.nextInt(7) + 1));
            }
        }
    }

    static class BetterLayEggGoal
    extends MoveToBlockGoal {
        private final SeaTurtleEntity turtle;

        BetterLayEggGoal(SeaTurtleEntity turtle, double speedIn) {
            super((CreatureEntity)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public boolean func_75250_a() {
            return this.turtle.func_203020_dx() && this.turtle.func_203018_dA().func_218137_a((IPosition)this.turtle.func_213303_ch(), 9.0) && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.turtle.func_203020_dx() && this.turtle.func_203018_dA().func_218137_a((IPosition)this.turtle.func_213303_ch(), 9.0);
        }

        public void func_75246_d() {
            super.func_75246_d();
            BlockPos blockpos = this.turtle.func_233580_cy_();
            if (!this.turtle.func_70090_H() && this.func_179487_f()) {
                if (!this.turtle.func_203023_dy()) {
                    this.turtle.setDigging(true);
                } else if (this.turtle.digCounter > 200) {
                    World world = this.turtle.field_70170_p;
                    world.func_184133_a(null, blockpos, SoundEvents.field_203278_iw, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
                    SeaTurtleEggEntity egg = (SeaTurtleEggEntity)((EntityType)TropicraftEntities.SEA_TURTLE_EGG.get()).func_200721_a(world);
                    BlockPos spawnPos = this.field_179494_b.func_177984_a();
                    egg.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                    world.func_217376_c((Entity)egg);
                    this.turtle.setHasEgg(false);
                    this.turtle.setDigging(false);
                    this.turtle.func_204700_e(600);
                }
                if (this.turtle.func_203023_dy()) {
                    this.turtle.digCounter++;
                }
            }
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            return worldIn.func_180495_p(pos).func_185904_a() == Material.field_151595_p;
        }
    }
}

