/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class MangroveSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final SurfaceBuilderConfig MUD = new SurfaceBuilderConfig(((Block)TropicraftBlocks.MUD.get()).func_176223_P(), Blocks.field_150346_d.func_176223_P(), ((Block)TropicraftBlocks.MUD.get()).func_176223_P());
    private PerlinNoiseGenerator mudNoise;
    private PerlinNoiseGenerator streamNoise;
    private long seed;

    public MangroveSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        boolean muddy;
        double streamNoise = this.streamNoise.func_215464_a((double)x * 0.025, (double)z * 0.025, false);
        double mudNoise = this.mudNoise.func_215464_a((double)x * 0.03125, (double)z * 0.03125, false);
        boolean bl = muddy = mudNoise > -0.1;
        if (streamNoise > -0.1 && streamNoise < 0.1) {
            this.placeStream(chunk, x, z, startHeight, defaultFluid, seaLevel);
        }
        if (streamNoise > -0.2 && streamNoise < 0.2) {
            double chance = 1.0 - Math.abs(streamNoise) * 5.0;
            muddy = random.nextDouble() > chance;
        }
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)(muddy ? MUD : config));
    }

    private void placeStream(IChunk chunk, int x, int z, int startHeight, BlockState defaultFluid, int seaLevel) {
        int localX = x & 0xF;
        int localZ = z & 0xF;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int y = startHeight; y >= 0; --y) {
            mutablePos.func_181079_c(localX, y, localZ);
            if (chunk.func_180495_p((BlockPos)mutablePos).func_196958_f()) continue;
            if (y + 1 != seaLevel || chunk.func_180495_p((BlockPos)mutablePos).func_203425_a(defaultFluid.func_177230_c())) break;
            chunk.func_177436_a((BlockPos)mutablePos, defaultFluid, false);
            break;
        }
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.mudNoise == null) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.mudNoise = new PerlinNoiseGenerator(random, IntStream.rangeClosed(0, 2));
            this.streamNoise = new PerlinNoiseGenerator(random, IntStream.rangeClosed(0, 2));
        }
        this.seed = seed;
    }
}

