/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.layer;

import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.tropicraft.core.common.dimension.layer.TropicraftAddInlandLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftAddIslandLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftAddSubBiomesLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftAddWeightedSubBiomesLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftApplyOsaLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftBeachLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftBiomeIds;
import net.tropicraft.core.common.dimension.layer.TropicraftBiomesLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftLookupLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftMangroveLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftRiverInitLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftRiverLayer;
import net.tropicraft.core.common.dimension.layer.TropicraftRiverMixLayer;
import net.tropicraft.core.common.dimension.layer.TropicsIslandLayer;

public class TropicraftLayerUtil {
    public static Layer buildTropicsProcedure(long seed, Registry<Biome> biomes) {
        TropicraftBiomeIds biomeIds = new TropicraftBiomeIds(biomes);
        IAreaFactory noiseLayer = TropicraftLayerUtil.buildTropicsProcedure(biomeIds, (long procedure) -> new LazyAreaLayerContext(25, seed, procedure));
        return new TropicraftLookupLayer(noiseLayer);
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> buildTropicsProcedure(TropicraftBiomeIds biomeIds, LongFunction<C> context) {
        IAreaFactory islandLayer = new TropicsIslandLayer(biomeIds).func_202823_a((IExtendedNoiseRandom)context.apply(1L));
        IAreaFactory fuzzyZoomLayer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)context.apply(2000L), islandLayer);
        IAreaFactory addIslandLayer = TropicraftAddIslandLayer.basic3(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(3L), fuzzyZoomLayer);
        IAreaFactory zoomLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2000L), addIslandLayer);
        IAreaFactory oceanLayer = new TropicraftAddInlandLayer(20, biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(9L), zoomLayer);
        oceanLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(9L), oceanLayer);
        addIslandLayer = TropicraftAddIslandLayer.rainforest13(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(6L), oceanLayer);
        zoomLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2001L), addIslandLayer);
        zoomLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2004L), zoomLayer);
        addIslandLayer = TropicraftAddIslandLayer.basic2(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(8L), zoomLayer);
        IAreaFactory biomeLayerGen = new TropicraftBiomesLayer(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(15L), addIslandLayer);
        IAreaFactory oceanLayerGen = TropicraftAddWeightedSubBiomesLayer.ocean(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(16L), biomeLayerGen);
        IAreaFactory hillsLayerGen = TropicraftAddSubBiomesLayer.rainforest(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(17L), oceanLayerGen);
        IAreaFactory mangroveLayer = new TropicraftMangroveLayer(biomeIds, 4).func_202713_a((IExtendedNoiseRandom)context.apply(18L), hillsLayerGen);
        mangroveLayer = new TropicraftApplyOsaLayer(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(53L), mangroveLayer);
        IAreaFactory riverLayer = zoomLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2002L), mangroveLayer);
        riverLayer = new TropicraftRiverInitLayer(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(12L), riverLayer);
        riverLayer = TropicraftLayerUtil.magnify(2007L, (IAreaTransformer1)ZoomLayer.NORMAL, riverLayer, 5, context);
        riverLayer = new TropicraftRiverLayer(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(13L), riverLayer);
        riverLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2008L), riverLayer);
        IAreaFactory<T> magnifyLayer = TropicraftLayerUtil.magnify(2007L, (IAreaTransformer1)ZoomLayer.NORMAL, zoomLayer, 2, context);
        magnifyLayer = TropicraftAddSubBiomesLayer.mangroves(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(12L), magnifyLayer);
        magnifyLayer = TropicraftLayerUtil.magnify(3007L, (IAreaTransformer1)ZoomLayer.NORMAL, magnifyLayer, 1, context);
        IAreaFactory biomeLayer = new TropicraftBeachLayer(biomeIds).func_202713_a((IExtendedNoiseRandom)context.apply(20L), magnifyLayer);
        biomeLayer = TropicraftLayerUtil.magnify(20L, (IAreaTransformer1)ZoomLayer.NORMAL, biomeLayer, 2, context);
        biomeLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(17L), biomeLayer);
        biomeLayer = new TropicraftRiverMixLayer(biomeIds).func_202707_a((IExtendedNoiseRandom)context.apply(17L), biomeLayer, riverLayer);
        return biomeLayer;
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> magnify(long seed, IAreaTransformer1 zoomLayer, IAreaFactory<T> layer, int count, LongFunction<C> context) {
        IAreaFactory result = layer;
        for (int i = 0; i < count; ++i) {
            result = zoomLayer.func_202713_a((IExtendedNoiseRandom)context.apply(seed + (long)i), result);
        }
        return result;
    }
}

