/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public class SmallMangroveTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<SmallMangroveTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SmallMangroveTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and((App)Registry.field_212618_g.fieldOf("roots_block").forGetter(c -> c.rootsBlock)).apply((Applicative)instance, SmallMangroveTrunkPlacer::new));
    private final Block rootsBlock;

    public SmallMangroveTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Block rootsBlock) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootsBlock = rootsBlock;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TropicraftTrunkPlacers.SMALL_MANGROVE;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int height, BlockPos origin, Set<BlockPos> logs, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        SmallMangroveTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)origin.func_177977_b());
        for (int i = 0; i < height; ++i) {
            SmallMangroveTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)origin.func_177981_b(i), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
        }
        this.generateRoots(world, random, origin, 0);
        return ImmutableList.of((Object)new FoliagePlacer.Foliage(origin.func_177981_b(height - 1), 1, false));
    }

    private void generateRoots(IWorldGenerationReader world, Random random, BlockPos origin, int depth) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offset = origin.func_177972_a(direction);
            if (!world.func_217375_a(offset, AbstractBlock.AbstractBlockState::func_196958_f) || !world.func_217375_a(offset.func_177977_b(), state -> state.func_185904_a().func_76218_k())) continue;
            TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)offset, (BlockState)this.rootsBlock.func_176223_P());
            if (depth >= 2 || random.nextInt(depth + 2) != 0) continue;
            this.generateRoots(world, random, offset, depth + 1);
        }
    }
}

