/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTrunkPlacer;

public class PneumatophoresTreeDecorator
extends TreeDecorator {
    public static final Codec<PneumatophoresTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("roots_block").forGetter(c -> c.rootsBlock), (App)Codec.INT.fieldOf("min_count").forGetter(c -> c.minCount), (App)Codec.INT.fieldOf("max_count").forGetter(c -> c.maxCount), (App)Codec.INT.fieldOf("spread").forGetter(c -> c.spread)).apply((Applicative)instance, PneumatophoresTreeDecorator::new));
    private final Block rootsBlock;
    private final int minCount;
    private final int maxCount;
    private final int spread;

    public PneumatophoresTreeDecorator(Block rootsBlock, int minCount, int maxCount, int spread) {
        this.rootsBlock = rootsBlock;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.spread = spread;
    }

    protected TreeDecoratorType<?> func_230380_a_() {
        return (TreeDecoratorType)TropicraftTreeDecorators.PNEUMATOPHORES.get();
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> logs, List<BlockPos> leaves, Set<BlockPos> placed, MutableBoundingBox box) {
        BlockPos origin = Util.findLowestBlock(logs);
        if (origin == null) {
            return;
        }
        int spread = this.spread;
        int count = random.nextInt(this.maxCount - this.minCount + 1) + this.minCount;
        int maxTopY = origin.func_177956_o() + 3;
        int minBottomY = origin.func_177956_o() - 6;
        BlockPos.Mutable mutablePos = origin.func_239590_i_();
        while (MangroveTrunkPlacer.isWaterAt((IWorldGenerationReader)world, (BlockPos)mutablePos) && mutablePos.func_177956_o() < maxTopY) {
            mutablePos.func_189536_c(Direction.UP);
        }
        int topY = mutablePos.func_177956_o();
        for (int i = 0; i < count; ++i) {
            int y;
            int dx = random.nextInt(spread) - random.nextInt(spread);
            int dz = random.nextInt(spread) - random.nextInt(spread);
            if (dx == 0 && dz == 0) continue;
            mutablePos.func_239621_a_((Vector3i)origin, dx, 0, dz);
            boolean canGenerate = false;
            int minY = minBottomY;
            for (y = topY; y >= minBottomY; --y) {
                mutablePos.func_185336_p(y);
                if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)mutablePos)) continue;
                canGenerate = true;
                minY = y;
                break;
            }
            if (!canGenerate) continue;
            y = topY;
            while (y >= minY) {
                mutablePos.func_185336_p(y--);
                MangroveTrunkPlacer.setRootsAt((IWorldGenerationReader)world, (BlockPos)mutablePos, this.rootsBlock);
            }
        }
    }
}

