/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public final class MangroveTrunkPlacer
extends FancyTrunkPlacer {
    public static final Codec<MangroveTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> MangroveTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and((App)Registry.field_212618_g.fieldOf("roots_block").forGetter(c -> c.rootsBlock)).and((App)Codec.BOOL.fieldOf("can_generate_raised").forGetter(c -> c.canGenerateRaised)).and((App)Codec.BOOL.fieldOf("tea_mangrove").forGetter(c -> c.teaMangrove)).apply((Applicative)instance, MangroveTrunkPlacer::new));
    private static final int MIN_LENGTH = 2;
    private static final int MAX_LENGTH = 4;
    private static final int MAX_RADIUS = 4;
    private static final int MAX_SIZE = 9;
    private final Block rootsBlock;
    private final boolean canGenerateRaised;
    private final boolean teaMangrove;

    public MangroveTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Block rootsBlock, boolean canGenerateRaised, boolean teaMangrove) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootsBlock = rootsBlock;
        this.canGenerateRaised = canGenerateRaised;
        this.teaMangrove = teaMangrove;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TropicraftTrunkPlacers.MANGROVE;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int height, BlockPos origin, Set<BlockPos> logs, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        int waterDepth;
        int rootLength = MathHelper.func_76125_a((int)(height - 5), (int)2, (int)4);
        boolean placeDirtOnOrigin = true;
        if (this.canGenerateRaised && (waterDepth = this.getWaterDepthAbove(world, origin, 3)) <= 2 && random.nextInt(2) == 0) {
            int surfaceY = origin.func_177956_o() + waterDepth;
            origin = new BlockPos(origin.func_177958_n(), surfaceY + 1, origin.func_177952_p());
            placeDirtOnOrigin = false;
        }
        RootSystem roots = new RootSystem();
        if (this.teaMangrove) {
            this.growTeaRoots(roots, rootLength);
        } else {
            this.growRoots(roots, random, rootLength);
        }
        this.placeRoots(world, origin, rootLength, roots);
        if (placeDirtOnOrigin) {
            MangroveTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)origin.func_177977_b());
        }
        for (int i = 0; i < height; ++i) {
            MangroveTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)origin.func_177981_b(i), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
        }
        ArrayList<FoliagePlacer.Foliage> leafNodes = new ArrayList<FoliagePlacer.Foliage>();
        leafNodes.add(new FoliagePlacer.Foliage(origin.func_177981_b(height), 1, false));
        this.growBranches(world, random, height, origin, logs, bounds, config, leafNodes);
        return leafNodes;
    }

    private int getWaterDepthAbove(IWorldGenerationReader world, BlockPos origin, int maxDepth) {
        int depth;
        BlockPos.Mutable pos = origin.func_239590_i_();
        for (depth = 0; depth <= maxDepth; ++depth) {
            pos.func_185336_p(origin.func_177956_o() + depth);
            if (!MangroveTrunkPlacer.isWaterAt(world, (BlockPos)pos)) break;
        }
        return depth;
    }

    private void growBranches(IWorldGenerationReader world, Random random, int height, BlockPos origin, Set<BlockPos> logs, MutableBoundingBox bounds, BaseTreeFeatureConfig config, List<FoliagePlacer.Foliage> leafNodes) {
        int count = 2 + random.nextInt(3);
        Direction lastDirection = null;
        block0: for (int i = 0; i < count; ++i) {
            Direction direction;
            BlockPos base = origin.func_177981_b(height - count + i);
            int length = 1 + random.nextInt(2);
            boolean hasBranch = false;
            while ((direction = Direction.Plane.HORIZONTAL.func_179518_a(random)) == lastDirection) {
            }
            lastDirection = direction;
            for (int j = 1; j <= length + 1; ++j) {
                if (j == length) {
                    MangroveTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)base.func_177967_a(direction, j).func_177984_a(), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
                    leafNodes.add(new FoliagePlacer.Foliage(base.func_177967_a(direction, j).func_177984_a(), random.nextInt(2), false));
                    continue block0;
                }
                if (!hasBranch && random.nextBoolean()) {
                    hasBranch = true;
                    Direction branchBranchDir = random.nextBoolean() ? direction.func_176746_e() : direction.func_176735_f();
                    MangroveTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)base.func_177967_a(direction, j).func_177972_a(branchBranchDir), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
                    leafNodes.add(new FoliagePlacer.Foliage(base.func_177967_a(direction, j).func_177972_a(branchBranchDir), 0, false));
                }
                MangroveTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)base.func_177967_a(direction, j), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
            }
        }
    }

    private void growRoots(RootSystem roots, Random random, int length) {
        RootGrower grower = new RootGrower(roots);
        grower.growAt(RootSystem.pos(-1, 0), RootSystem.seed(Direction.WEST));
        grower.growAt(RootSystem.pos(1, 0), RootSystem.seed(Direction.EAST));
        grower.growAt(RootSystem.pos(0, -1), RootSystem.seed(Direction.NORTH));
        grower.growAt(RootSystem.pos(0, 1), RootSystem.seed(Direction.SOUTH));
        while (grower.hasNext()) {
            int pos = grower.nextPos();
            int root = roots.get(pos);
            int distance = RootSystem.distance(root);
            if (distance >= length || random.nextInt(8) == 0) continue;
            Direction side = RootSystem.side(root);
            Direction flow = RootSystem.flow(root);
            if (random.nextInt((length - distance >> 1) + 1) == 0) {
                if (distance <= 1 || random.nextBoolean()) {
                    grower.growOut(pos, distance, side, flow);
                }
                grower.growOut(pos, distance, side, MangroveTrunkPlacer.nextFlow(random, flow));
                continue;
            }
            grower.growOut(pos, distance, side, flow);
        }
    }

    private static Direction nextFlow(Random random, Direction side) {
        switch (random.nextInt(3)) {
            case 0: {
                return side.func_176746_e();
            }
            case 1: {
                return side.func_176735_f();
            }
        }
        return side;
    }

    private void growTeaRoots(RootSystem roots, int length) {
        int radius = length / 2;
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                if (x == 0 && z == 0) continue;
                int distance = (Math.abs(x) + Math.abs(z) - 1) * 2;
                roots.set(RootSystem.pos(x, z), RootSystem.root(distance));
            }
        }
    }

    private void placeRoots(IWorldGenerationReader world, BlockPos origin, int rootLength, RootSystem roots) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int z = -4; z <= 4; ++z) {
            for (int x = -4; x <= 4; ++x) {
                int root = roots.get(RootSystem.pos(x, z));
                if (root == 0) continue;
                mutablePos.func_181079_c(origin.func_177958_n() + x, 0, origin.func_177952_p() + z);
                int rootHeight = rootLength - RootSystem.distance(root);
                if (rootHeight <= 0) continue;
                int maxY = origin.func_177956_o() + rootHeight;
                int minY = maxY - 8;
                int y = maxY;
                while (y >= minY) {
                    mutablePos.func_185336_p(y--);
                    if (this.setRootsAt(world, (BlockPos)mutablePos)) continue;
                }
            }
        }
    }

    private boolean setRootsAt(IWorldGenerationReader world, BlockPos pos) {
        return MangroveTrunkPlacer.setRootsAt(world, pos, this.rootsBlock);
    }

    public static boolean setRootsAt(IWorldGenerationReader world, BlockPos pos, Block rootsBlock) {
        if (MangroveTrunkPlacer.isReplaceableAt(world, pos)) {
            BlockState state = (BlockState)rootsBlock.func_176223_P().func_206870_a((Property)MangroveRootsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(MangroveTrunkPlacer.isWaterAt(world, pos)));
            TreeFeature.func_236408_b_((IWorldWriter)world, (BlockPos)pos, (BlockState)state);
            return true;
        }
        return false;
    }

    public static boolean isReplaceableAt(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_204868_h || state.func_185904_a() == Material.field_151585_k || state.func_203425_a(Blocks.field_150355_j) || state.func_235714_a_(TropicraftTags.Blocks.ROOTS));
    }

    public static boolean isWaterAt(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_204520_s().func_206886_c() == Fluids.field_204546_a);
    }

    static final class RootSystem {
        static final int NULL = 0;
        private final int[] map = new int[81];

        RootSystem() {
        }

        boolean set(int pos, int root) {
            if (!this.contains(pos)) {
                this.map[pos] = root;
                return true;
            }
            return false;
        }

        int get(int pos) {
            return this.map[pos];
        }

        boolean contains(int pos) {
            return this.get(pos) != 0;
        }

        static int pos(int x, int z) {
            return x + 4 + (z + 4) * 9;
        }

        static int offsetPos(int pos, int x, int z) {
            return pos + x + z * 9;
        }

        static int seed(Direction side) {
            return RootSystem.root(1, side, side);
        }

        static int root(int distance, Direction side, Direction flow) {
            return RootSystem.root(distance) | side.func_176736_b() << 3 | flow.func_176736_b() << 1;
        }

        static int root(int distance) {
            return distance << 5 | 1;
        }

        static int distance(int root) {
            return root >> 5;
        }

        static Direction side(int root) {
            return Direction.func_176731_b((int)(root >> 3 & 3));
        }

        static Direction flow(int root) {
            return Direction.func_176731_b((int)(root >> 1 & 3));
        }
    }

    static final class RootGrower {
        private final RootSystem roots;
        private final IntArrayFIFOQueue queue = new IntArrayFIFOQueue();

        RootGrower(RootSystem roots) {
            this.roots = roots;
        }

        boolean hasNext() {
            return !this.queue.isEmpty();
        }

        int nextPos() {
            return this.queue.dequeueInt();
        }

        void growOut(int pos, int distance, Direction side, Direction flow) {
            int growPos = RootSystem.offsetPos(pos, flow.func_82601_c(), flow.func_82599_e());
            this.growAt(growPos, RootSystem.root(distance + 1, side, flow));
        }

        void growAt(int pos, int root) {
            if (this.roots.set(pos, root)) {
                this.queue.enqueue(pos);
            }
        }
    }
}

