/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TualungFeature
extends RainforestTreeFeature {
    private int baseHeight;
    private int maxHeight;

    public TualungFeature(Codec<NoFeatureConfig> codec, int maxHeight, int baseHeight) {
        super(codec);
        this.baseHeight = baseHeight;
        this.maxHeight = maxHeight;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = pos.func_185334_h();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int height = rand.nextInt(this.maxHeight - this.baseHeight) + this.baseHeight + j;
        int branches = rand.nextInt(3) + 3;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), height - j)) {
            return false;
        }
        if (height + 6 > 256) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height - j)) {
            return false;
        }
        if (!this.getSapling().func_196260_a(this.getSapling().func_176223_P(), (IWorldReader)world, pos)) {
            return false;
        }
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.field_150346_d.func_176223_P());
        for (int y = j; y < height; ++y) {
            this.placeLog((IWorldGenerationReader)world, i, y, k);
            this.placeLog((IWorldGenerationReader)world, i - 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i + 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i, y, k - 1);
            this.placeLog((IWorldGenerationReader)world, i, y, k + 1);
        }
        for (int x = 0; x < branches; ++x) {
            int branchHeight = rand.nextInt(4) + 2 + height;
            int bx = rand.nextInt(15) - 8 + i;
            int bz = rand.nextInt(15) - 8 + k;
            this.placeBlockLine((IWorldGenerationReader)world, new int[]{i + this.sign((bx - i) / 2), height, k + this.sign((bz - k) / 2)}, new int[]{bx, branchHeight, bz}, this.getLog());
            this.genCircle((IWorldGenerationReader)world, bx, branchHeight, bz, 2.0, 1.0, this.getLeaf(), false);
            this.genCircle((IWorldGenerationReader)world, bx, branchHeight + 1, bz, 3.0, 2.0, this.getLeaf(), false);
        }
        return true;
    }

    private int sign(int i) {
        return i == 0 ? 0 : (i <= 0 ? -1 : 1);
    }
}

