/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.block.TropicraftBlocks;

public abstract class RainforestTreeFeature
extends Feature<NoFeatureConfig> {
    protected static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};

    public RainforestTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    protected void setState(IWorldWriter world, BlockPos pos, BlockState state) {
        this.setBlockStateInternally(world, pos, state);
    }

    private void setBlockStateInternally(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 19);
    }

    protected SaplingBlock getSapling() {
        return (SaplingBlock)TropicraftBlocks.MAHOGANY_SAPLING.get();
    }

    protected final BlockState getLeaf() {
        return ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).func_176223_P();
    }

    protected final BlockState getLog() {
        return ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).func_176223_P();
    }

    protected void placeLeaf(IWorldGenerationReader world, int x, int y, int z) {
        this.setState((IWorldWriter)world, new BlockPos(x, y, z), this.getLeaf());
    }

    protected void placeLog(IWorldGenerationReader world, int x, int y, int z) {
        this.setState((IWorldWriter)world, new BlockPos(x, y, z), this.getLog());
    }

    protected boolean genCircle(IWorldGenerationReader world, int x, int y, int z, double outerRadius, double innerRadius, BlockState state, boolean solid) {
        return this.genCircle(world, new BlockPos(x, y, z), outerRadius, innerRadius, state, solid);
    }

    protected boolean genVines(IWorldGenerationReader world, Random rand, int i, int j, int k) {
        BlockPos pos;
        int m = 2;
        while (true) {
            if (m > 5) {
                return false;
            }
            pos = new BlockPos(i, j, k);
            if (RainforestTreeFeature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)pos)) break;
            ++m;
        }
        this.setBlockStateInternally((IWorldWriter)world, pos, Blocks.field_150395_bd.func_176223_P());
        int length = rand.nextInt(4) + 4;
        for (int y = j - 1; y > j - length; --y) {
            BlockPos vinePos = new BlockPos(i, y, k);
            if (!RainforestTreeFeature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)vinePos)) {
                return true;
            }
            this.setBlockStateInternally((IWorldWriter)world, vinePos, Blocks.field_150395_bd.func_176223_P());
        }
        return true;
    }

    public ArrayList<int[]> placeBlockLine(IWorldGenerationReader world, int[] ai, int[] ai1, BlockState state) {
        ArrayList<int[]> places = new ArrayList<int[]>();
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return null;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            BlockPos pos = new BlockPos(ai3[0], ai3[1], ai3[2]);
            this.setState((IWorldWriter)world, pos, state);
            places.add(new int[]{ai3[0], ai3[1], ai3[2]});
        }
        return places;
    }

    public boolean genCircle(IWorldGenerationReader world, BlockPos pos, double outerRadius, double innerRadius, BlockState state, boolean solid) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean hasGenned = false;
        for (int i = (int)(-outerRadius - 1.0) + x; i <= (int)(outerRadius + 1.0) + x; ++i) {
            for (int k = (int)(-outerRadius - 1.0) + z; k <= (int)(outerRadius + 1.0) + z; ++k) {
                BlockPos pos2;
                double d = (i - x) * (i - x) + (k - z) * (k - z);
                if (!(d <= outerRadius * outerRadius) || !(d >= innerRadius * innerRadius) || !RainforestTreeFeature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)(pos2 = new BlockPos(i, y, k))) && !solid || !world.func_180501_a(pos2, state, 3)) continue;
                hasGenned = true;
            }
        }
        return hasGenned;
    }
}

