/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;

public final class PapayaFoliagePlacer
extends FoliagePlacer {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Codec<PapayaFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> PapayaFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PapayaFoliagePlacer::new));

    public PapayaFoliagePlacer(FeatureSpread radius, FeatureSpread offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return (FoliagePlacerType)TropicraftFoliagePlacers.PAPAYA.get();
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random random, BaseTreeFeatureConfig config, int p_230372_4_, FoliagePlacer.Foliage node, int p_230372_6_, int radius, Set<BlockPos> leaves, int p_230372_9_, MutableBoundingBox bounds) {
        this.func_236753_a_(world, random, config, node.func_236763_a_(), 1, leaves, 1, node.func_236765_c_(), bounds);
        BlockPos origin = node.func_236763_a_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 0; ++y) {
                    if (y == -1 && Math.abs(x) == 1 && Math.abs(z) == 1 && random.nextBoolean()) continue;
                    BlockPos local = origin.func_177982_a(x, y, z);
                    PapayaFoliagePlacer.set(world, local, random, config, leaves, bounds);
                }
            }
        }
        for (Direction direction : DIRECTIONS) {
            PapayaFoliagePlacer.set(world, origin.func_177967_a(direction, 2), random, config, leaves, bounds);
            PapayaFoliagePlacer.set(world, origin.func_177967_a(direction, 3), random, config, leaves, bounds);
            PapayaFoliagePlacer.set(world, origin.func_177967_a(direction, 3).func_177977_b(), random, config, leaves, bounds);
            PapayaFoliagePlacer.set(world, origin.func_177967_a(direction, 4).func_177977_b(), random, config, leaves, bounds);
        }
    }

    private static void set(IWorldGenerationReader world, BlockPos pos, Random random, BaseTreeFeatureConfig config, Set<BlockPos> leaves, MutableBoundingBox bounds) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            world.func_180501_a(pos, config.field_227369_n_.func_225574_a_(random, pos), 19);
            bounds.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
            leaves.add(pos);
        }
    }

    public int func_230374_a_(Random random, int p_230374_2_, BaseTreeFeatureConfig config) {
        return 0;
    }

    protected boolean func_230373_a_(Random random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return radius != 0 && dx == radius && dz == radius;
    }
}

