/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.config.FruitTreeConfig;

public class FruitTreeFeature
extends Feature<FruitTreeConfig> {
    public FruitTreeFeature(Codec<FruitTreeConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FruitTreeConfig config) {
        int y;
        pos = pos.func_185334_h();
        int height = rand.nextInt(3) + 4;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        BlockState sapling = config.sapling;
        if (!sapling.func_196955_c((IWorldReader)world, pos)) {
            return false;
        }
        this.setDirtAt((IWorldGenerationReader)world, pos.func_177977_b());
        for (y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int presizeMod = y - (pos.func_177956_o() + height);
            int size = 1 - presizeMod / 2;
            for (int x = pos.func_177958_n() - size; x <= pos.func_177958_n() + size; ++x) {
                int localX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - size; z <= pos.func_177952_p() + size; ++z) {
                    int localZ = z - pos.func_177952_p();
                    if (Math.abs(localX) == size && Math.abs(localZ) == size && (rand.nextInt(2) == 0 || presizeMod == 0) || !TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)new BlockPos(x, y, z))) continue;
                    BlockPos leafPos = new BlockPos(x, y, z);
                    if (rand.nextBoolean()) {
                        this.func_230367_a_((IWorldWriter)world, leafPos, config.fruitLeaves);
                        continue;
                    }
                    this.func_230367_a_((IWorldWriter)world, leafPos, config.leaves);
                }
            }
        }
        for (y = 0; y < height; ++y) {
            BlockPos logPos = pos.func_177981_b(y);
            if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)logPos)) continue;
            this.func_230367_a_((IWorldWriter)world, logPos, config.wood);
        }
        return true;
    }

    protected static boolean isDirt(IWorldGenerationBaseReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return FruitTreeFeature.func_227250_b_((Block)block) && block != Blocks.field_196658_i && block != Blocks.field_150391_bh;
        });
    }

    protected void setDirt(IWorldGenerationReader world, BlockPos pos) {
        if (!FruitTreeFeature.isDirt((IWorldGenerationBaseReader)world, pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    protected void setDirtAt(IWorldGenerationReader reader, BlockPos pos) {
        this.setDirt(reader, pos);
    }
}

