/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw.piece;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawOrientation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.PieceWithGenerationBounds;

public final class HomeTreeBranchPiece
extends JigsawPiece
implements PieceWithGenerationBounds {
    public static final Codec<HomeTreeBranchPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_angle").forGetter(c -> Float.valueOf(c.minAngle)), (App)Codec.FLOAT.fieldOf("max_angle").forGetter(c -> Float.valueOf(c.maxAngle))).apply((Applicative)instance, HomeTreeBranchPiece::new));
    private static final int MAX_SIZE = 32;
    private static final Direction.Axis[] ALL_AXIS = Direction.Axis.values();
    private static final IJigsawDeserializer<HomeTreeBranchPiece> TYPE = IJigsawDeserializer.func_236851_a_((String)"tropicraft:home_tree_branch", CODEC);
    private static final CompoundNBT JIGSAW_NBT = HomeTreeBranchPiece.createJigsawNbt();
    public final float minAngle;
    public final float maxAngle;

    public HomeTreeBranchPiece(float minAngle, float maxAngle) {
        super(JigsawPattern.PlacementBehaviour.RIGID);
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
    }

    public static Function<JigsawPattern.PlacementBehaviour, HomeTreeBranchPiece> create(float minAngle, float maxAngle) {
        return placementBehaviour -> new HomeTreeBranchPiece(minAngle, maxAngle);
    }

    private static CompoundNBT createJigsawNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", "minecraft:bottom");
        nbt.func_74778_a("final_state", "minecraft:air");
        nbt.func_74778_a("pool", "minecraft:empty");
        nbt.func_74778_a("target", "minecraft:empty");
        nbt.func_74778_a("joint", JigsawTileEntity.OrientationType.ROLLABLE.func_176610_l());
        return nbt;
    }

    public List<Template.BlockInfo> func_214849_a(TemplateManager templates, BlockPos pos, Rotation rotation, Random random) {
        JigsawOrientation orientation = JigsawOrientation.func_239641_a_((Direction)Direction.DOWN, (Direction)Direction.SOUTH);
        BlockState state = (BlockState)Blocks.field_226904_lY_.func_176223_P().func_206870_a((Property)JigsawBlock.field_235506_a_, (Comparable)orientation);
        return ImmutableList.of((Object)new Template.BlockInfo(pos, state, JIGSAW_NBT));
    }

    @Override
    public MutableBoundingBox getGenerationBounds(TemplateManager templates, BlockPos pos, Rotation rotation) {
        return new MutableBoundingBox(pos.func_177958_n() - 32, pos.func_177956_o() - 32, pos.func_177952_p() - 32, pos.func_177958_n() + 32, pos.func_177956_o() + 32, pos.func_177952_p() + 32);
    }

    public MutableBoundingBox func_214852_a(TemplateManager templates, BlockPos pos, Rotation rotation) {
        return new MutableBoundingBox((Vector3i)pos, (Vector3i)pos);
    }

    public boolean func_230378_a_(TemplateManager templates, ISeedReader world, StructureManager structures, ChunkGenerator generator, BlockPos origin, BlockPos p_230378_6_, Rotation rotation, MutableBoundingBox chunkBounds, Random random, boolean p_230378_10_) {
        SharedSeedRandom rand = new SharedSeedRandom();
        rand.func_202424_a(world.func_72905_C(), origin.func_177958_n(), origin.func_177952_p());
        int branchLength = rand.nextInt(10) + 15;
        int branchX1 = origin.func_177958_n();
        int branchZ1 = origin.func_177952_p();
        double minAngle = Math.toRadians(this.minAngle);
        double maxAngle = Math.toRadians(this.maxAngle);
        double angle = minAngle + (double)rand.nextFloat() * (maxAngle - minAngle);
        int branchX2 = (int)((double)branchLength * Math.sin(angle) + (double)branchX1);
        int branchZ2 = (int)((double)branchLength * Math.cos(angle) + (double)branchZ1);
        int branchY2 = rand.nextInt(4) + 4;
        BlockState wood = ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).func_176223_P();
        BlockState leaf = ((LeavesBlock)TropicraftBlocks.MAHOGANY_LEAVES.get()).func_176223_P();
        int leafCircleSizeConstant = 3;
        int y2 = origin.func_177956_o() + branchY2;
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1, origin.func_177956_o(), branchZ1), new BlockPos(branchX2, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1 + 1, origin.func_177956_o(), branchZ1), new BlockPos(branchX2 + 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1 - 1, origin.func_177956_o(), branchZ1), new BlockPos(branchX2 - 1, y2, branchZ2), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1, origin.func_177956_o(), branchZ1 + 1), new BlockPos(branchX2, y2, branchZ2 + 1), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1, origin.func_177956_o(), branchZ1 - 1), new BlockPos(branchX2, y2, branchZ2 - 1), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1, origin.func_177956_o() - 1, branchZ1), new BlockPos(branchX2, y2 - 1, branchZ2), wood, chunkBounds);
        this.placeBlockLine((IWorld)world, new BlockPos(branchX1, origin.func_177956_o() + 1, branchZ1), new BlockPos(branchX2, y2 + 1, branchZ2), wood, chunkBounds);
        this.genLeafCircle((IWorld)world, branchX2, y2 - 1, branchZ2, 8, 6, leaf, chunkBounds);
        this.genLeafCircle((IWorld)world, branchX2, y2, branchZ2, 9, 0, leaf, chunkBounds);
        this.genLeafCircle((IWorld)world, branchX2, y2 + 1, branchZ2, 13, 0, leaf, chunkBounds);
        this.genLeafCircle((IWorld)world, branchX2, y2 + 2, branchZ2, 12, 0, leaf, chunkBounds);
        return true;
    }

    public void genLeafCircle(IWorld world, int x, int y, int z, int outerRadius, int innerRadius, BlockState state, MutableBoundingBox chunkBounds) {
        int outerRadiusSquared = outerRadius * outerRadius;
        int innerRadiusSquared = innerRadius * innerRadius;
        BlockPos origin = new BlockPos(x, y, z);
        MutableBoundingBox bounds = HomeTreeBranchPiece.intersection(chunkBounds, new MutableBoundingBox((Vector3i)origin.func_177982_a(-outerRadius, 0, -outerRadius), (Vector3i)origin.func_177982_a(outerRadius, 0, outerRadius)));
        if (bounds == null) {
            return;
        }
        for (BlockPos pos : BlockPos.func_191531_b((int)bounds.field_78897_a, (int)bounds.field_78895_b, (int)bounds.field_78896_c, (int)bounds.field_78893_d, (int)bounds.field_78894_e, (int)bounds.field_78892_f)) {
            double distanceSquared = pos.func_177951_i((Vector3i)origin);
            if (!(distanceSquared <= (double)outerRadiusSquared) || !(distanceSquared >= (double)innerRadiusSquared) || !world.func_175623_d(pos) && world.func_180495_p(pos).func_177230_c() != state.func_177230_c()) continue;
            world.func_180501_a(pos, state, 3);
        }
    }

    private void placeBlockLine(IWorld world, BlockPos from, BlockPos to, BlockState state, MutableBoundingBox chunkBounds) {
        Direction.Axis primaryAxis;
        MutableBoundingBox lineBounds = new MutableBoundingBox((Vector3i)from, (Vector3i)to);
        if (!chunkBounds.func_78884_a(lineBounds)) {
            return;
        }
        BlockPos delta = to.func_177973_b((Vector3i)from);
        int maxLength = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vector3i)delta, primaryAxis = this.getLongestAxis(delta)));
        if (maxLength == 0) {
            return;
        }
        double stepX = (double)HomeTreeBranchPiece.getCoordinateAlong((Vector3i)delta, Direction.Axis.X) / (double)maxLength;
        double stepY = (double)HomeTreeBranchPiece.getCoordinateAlong((Vector3i)delta, Direction.Axis.Y) / (double)maxLength;
        double stepZ = (double)HomeTreeBranchPiece.getCoordinateAlong((Vector3i)delta, Direction.Axis.Z) / (double)maxLength;
        for (int length = 0; length <= maxLength; ++length) {
            BlockPos pos = new BlockPos((double)from.func_177958_n() + (double)length * stepX + 0.5, (double)from.func_177956_o() + (double)length * stepY + 0.5, (double)from.func_177952_p() + (double)length * stepZ + 0.5);
            if (!chunkBounds.func_175898_b((Vector3i)pos)) continue;
            world.func_180501_a(pos, state, 3);
        }
    }

    private Direction.Axis getLongestAxis(BlockPos delta) {
        Direction.Axis longestAxis = Direction.Axis.X;
        int longestLength = 0;
        for (Direction.Axis axis : ALL_AXIS) {
            int length = Math.abs(HomeTreeBranchPiece.getCoordinateAlong((Vector3i)delta, axis));
            if (length <= longestLength) continue;
            longestAxis = axis;
            longestLength = length;
        }
        return longestAxis;
    }

    @Nullable
    private static MutableBoundingBox intersection(MutableBoundingBox left, MutableBoundingBox right) {
        if (!left.func_78884_a(right)) {
            return null;
        }
        return new MutableBoundingBox(Math.max(left.field_78897_a, right.field_78897_a), Math.max(left.field_78895_b, right.field_78895_b), Math.max(left.field_78896_c, right.field_78896_c), Math.min(left.field_78893_d, right.field_78893_d), Math.min(left.field_78894_e, right.field_78894_e), Math.min(left.field_78892_f, right.field_78892_f));
    }

    private static int getCoordinateAlong(Vector3i pos, Direction.Axis axis) {
        return axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public IJigsawDeserializer<?> func_214853_a() {
        return TYPE;
    }
}

