/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;

public class StructureSupportsProcessor
extends CheatyStructureProcessor {
    public static final Codec<StructureSupportsProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("can_replace_land", (Object)false).forGetter(p -> p.canReplaceLand), (App)ResourceLocation.field_240908_a_.listOf().fieldOf("states_to_extend").forGetter(p -> new ArrayList<ResourceLocation>(p.statesToExtend))).apply((Applicative)instance, StructureSupportsProcessor::new));
    static final IStructureProcessorType<StructureSupportsProcessor> TYPE = (IStructureProcessorType)Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"tropicraft:structure_supports", () -> CODEC);
    private final boolean canReplaceLand;
    private final Set<ResourceLocation> statesToExtend;

    public StructureSupportsProcessor(boolean canReplaceLand, List<ResourceLocation> statesToExtend) {
        this.canReplaceLand = canReplaceLand;
        this.statesToExtend = new ObjectOpenHashSet(statesToExtend);
    }

    public Template.BlockInfo process(IWorldReader world, BlockPos seedPos, BlockPos pos2, Template.BlockInfo originalInfo, Template.BlockInfo blockInfo, PlacementSettings placement, Template template) {
        BlockPos pos = blockInfo.field_186242_a;
        if (originalInfo.field_186242_a.func_177956_o() <= 1 && this.statesToExtend.contains(blockInfo.field_186243_b.func_177230_c().getRegistryName())) {
            if (!this.canReplaceLand && !this.canPassThrough(world, pos)) {
                return null;
            }
            if (originalInfo.field_186242_a.func_177956_o() == 0) {
                if (!this.canReplaceLand && !this.canPassThrough(world, pos.func_177984_a())) {
                    return null;
                }
                BlockPos fencePos = pos.func_177977_b();
                while (this.canPassThrough(world, fencePos)) {
                    BlockState state = blockInfo.field_186243_b;
                    if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                        state = (BlockState)state.func_206870_a((Property)FenceBlock.field_204514_u, (Comparable)Boolean.valueOf(world.func_180495_p(fencePos).func_177230_c() == Blocks.field_150355_j));
                    }
                    this.setBlockState(world, fencePos, state);
                    fencePos = fencePos.func_177977_b();
                }
            }
        }
        return blockInfo;
    }

    protected boolean canPassThrough(IWorldReader world, BlockPos pos) {
        return this.isAirOrWater(world, pos) || world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o() < pos.func_177956_o();
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return TYPE;
    }
}

