/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.tropicraft.core.common.entity.TropicraftEntities;

public class SpawnerProcessor
extends StructureProcessor {
    public static final SpawnerProcessor IGUANA = new SpawnerProcessor((List<EntityType<?>>)ImmutableList.of((Object)TropicraftEntities.IGUANA.get()));
    public static final SpawnerProcessor ASHEN = new SpawnerProcessor((List<EntityType<?>>)ImmutableList.of((Object)TropicraftEntities.ASHEN.get()));
    public static final SpawnerProcessor EIH = new SpawnerProcessor((List<EntityType<?>>)ImmutableList.of((Object)TropicraftEntities.EIH.get()));
    public static final SpawnerProcessor IGUANA_AND_ASHEN = new SpawnerProcessor((List<EntityType<?>>)ImmutableList.of((Object)TropicraftEntities.ASHEN.get(), (Object)TropicraftEntities.IGUANA.get()));
    public static final Codec<SpawnerProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212629_r.listOf().fieldOf("entity_types").forGetter(p -> p.entityTypes)).apply((Applicative)instance, SpawnerProcessor::new));
    public static final IStructureProcessorType<SpawnerProcessor> TYPE = (IStructureProcessorType)Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"tropicraft:spawner_processor", () -> CODEC);
    private final List<EntityType<?>> entityTypes;

    public SpawnerProcessor(List<EntityType<?>> entityTypes) {
        this.entityTypes = entityTypes;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return TYPE;
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, BlockPos pos2, Template.BlockInfo originalBlockInfo, Template.BlockInfo blockInfo, PlacementSettings settings, @Nullable Template template) {
        Block block = blockInfo.field_186243_b.func_177230_c();
        if (block != Blocks.field_150474_ac) {
            return blockInfo;
        }
        CompoundNBT tag = new CompoundNBT();
        String typeName = Registry.field_212629_r.func_177774_c(this.entityTypes.get(0)).toString();
        tag.func_74778_a("id", this.entityTypes.get(0).getRegistryName().func_110623_a());
        blockInfo.field_186244_c.func_74775_l("SpawnData").func_74778_a("id", typeName);
        ListNBT list = blockInfo.field_186244_c.func_150295_c("SpawnPotentials", 9);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt = list.func_150305_b(i);
            nbt.func_74775_l("Entity").func_74778_a("id", typeName);
        }
        return blockInfo;
    }
}

