/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.tropicraft.core.common.dimension.feature.jigsaw.CheatyStructureProcessor;

public abstract class PathStructureProcessor
extends CheatyStructureProcessor {
    private static final WeakHashMap<PlacementSettings, List<PathVector>> VECTOR_CACHE = new WeakHashMap();

    protected PathStructureProcessor() {
    }

    @Nullable
    protected Direction.Axis getPathDirection(IWorldReader world, BlockPos seedPos, Template.BlockInfo current, PlacementSettings settings, Template template) {
        PlacementSettings infiniteBounds = settings.func_186217_a();
        infiniteBounds.func_186223_a(MutableBoundingBox.func_236990_b_());
        return VECTOR_CACHE.computeIfAbsent(settings, s -> template.func_215386_a(seedPos, infiniteBounds, Blocks.field_226904_lY_, true).stream().filter(b -> b.field_186244_c.func_74779_i("target").equals("tropicraft:path_center")).map(bi -> new PathVector(world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, bi.field_186242_a).func_177973_b((Vector3i)seedPos), JigsawBlock.func_235508_h_((BlockState)bi.field_186243_b))).collect(Collectors.toList())).stream().filter(pv -> pv.contains(current.field_186242_a.func_177973_b((Vector3i)seedPos), settings)).findFirst().map(pv -> pv.dir.func_176740_k()).orElse(null);
    }

    private static class PathVector {
        final Direction dir;
        final MutableBoundingBox bb;

        PathVector(BlockPos start, Direction dir) {
            Preconditions.checkArgument((boolean)dir.func_176740_k().func_176722_c(), (Object)("Invalid direction for path vector at " + start));
            this.dir = dir;
            Vector3d ortho = Vector3d.func_237491_b_((Vector3i)dir.func_176746_e().func_176730_m());
            this.bb = this.toMutable(new AxisAlignedBB(start).func_216361_a(Vector3d.func_237491_b_((Vector3i)dir.func_176730_m()).func_186678_a(16.0)).func_216361_a(ortho).func_216361_a(ortho.func_216371_e()).func_72314_b(0.0, 48.0, 0.0));
        }

        boolean contains(BlockPos pos, PlacementSettings settings) {
            return this.bb.func_175898_b((Vector3i)pos);
        }

        private MutableBoundingBox toMutable(AxisAlignedBB bb) {
            return new MutableBoundingBox((int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c, (int)bb.field_72336_d, (int)bb.field_72337_e, (int)bb.field_72334_f);
        }
    }
}

