/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class UndergrowthFeature
extends Feature<NoFeatureConfig> {
    private static final int LARGE_BUSH_CHANCE = 5;

    public UndergrowthFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int size = 2;
        if (rand.nextInt(5) == 0) {
            size = 3;
        }
        if (!this.isValidPosition((IWorldGenerationReader)world, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((IWorld)world, pos.func_177977_b())) {
            return false;
        }
        world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
        this.func_230367_a_((IWorldWriter)world, pos, ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).func_176223_P());
        int count = 0;
        for (int round = 0; round < 64; ++round) {
            BlockPos posTemp = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!this.isValidPosition((IWorldGenerationReader)world, posTemp) || posTemp.func_177956_o() >= 255) continue;
            for (int y = posTemp.func_177956_o(); y < posTemp.func_177956_o() + size; ++y) {
                int bushWidth = size - (y - posTemp.func_177956_o());
                for (int x = posTemp.func_177958_n() - bushWidth; x < posTemp.func_177958_n() + bushWidth; ++x) {
                    int xVariance = x - posTemp.func_177958_n();
                    for (int z = posTemp.func_177952_p() - bushWidth; z < posTemp.func_177952_p() + bushWidth; ++z) {
                        int zVariance = z - posTemp.func_177952_p();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((IWorldGenerationReader)world, newPos)) continue;
                        this.func_230367_a_((IWorldWriter)world, newPos, ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).func_176223_P());
                    }
                }
            }
            ++count;
        }
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(IWorldGenerationReader world, BlockPos pos) {
        if (!TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)pos)) return false;
        if (world.func_217375_a(pos, Blocks.field_201941_jj.func_176223_P()::equals)) return false;
        return true;
    }
}

