/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.pools.TropicraftTemplatePools;

public final class TropicraftConfiguredStructures {
    public final StructureFeature<?, ?> homeTree;
    public final StructureFeature<?, ?> koaVillage;

    public TropicraftConfiguredStructures(WorldgenDataConsumer<StructureFeature<?, ?>> worldgen, TropicraftTemplatePools templatePools) {
        Register structures = new Register(worldgen);
        this.homeTree = structures.register("home_tree", TropicraftFeatures.HOME_TREE, templatePools.homeTreeStarts, 7);
        this.koaVillage = structures.register("koa_village", TropicraftFeatures.KOA_VILLAGE, templatePools.koaTownCenters, 6);
    }

    static final class Register {
        private final WorldgenDataConsumer<StructureFeature<?, ?>> worldgen;

        Register(WorldgenDataConsumer<StructureFeature<?, ?>> worldgen) {
            this.worldgen = worldgen;
        }

        public <S extends Structure<?>> StructureFeature<?, ?> register(String id, RegistryObject<S> structure, Function<S, StructureFeature<?, ?>> configure) {
            return this.worldgen.register(new ResourceLocation("tropicraft", id), configure.apply(structure.get()));
        }

        public <S extends Structure<VillageConfig>> StructureFeature<?, ?> register(String id, RegistryObject<S> structure, JigsawPattern templatePool, int maxDepth) {
            return this.register(id, structure, s -> s.func_236391_a_((IFeatureConfig)new VillageConfig(() -> templatePool, maxDepth)));
        }
    }
}

