/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class SingleUndergrowthFeature
extends Feature<NoFeatureConfig> {
    private static final int LARGE_BUSH_CHANCE = 4;

    public SingleUndergrowthFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int size = 2;
        if (rand.nextInt(4) == 0) {
            size = 3;
        }
        if (!this.isValidPosition((IWorldGenerationReader)world, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((IWorld)world, pos.func_177977_b())) {
            return false;
        }
        world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
        int count = 0;
        if (this.isValidPosition((IWorldGenerationReader)world, pos) && pos.func_177956_o() < 255) {
            for (int y = pos.func_177956_o(); y < pos.func_177956_o() + size; ++y) {
                int bushWidth = size - (y - pos.func_177956_o());
                for (int x = pos.func_177958_n() - bushWidth; x < pos.func_177958_n() + bushWidth; ++x) {
                    int xVariance = x - pos.func_177958_n();
                    for (int z = pos.func_177952_p() - bushWidth; z < pos.func_177952_p() + bushWidth; ++z) {
                        int zVariance = z - pos.func_177952_p();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.nextInt(2) == 0 || !this.isValidPosition((IWorldGenerationReader)world, newPos)) continue;
                        this.func_230367_a_((IWorldWriter)world, newPos, ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).func_176223_P());
                    }
                }
            }
            ++count;
        }
        this.func_230367_a_((IWorldWriter)world, pos, ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).func_176223_P());
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(IWorldGenerationReader world, BlockPos pos) {
        if (!TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)pos)) return false;
        if (world.func_217375_a(pos, Blocks.field_201941_jj.func_176223_P()::equals)) return false;
        return true;
    }
}

