/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class CoffeePlantFeature
extends Feature<NoFeatureConfig> {
    public static final BlockState GRASS_BLOCK = Blocks.field_196658_i.func_176223_P();
    public static final BlockState COFE = ((CoffeeBushBlock)TropicraftBlocks.COFFEE_BUSH.get()).func_185528_e(6);
    public static final BlockState FARMLAND = Blocks.field_150458_ak.func_176223_P();
    public static final BlockState WATER = Blocks.field_150355_j.func_176223_P();

    public CoffeePlantFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockPos upPos;
        BlockPos genPos = new BlockPos(pos.func_177958_n() + random.nextInt(8) - random.nextInt(8), pos.func_177956_o(), pos.func_177952_p() + random.nextInt(8) - random.nextInt(8));
        if (!world.func_175623_d(genPos) || world.func_180495_p(genPos.func_177977_b()).func_177230_c() != GRASS_BLOCK.func_177230_c() || world.func_175623_d(genPos.func_177979_c(2))) {
            return false;
        }
        Direction viableDirection = null;
        for (Object dir : Direction.Plane.HORIZONTAL) {
            int neighborx = genPos.func_177958_n() + dir.func_82601_c();
            int neighborz = genPos.func_177952_p() + dir.func_82599_e();
            if (world.func_175623_d(new BlockPos(neighborx, pos.func_177956_o() - 1, neighborz))) continue;
            viableDirection = dir;
            break;
        }
        if (viableDirection == null) {
            return false;
        }
        BlockPos waterPos = new BlockPos(genPos.func_177958_n() + viableDirection.func_82601_c(), pos.func_177956_o() - 1, genPos.func_177952_p() + viableDirection.func_82599_e());
        world.func_180501_a(waterPos, WATER, 3);
        world.func_180501_a(genPos.func_177977_b(), FARMLAND, 3);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            world.func_180501_a(waterPos.func_177972_a(dir), GRASS_BLOCK, 3);
        }
        for (int i = 0; i < 3 && world.func_175623_d(upPos = genPos.func_177981_b(i)); ++i) {
            world.func_180501_a(upPos, COFE, 3);
        }
        return true;
    }
}

