/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.dimension.chunk.VolcanoGenerator;

public class TropicraftChunkGenerator
extends NoiseChunkGenerator {
    public static final Codec<TropicraftChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(g -> g.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(g -> g.seed), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(g -> g.field_236080_h_)).apply((Applicative)instance, instance.stable(TropicraftChunkGenerator::new)));
    private final VolcanoGenerator volcano;
    private final long seed;

    public TropicraftChunkGenerator(BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> settings) {
        super(biomeProvider, seed, settings);
        this.seed = seed;
        this.volcano = new VolcanoGenerator(seed, biomeProvider);
        SharedSeedRandom random = new SharedSeedRandom(seed);
        new OctavesNoiseGenerator(random, IntStream.rangeClosed(-15, 0));
        new OctavesNoiseGenerator(random, IntStream.rangeClosed(-15, 0));
        new OctavesNoiseGenerator(random, IntStream.rangeClosed(-7, 0));
        new PerlinNoiseGenerator(random, IntStream.rangeClosed(-3, 0));
        random.func_202423_a(2620);
        this.field_236082_u_ = new OctavesNoiseGenerator(random, IntStream.rangeClosed(-15, 0));
    }

    public static void register() {
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), CODEC);
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long seed) {
        return new TropicraftChunkGenerator(this.field_222542_c.func_230320_a_(seed), seed, this.field_236080_h_);
    }

    public int func_205470_d() {
        return this.func_230356_f_() + 1;
    }

    public void func_230352_b_(IWorld world, StructureManager structures, IChunk chunk) {
        super.func_230352_b_(world, structures, chunk);
        ChunkPos chunkPos = chunk.func_76632_l();
        this.volcano.generate(chunkPos.field_77276_a, chunkPos.field_77275_b, chunk, this.field_222558_e);
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        int height = super.func_222529_a(x, z, heightmapType);
        if (heightmapType != Heightmap.Type.OCEAN_FLOOR && heightmapType != Heightmap.Type.OCEAN_FLOOR_WG) {
            return Math.max(height, this.volcano.getVolcanoHeight(height, x, z));
        }
        return height;
    }
}

