/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.carver;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import net.tropicraft.core.common.dimension.carver.TropicraftCarvers;

public final class TropicraftConfiguredCarvers {
    public final ConfiguredCarver<?> cave;
    public final ConfiguredCarver<?> canyon;
    public final ConfiguredCarver<?> underwaterCave;
    public final ConfiguredCarver<?> underwaterCanyon;

    public TropicraftConfiguredCarvers(WorldgenDataConsumer<? extends ConfiguredCarver<?>> worldgen) {
        Register carvers = new Register(worldgen);
        this.cave = carvers.register("cave", TropicraftCarvers.CAVE, new ProbabilityConfig(0.25f));
        this.canyon = carvers.register("canyon", TropicraftCarvers.CANYON, new ProbabilityConfig(0.02f));
        this.underwaterCave = carvers.register("underwater_cave", TropicraftCarvers.UNDERWATER_CAVE, new ProbabilityConfig(0.15f));
        this.underwaterCanyon = carvers.register("underwater_canyon", TropicraftCarvers.UNDERWATER_CANYON, new ProbabilityConfig(0.02f));
    }

    public void addLand(BiomeGenerationSettings.Builder generation) {
        generation.func_242512_a(GenerationStage.Carving.AIR, this.cave);
        generation.func_242512_a(GenerationStage.Carving.AIR, this.canyon);
    }

    public void addUnderwater(BiomeGenerationSettings.Builder generation) {
        generation.func_242512_a(GenerationStage.Carving.LIQUID, this.underwaterCave);
        generation.func_242512_a(GenerationStage.Carving.LIQUID, this.underwaterCanyon);
    }

    static final class Register {
        private final WorldgenDataConsumer<ConfiguredCarver<?>> worldgen;

        Register(WorldgenDataConsumer<? extends ConfiguredCarver<?>> worldgen) {
            this.worldgen = worldgen;
        }

        public <C extends ICarverConfig, WC extends WorldCarver<C>> ConfiguredCarver<?> register(String id, RegistryObject<WC> carver, C config) {
            return this.worldgen.register(new ResourceLocation("tropicraft", id), ((WorldCarver)carver.get()).func_242761_a(config));
        }
    }
}

