/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import net.minecraft.block.Block;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.config.TropicraftConfig;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import net.tropicraft.core.common.dimension.carver.TropicraftConfiguredCarvers;
import net.tropicraft.core.common.dimension.feature.EIHFeature;
import net.tropicraft.core.common.dimension.feature.TropicraftConfiguredFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftConfiguredStructures;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.block_state_provider.NoiseFromTagBlockStateProvider;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.surfacebuilders.TropicraftConfiguredSurfaceBuilders;
import net.tropicraft.core.common.entity.TropicraftEntities;

@Mod.EventBusSubscriber(modid="tropicraft")
public final class TropicraftBiomes {
    public static final int TROPICS_WATER_COLOR = 5172447;
    public static final int TROPICS_WATER_FOG_COLOR = 270131;
    public static final int TROPICS_FOG_COLOR = 12638463;
    public static final int RAINFOREST_FOG_COLOR = 12248771;
    public static final int TROPICS_SKY_COLOR = TropicraftBiomes.getSkyColor(0.8f);
    public static final RegistryKey<Biome> TROPICS_OCEAN = TropicraftBiomes.key("tropics_ocean");
    public static final RegistryKey<Biome> TROPICS = TropicraftBiomes.key("tropics");
    public static final RegistryKey<Biome> KELP_FOREST = TropicraftBiomes.key("kelp_forest");
    public static final RegistryKey<Biome> RAINFOREST_PLAINS = TropicraftBiomes.key("rainforest_plains");
    public static final RegistryKey<Biome> RAINFOREST_HILLS = TropicraftBiomes.key("rainforest_hills");
    public static final RegistryKey<Biome> RAINFOREST_MOUNTAINS = TropicraftBiomes.key("rainforest_mountains");
    public static final RegistryKey<Biome> RAINFOREST_ISLAND_MOUNTAINS = TropicraftBiomes.key("rainforest_island_mountains");
    public static final RegistryKey<Biome> TROPICS_RIVER = TropicraftBiomes.key("tropics_river");
    public static final RegistryKey<Biome> TROPICS_BEACH = TropicraftBiomes.key("tropics_beach");
    public static final RegistryKey<Biome> BAMBOO_RAINFOREST = TropicraftBiomes.key("z_bamboo_rainforest");
    public static final RegistryKey<Biome> MANGROVES = TropicraftBiomes.key("z_mangroves");
    public static final RegistryKey<Biome> OVERGROWN_MANGROVES = TropicraftBiomes.key("z_overgrown_mangroves");
    public static final RegistryKey<Biome> OSA_RAINFOREST = TropicraftBiomes.key("z_osa_rainforest");
    public final Biome tropics;
    public final Biome tropicsBeach;
    public final Biome rainforestPlains;
    public final Biome rainforestHills;
    public final Biome rainforestMountains;
    public final Biome bambooRainforest;
    public final Biome rainforestIslandMountains;
    public final Biome tropicsOcean;
    public final Biome kelpForest;
    public final Biome tropicsRiver;
    public final Biome mangroves;
    public final Biome overgrownMangroves;
    public final Biome osaRainforest;
    private final TropicraftConfiguredFeatures features;
    private final TropicraftConfiguredStructures structures;
    private final TropicraftConfiguredCarvers carvers;
    private final TropicraftConfiguredSurfaceBuilders surfaces;

    private static RegistryKey<Biome> key(String id) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)new ResourceLocation("tropicraft", id));
    }

    public TropicraftBiomes(WorldgenDataConsumer<Biome> worldgen, TropicraftConfiguredFeatures features, TropicraftConfiguredStructures structures, TropicraftConfiguredCarvers carvers, TropicraftConfiguredSurfaceBuilders surfaces) {
        this.features = features;
        this.structures = structures;
        this.carvers = carvers;
        this.surfaces = surfaces;
        this.tropics = worldgen.register(TROPICS, this.createTropics());
        this.tropicsBeach = worldgen.register(TROPICS_BEACH, this.createTropicsBeach());
        this.rainforestPlains = worldgen.register(RAINFOREST_PLAINS, this.createRainforest(0.25f, 0.1f));
        this.rainforestHills = worldgen.register(RAINFOREST_HILLS, this.createRainforest(0.45f, 0.425f));
        this.rainforestMountains = worldgen.register(RAINFOREST_MOUNTAINS, this.createRainforest(0.8f, 0.8f));
        this.bambooRainforest = worldgen.register(BAMBOO_RAINFOREST, this.createRainforest(0.25f, 0.25f, true));
        this.rainforestIslandMountains = worldgen.register(RAINFOREST_ISLAND_MOUNTAINS, this.createRainforest(0.1f, 1.2f));
        this.tropicsOcean = worldgen.register(TROPICS_OCEAN, this.createTropicsOcean());
        this.kelpForest = worldgen.register(KELP_FOREST, this.createKelpForest());
        this.tropicsRiver = worldgen.register(TROPICS_RIVER, this.createTropicsRiver());
        this.mangroves = worldgen.register(MANGROVES, this.createMangroves(false));
        this.overgrownMangroves = worldgen.register(OVERGROWN_MANGROVES, this.createMangroves(true));
        this.osaRainforest = worldgen.register(OSA_RAINFOREST, this.createOsaRainforest(0.25f, 0.1f));
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        if (name != null && name.func_110624_b().equals("tropicraft")) {
            return;
        }
        Biome.Category category = event.getCategory();
        Biome.RainType precipitation = event.getClimate().field_242460_b;
        if (precipitation == Biome.RainType.SNOW) {
            return;
        }
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        if (TropicraftBiomes.isValidPalmTreeBiome(category)) {
            if (((Boolean)TropicraftConfig.generatePalmTreesInOverworld.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((PalmTreeFeature)TropicraftFeatures.NORMAL_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.08f, ((Integer)TropicraftConfig.palmTreeDensityInOverworld.get()).intValue()))));
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((PalmTreeFeature)TropicraftFeatures.CURVED_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.08f, ((Integer)TropicraftConfig.palmTreeDensityInOverworld.get()).intValue()))));
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((PalmTreeFeature)TropicraftFeatures.LARGE_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.08f, ((Integer)TropicraftConfig.palmTreeDensityInOverworld.get()).intValue()))));
            }
        } else if (category == Biome.Category.JUNGLE) {
            if (((Boolean)TropicraftConfig.generatePineapplesInOverworld.get()).booleanValue()) {
                SimpleBlockStateProvider state = new SimpleBlockStateProvider(((PineappleBlock)TropicraftBlocks.PINEAPPLE.get()).func_176223_P());
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)state, (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(6).func_227314_a_().func_227322_d_()).func_227228_a_(Features.Placements.field_244002_m));
            }
            if (((Boolean)TropicraftConfig.generateEIHInOverworld.get()).booleanValue()) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((EIHFeature)TropicraftFeatures.EIH.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
            }
        } else if ((category == Biome.Category.PLAINS || category == Biome.Category.FOREST) && ((Boolean)TropicraftConfig.generateTropicraftFlowersInOverworld.get()).booleanValue()) {
            NoiseFromTagBlockStateProvider flowersStateProvider = new NoiseFromTagBlockStateProvider((ITag<Block>)TropicraftTags.Blocks.TROPICS_FLOWERS);
            NoiseFromTagBlockStateProvider rainforestFlowersStateProvider = new NoiseFromTagBlockStateProvider((ITag<Block>)TropicraftTags.Blocks.RAINFOREST_FLOWERS);
            SimpleBlockStateProvider irisStateProvider = new SimpleBlockStateProvider(((TallFlowerBlock)TropicraftBlocks.IRIS.get()).func_176223_P());
            BlockClusterFeatureConfig flowersConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)flowersStateProvider, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();
            BlockClusterFeatureConfig rainforestFlowersConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)rainforestFlowersStateProvider, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227317_b_().func_227322_d_();
            BlockClusterFeatureConfig irisConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)irisStateProvider, (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)flowersConfig).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(12)));
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)rainforestFlowersConfig).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4)));
            generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)irisConfig).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(10)));
        }
    }

    private static boolean isValidPalmTreeBiome(Biome.Category category) {
        if (((Boolean)TropicraftConfig.generatePalmTreesInOverworldBeachesOnly.get()).booleanValue()) {
            return category == Biome.Category.BEACH;
        }
        return category == Biome.Category.BEACH || category == Biome.Category.DESERT || category == Biome.Category.MESA;
    }

    private Biome createTropics() {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.tropics);
        this.carvers.addLand(generation);
        this.features.addFruitTrees(generation);
        this.features.addPalmTrees(generation);
        this.features.addEih(generation);
        this.features.addPapaya(generation);
        this.features.addTropicsFlowers(generation);
        this.features.addPineapples(generation);
        this.features.addRegularSeagrass(generation);
        this.features.addTropicsGrass(generation);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)generation);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        spawns.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FAILGULL.get(), 10, 5, 15));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_BEE.get(), 10, 4, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.COWKTAIL.get(), 10, 4, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TREE_FROG.get(), 4, 4, 4));
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(0.1f).func_205420_b(0.1f).func_205414_c(2.0f).func_205417_d(1.5f).func_205419_a(Biome.Category.PLAINS).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(true).func_235238_a_()).func_242455_a();
    }

    private Biome createTropicsBeach() {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.sandy);
        this.features.addRegularSeagrass(generation);
        this.carvers.addUnderwater(generation);
        this.features.addPalmTrees(generation);
        this.features.addTropicsFlowers(generation);
        generation.func_242516_a(this.structures.koaVillage);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 10, 1, 2));
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(-0.1f).func_205420_b(0.1f).func_205414_c(1.5f).func_205417_d(1.25f).func_205419_a(Biome.Category.BEACH).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(false).func_235238_a_()).func_242455_a();
    }

    private Biome createOsaRainforest(float depth, float scale) {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.osaRainforest);
        this.carvers.addLand(generation);
        this.features.addGoldenLeatherFern(generation);
        this.features.addTropicsGems(generation);
        this.features.addPleodendron(generation);
        this.features.addRainforestTrees(generation);
        this.features.addRegularSeagrass(generation);
        this.features.addPapaya(generation);
        this.features.addTropicsFlowers(generation);
        this.features.addPineapples(generation);
        this.features.addTropicsGrass(generation);
        DefaultBiomeFeatures.func_243757_q((BiomeGenerationSettings.Builder)generation);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.features.coffeeBush);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.features.singleUndergrowth);
        this.features.addRainforestPlants(generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200781_U, 10, 1, 1));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200783_W, 10, 1, 2));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TREE_FROG.get(), 25, 2, 5));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 30, 1, 1));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 6, 12));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.JAGUAR.get(), 5, 1, 2));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 10, 3, 5));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 6, 8));
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(depth).func_205420_b(scale).func_205414_c(1.5f).func_205417_d(2.0f).func_205419_a(Biome.Category.JUNGLE).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(true).func_235238_a_()).func_242455_a();
    }

    private Biome createRainforest(float depth, float scale) {
        return this.createRainforest(depth, scale, false);
    }

    private Biome createRainforest(float depth, float scale, boolean bamboo) {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        this.carvers.addLand(generation);
        this.features.addTropicsGems(generation);
        this.features.addRainforestTrees(generation);
        this.features.addRegularSeagrass(generation);
        this.features.addPapaya(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.features.rainforestFlowers);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.features.coffeeBush);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.features.undergrowth);
        generation.func_242516_a(this.structures.homeTree);
        DefaultBiomeFeatures.func_243695_I((BiomeGenerationSettings.Builder)generation);
        DefaultBiomeFeatures.func_243760_t((BiomeGenerationSettings.Builder)generation);
        this.features.addRainforestPlants(generation);
        if (bamboo) {
            this.features.addBamboo(generation);
        }
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200781_U, 10, 1, 1));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200783_W, 10, 1, 2));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TREE_FROG.get(), 25, 2, 5));
        spawns.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 30, 1, 1));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.JAGUAR.get(), 5, 1, 2));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 10, 3, 5));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 5, 8));
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(depth).func_205420_b(scale).func_205414_c(1.5f).func_205417_d(2.0f).func_205419_a(Biome.Category.JUNGLE).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(true).func_235238_a_()).func_242455_a();
    }

    private Biome createTropicsOcean() {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.sandy);
        this.carvers.addUnderwater(generation);
        this.features.addTropicsMetals(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243935_cr);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243966_z);
        this.features.addUndergroundSeagrass(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243776_B);
        this.features.addUndergroundPickles(generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        this.addOceanWaterCreatures(spawns);
        spawns.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FAILGULL.get(), 15, 5, 10));
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(-1.6f).func_205420_b(0.4f).func_205414_c(1.5f).func_205417_d(1.25f).func_205419_a(Biome.Category.OCEAN).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(false).func_235238_a_()).func_242455_a();
    }

    private Biome createKelpForest() {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.sandy);
        this.carvers.addUnderwater(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243783_I);
        this.features.addUndergroundSeagrass(generation);
        this.features.addUndergroundPickles(generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        this.addOceanWaterCreatures(spawns);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(-1.5f).func_205420_b(0.3f).func_205414_c(1.5f).func_205417_d(1.25f).func_205419_a(Biome.Category.OCEAN).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(false).func_235238_a_()).func_242455_a();
    }

    private Biome createTropicsRiver() {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.sandy);
        this.carvers.addLand(generation);
        this.features.addTropicsFlowers(generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        this.addRiverWaterCreatures(spawns);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(-0.7f).func_205420_b(0.05f).func_205414_c(1.5f).func_205417_d(1.25f).func_205419_a(Biome.Category.RIVER).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(this.defaultAmbience(false).func_235238_a_()).func_242455_a();
    }

    private Biome createMangroves(boolean overgrown) {
        BiomeGenerationSettings.Builder generation = this.defaultGeneration().func_242517_a(this.surfaces.mangrove);
        this.carvers.addLand(generation);
        this.features.addMudDisks(generation);
        if (overgrown) {
            this.features.addOvergrownGoldenLeatherFern(generation);
        }
        this.features.addGoldenLeatherFern(generation);
        this.features.addMangroveVegetation(generation, overgrown);
        this.features.addTropicsFlowers(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243775_A);
        this.features.addMangroveReeds(generation);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243848_au);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)generation);
        MobSpawnInfo.Builder spawns = this.defaultSpawns();
        spawns.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FAILGULL.get(), 5, 5, 15));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TREE_FROG.get(), 4, 4, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.JAGUAR.get(), 8, 1, 3));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 12, 3, 5));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 5, 8));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.BROWN_BASILISK_LIZARD.get(), 10, 1, 3));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.GREEN_BASILISK_LIZARD.get(), 10, 1, 3));
        this.addMangroveWaterCreatures(spawns);
        BiomeAmbience.Builder ambience = this.defaultAmbience(true);
        ambience.func_235246_b_(6734231).func_235248_c_(800034);
        ambience.func_242541_f(7320092);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205421_a(-0.25f).func_205420_b(-0.045f).func_205414_c(2.0f).func_205417_d(1.5f).func_205419_a(Biome.Category.SWAMP).func_242457_a(generation.func_242508_a()).func_242458_a(spawns.func_242577_b()).func_235097_a_(ambience.func_235238_a_()).func_242455_a();
    }

    private void addOceanWaterCreatures(MobSpawnInfo.Builder spawns) {
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPICAL_FISH.get(), 20, 4, 8));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.STARFISH.get(), 4, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SEAHORSE.get(), 6, 6, 12));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SEA_URCHIN.get(), 4, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.MAN_O_WAR.get(), 2, 1, 1));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.MARLIN.get(), 10, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.CUBERA.get(), 10, 2, 4));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.EAGLE_RAY.get(), 6, 1, 1));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SEA_TURTLE.get(), 6, 3, 8));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.DOLPHIN.get(), 3, 4, 7));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.HAMMERHEAD.get(), 2, 1, 1));
    }

    private void addRiverWaterCreatures(MobSpawnInfo.Builder spawns) {
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 20, 2, 6));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.PIRANHA.get(), 15, 1, 12));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.RIVER_SARDINE.get(), 20, 1, 8));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 8, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203780_j, 4, 1, 5));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 4, 1, 5));
    }

    private void addMangroveWaterCreatures(MobSpawnInfo.Builder spawns) {
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 20, 2, 6));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.PIRANHA.get(), 15, 1, 12));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.RIVER_SARDINE.get(), 20, 1, 8));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203780_j, 4, 1, 5));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 4, 1, 5));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_204262_at, 12, 1, 5));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.STARFISH.get(), 4, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SEA_URCHIN.get(), 4, 1, 4));
        spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.SEAHORSE.get(), 6, 6, 12));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.HAMMERHEAD.get(), 2, 1, 1));
        spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 8, 1, 4));
    }

    private BiomeGenerationSettings.Builder defaultGeneration() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generation);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generation);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generation);
        return generation;
    }

    private MobSpawnInfo.Builder defaultSpawns() {
        MobSpawnInfo.Builder spawns = new MobSpawnInfo.Builder();
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200783_W, 15, 1, 2));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.V_MONKEY.get(), 15, 1, 3));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.IGUANA.get(), 15, 4, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_CREEPER.get(), 4, 1, 2));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.EIH.get(), 5, 1, 1));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_SKELLY.get(), 8, 2, 4));
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 8, 2, 2));
        return spawns;
    }

    private BiomeAmbience.Builder defaultAmbience(boolean greenFog) {
        return new BiomeAmbience.Builder().func_235239_a_(greenFog ? 12248771 : 12638463).func_242539_d(TROPICS_SKY_COLOR).func_235246_b_(5172447).func_235248_c_(270131);
    }

    private static int getSkyColor(float temperature) {
        float shift = MathHelper.func_76131_a((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - shift * 0.05f), (float)(0.5f + shift * 0.1f), (float)1.0f);
    }
}

