/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.layer.TropicraftLayerUtil;

public class TropicraftBiomeProvider
extends BiomeProvider {
    public static final Codec<TropicraftBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(b -> b.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(b -> b.biomes)).apply((Applicative)instance, instance.stable(TropicraftBiomeProvider::new)));
    private static final Set<RegistryKey<Biome>> POSSIBLE_BIOMES = ImmutableSet.of(TropicraftBiomes.TROPICS, TropicraftBiomes.TROPICS_OCEAN, TropicraftBiomes.TROPICS_RIVER, TropicraftBiomes.TROPICS_BEACH, TropicraftBiomes.RAINFOREST_HILLS, TropicraftBiomes.RAINFOREST_PLAINS, (Object[])new RegistryKey[]{TropicraftBiomes.RAINFOREST_MOUNTAINS, TropicraftBiomes.BAMBOO_RAINFOREST, TropicraftBiomes.RAINFOREST_ISLAND_MOUNTAINS, TropicraftBiomes.KELP_FOREST, TropicraftBiomes.MANGROVES, TropicraftBiomes.OVERGROWN_MANGROVES, TropicraftBiomes.OSA_RAINFOREST});
    private final long seed;
    private final Registry<Biome> biomes;
    private final Layer noiseLayer;

    public TropicraftBiomeProvider(long seed, Registry<Biome> biomes) {
        super(POSSIBLE_BIOMES.stream().map(arg_0 -> biomes.func_230516_a_(arg_0)).filter(Objects::nonNull).map(biome -> () -> biome));
        this.seed = seed;
        this.biomes = biomes;
        this.noiseLayer = TropicraftLayerUtil.buildTropicsProcedure(seed, biomes);
    }

    public static void register() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), CODEC);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new TropicraftBiomeProvider(seed, this.biomes);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.noiseLayer.func_242936_a(this.biomes, x, z);
    }
}

