/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TropicraftWorldgenProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger(TropicraftWorldgenProvider.class);
    private static final LazyValue<DynamicRegistries.Impl> DYNAMIC_REGISTRIES = new LazyValue(() -> {
        DynamicRegistries.Impl dynamicRegistries = new DynamicRegistries.Impl();
        for (Registry registry : WorldGenRegistries.field_243650_b) {
            TropicraftWorldgenProvider.copyAllToDynamicRegistry(registry, (DynamicRegistries)dynamicRegistries);
        }
        return dynamicRegistries;
    });
    private final Path root;
    private final Consumer<Generator> generatorFunction;

    private static <T> void copyAllToDynamicRegistry(Registry<T> from, DynamicRegistries dynamicRegistries) {
        dynamicRegistries.func_230521_a_(from.func_243578_f()).ifPresent(dynamicRegistry -> TropicraftWorldgenProvider.copyAllToRegistry(from, dynamicRegistry));
    }

    private static <T> void copyAllToRegistry(Registry<T> from, Registry<T> to) {
        for (Map.Entry entry : from.func_239659_c_()) {
            Registry.func_218322_a(to, (ResourceLocation)((RegistryKey)entry.getKey()).func_240901_a_(), entry.getValue());
        }
    }

    public TropicraftWorldgenProvider(DataGenerator dataGenerator, Consumer<Generator> generatorFunction) {
        this.root = dataGenerator.func_200391_b().resolve("data");
        this.generatorFunction = generatorFunction;
    }

    public void func_200398_a(DirectoryCache cache) {
        DynamicRegistries.Impl dynamicRegistries = (DynamicRegistries.Impl)DYNAMIC_REGISTRIES.func_179281_c();
        WorldGenSettingsExport ops = WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)dynamicRegistries);
        Generator generator = new Generator(this.root, cache, dynamicRegistries, (DynamicOps<JsonElement>)ops);
        this.generatorFunction.accept(generator);
    }

    public String func_200397_b() {
        return "Tropicraft Worldgen";
    }

    public static interface EntryGenerator<T, R> {
        public R generate(WorldgenDataConsumer<T> var1);
    }

    public static final class Generator {
        private final Path root;
        private final DirectoryCache cache;
        private final DynamicRegistries.Impl dynamicRegistries;
        private final DynamicOps<JsonElement> ops;

        Generator(Path root, DirectoryCache cache, DynamicRegistries.Impl dynamicRegistries, DynamicOps<JsonElement> ops) {
            this.root = root;
            this.cache = cache;
            this.dynamicRegistries = dynamicRegistries;
            this.ops = ops;
        }

        public <R> R addConfiguredFeatures(EntryGenerator<ConfiguredFeature<?, ?>, R> entryGenerator) {
            return this.add("worldgen/configured_feature", WorldGenRegistries.field_243653_e, ConfiguredFeature.field_236264_b_, entryGenerator);
        }

        public <R> R addConfiguredSurfaceBuilders(EntryGenerator<ConfiguredSurfaceBuilder<?>, R> entryGenerator) {
            return this.add("worldgen/configured_surface_builder", WorldGenRegistries.field_243651_c, ConfiguredSurfaceBuilder.field_244393_b_, entryGenerator);
        }

        public <R> R addConfiguredCarvers(EntryGenerator<ConfiguredCarver<?>, R> entryGenerator) {
            return this.add("worldgen/configured_carver", WorldGenRegistries.field_243652_d, ConfiguredCarver.field_244390_b_, entryGenerator);
        }

        public <R> R addProcessorLists(EntryGenerator<StructureProcessorList, R> entryGenerator) {
            return this.add("worldgen/processor_list", WorldGenRegistries.field_243655_g, IStructureProcessorType.field_242922_m, entryGenerator);
        }

        public <R> R addTemplatePools(EntryGenerator<JigsawPattern, R> entryGenerator) {
            return this.add("worldgen/template_pool", WorldGenRegistries.field_243656_h, JigsawPattern.field_244392_b_, entryGenerator);
        }

        public <R> R addConfiguredStructures(EntryGenerator<StructureFeature<?, ?>, R> entryGenerator) {
            return this.add("worldgen/configured_structure_feature", WorldGenRegistries.field_243654_f, StructureFeature.field_244391_b_, entryGenerator);
        }

        public <R> R addBiomes(EntryGenerator<Biome, R> entryGenerator) {
            return this.add("worldgen/biome", null, Biome.field_235051_b_, entryGenerator);
        }

        public <T, R> R add(String path, @Nullable Registry<? super T> registry, Codec<Supplier<T>> codec, EntryGenerator<? extends T, R> entryGenerator) {
            return entryGenerator.generate((id, entry) -> {
                Path entryPath = this.root.resolve(id.func_110624_b()).resolve(path).resolve(id.func_110623_a() + ".json");
                Function function = this.ops.withEncoder((Encoder)codec);
                try {
                    Optional serialized = ((DataResult)function.apply(() -> entry)).result();
                    if (serialized.isPresent()) {
                        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)this.cache, (JsonElement)((JsonElement)serialized.get()), (Path)entryPath);
                    } else {
                        LOGGER.error("Couldn't serialize worldgen entry at {}", (Object)entryPath);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save worldgen entry at {}", (Object)entryPath, (Object)e);
                }
                if (registry != null) {
                    Registry.func_218322_a((Registry)registry, (ResourceLocation)id, (Object)entry);
                    this.dynamicRegistries.func_230521_a_(registry.func_243578_f()).ifPresent(dynamicRegistry -> Registry.func_218322_a((Registry)dynamicRegistry, (ResourceLocation)id, (Object)entry));
                }
                return entry;
            });
        }
    }
}

