/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.item.TropicraftItems;
import org.apache.commons.lang3.StringUtils;

public class TropicraftRecipeProvider
extends RecipeProvider {
    public TropicraftRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.ore(TropicraftTags.Items.AZURITE_ORE, (Supplier)TropicraftItems.AZURITE, 0.3f, consumer);
        this.ore(TropicraftTags.Items.EUDIALYTE_ORE, (Supplier)TropicraftItems.EUDIALYTE, 0.5f, consumer);
        this.ore(TropicraftTags.Items.ZIRCON_ORE, (Supplier)TropicraftItems.ZIRCON, 0.5f, consumer);
        this.ore(TropicraftTags.Items.MANGANESE_ORE, (Supplier)TropicraftItems.MANGANESE, 0.5f, consumer);
        this.ore(TropicraftTags.Items.SHAKA_ORE, (Supplier)TropicraftItems.SHAKA, 0.7f, consumer);
        this.storage((Supplier)TropicraftItems.AZURITE, (Supplier)TropicraftBlocks.AZURITE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftBlocks.EUDIALYTE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftBlocks.ZIRCON_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftBlocks.ZIRCONIUM_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.MANGANESE, (Supplier)TropicraftBlocks.MANGANESE_BLOCK, consumer);
        this.storage((Supplier)TropicraftItems.SHAKA, (Supplier)TropicraftBlocks.SHAKA_BLOCK, consumer);
        this.pickaxe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_PICKAXE, consumer);
        this.pickaxe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_PICKAXE, consumer);
        this.pickaxe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_PICKAXE, consumer);
        this.axe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_AXE, consumer);
        this.axe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_AXE, consumer);
        this.axe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_AXE, consumer);
        this.shovel((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_SHOVEL, consumer);
        this.shovel((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_SHOVEL, consumer);
        this.shovel((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_SHOVEL, consumer);
        this.hoe((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_HOE, consumer);
        this.hoe((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_HOE, consumer);
        this.hoe((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_HOE, consumer);
        this.sword((Supplier)TropicraftItems.ZIRCON, (Supplier)TropicraftItems.ZIRCON_SWORD, consumer);
        this.sword((Supplier)TropicraftItems.ZIRCONIUM, (Supplier)TropicraftItems.ZIRCONIUM_SWORD, consumer);
        this.sword((Supplier)TropicraftItems.EUDIALYTE, (Supplier)TropicraftItems.EUDIALYTE_SWORD, consumer);
        this.helmet((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_HELMET, consumer);
        this.chestplate((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_CHESTPLATE, consumer);
        this.leggings((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_LEGGINGS, consumer);
        this.boots((Supplier)TropicraftItems.SCALE, (Supplier)TropicraftItems.SCALE_BOOTS, consumer);
        for (DyeColor color : DyeColor.values()) {
            IItemProvider wool = (IItemProvider)SheepEntity.field_200206_bz.get(color);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.UMBRELLAS.get(color).get())).func_200472_a("WWW").func_200472_a(" B ").func_200472_a(" B ").func_200473_b("tropicraft:umbrellas").func_200462_a(Character.valueOf('W'), wool).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + color.func_176610_l() + "_wool", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)wool)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.CHAIRS.get(color).get())).func_200472_a("BWB").func_200472_a("BWB").func_200472_a("BWB").func_200473_b("tropicraft:chairs").func_200462_a(Character.valueOf('W'), wool).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + color.func_176610_l() + "_wool", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)wool)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.BEACH_FLOATS.get(color).get())).func_200472_a("WWW").func_200472_a("BBB").func_200473_b("tropicraft:beach_floats").func_200462_a(Character.valueOf('W'), wool).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_222405_kQ).func_200465_a("has_" + color.func_176610_l() + "_wool", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)wool)).func_200464_a(consumer);
        }
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_STICK.get())).func_200472_a("X").func_200472_a("X").func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222068_kQ).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200467_a(consumer, new ResourceLocation("stick_from_bamboo_item"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_SPEAR.get())).func_200472_a("X ").func_200472_a(" X").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_bamboo_stick", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_STICK.get()))).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)TropicraftItems.RAW_COFFEE_BEAN.get())).func_200487_b((IItemProvider)TropicraftItems.COFFEE_BERRY.get()).func_200483_a("has_coffee_bean", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.COFFEE_BERRY.get()))).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)TropicraftItems.ZIRCONIUM.get())).func_200491_b((IItemProvider)TropicraftItems.AZURITE.get(), 2).func_200491_b((IItemProvider)TropicraftItems.ZIRCON.get(), 2).func_200483_a("has_zircon", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.ZIRCON.get()))).func_200483_a("has_azurite", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.AZURITE.get()))).func_200482_a(consumer);
        this.food((Supplier)TropicraftItems.RAW_COFFEE_BEAN, (Supplier)TropicraftItems.ROASTED_COFFEE_BEAN, 0.1f, consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_MUG.get())).func_200472_a("X X").func_200472_a("X X").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222068_kQ).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
        this.food((Supplier)Items.field_221600_aB.delegate, (Supplier)TropicraftItems.TOASTED_NORI, 0.1f, consumer);
        this.food((Supplier)TropicraftItems.FRESH_MARLIN, (Supplier)TropicraftItems.SEARED_MARLIN, 0.15f, consumer);
        this.food((Supplier)TropicraftItems.RAW_RAY, (Supplier)TropicraftItems.COOKED_RAY, 0.15f, consumer);
        this.food((Supplier)TropicraftItems.FROG_LEG, (Supplier)TropicraftItems.COOKED_FROG_LEG, 0.1f, consumer);
        this.food((Supplier)TropicraftItems.RAW_FISH, (Supplier)TropicraftItems.COOKED_FISH, 0.1f, consumer);
        this.dye(TropicraftFlower.COMMELINA_DIFFUSA, (Supplier)Items.field_196112_bf.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.CANNA, (Supplier)Items.field_222081_ls.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.ORANGE_ANTHURIUM, (Supplier)Items.field_196108_bd.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.RED_ANTHURIUM, (Supplier)Items.field_222078_li.delegate, 1, 2, consumer);
        this.dye(TropicraftFlower.DRACAENA, (Supplier)Items.field_222079_lj.delegate, 1, 2, consumer);
        this.dye((Supplier)TropicraftBlocks.IRIS, (Supplier)Items.field_196126_bm.delegate, 1, 4, consumer);
        this.singleItem((Supplier)Blocks.field_222405_kQ.delegate, (Supplier)TropicraftBlocks.BAMBOO_BUNDLE, 9, 1, consumer);
        this.singleItem((Supplier)Blocks.field_196608_cF.delegate, (Supplier)TropicraftBlocks.THATCH_BUNDLE, 9, 1, consumer);
        this.planks((Supplier)TropicraftBlocks.MAHOGANY_LOG, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, consumer);
        this.planks((Supplier)TropicraftBlocks.PALM_LOG, (Supplier)TropicraftBlocks.PALM_PLANKS, consumer);
        this.bark((Supplier)TropicraftBlocks.MAHOGANY_LOG, (Supplier)TropicraftBlocks.MAHOGANY_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.PALM_LOG, (Supplier)TropicraftBlocks.PALM_WOOD, consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196620_N).func_200487_b((IItemProvider)TropicraftBlocks.PAPAYA_LOG.get()).func_200483_a("has_papaya_log", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftBlocks.PAPAYA_LOG.get()))).func_200482_a(consumer);
        this.bark((Supplier)TropicraftBlocks.PAPAYA_LOG, (Supplier)TropicraftBlocks.PAPAYA_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.RED_MANGROVE_LOG, (Supplier)TropicraftBlocks.RED_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.LIGHT_MANGROVE_LOG, (Supplier)TropicraftBlocks.LIGHT_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.BLACK_MANGROVE_LOG, (Supplier)TropicraftBlocks.BLACK_MANGROVE_WOOD, consumer);
        this.bark((Supplier)TropicraftBlocks.STRIPPED_MANGROVE_LOG, (Supplier)TropicraftBlocks.STRIPPED_MANGROVE_WOOD, consumer);
        this.stairs((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_STAIRS, "wooden_stairs", false, consumer);
        this.stairs((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_STAIRS, null, false, consumer);
        this.stairs((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_STAIRS, null, false, consumer);
        this.stairs((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_STAIRS, null, true, consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TropicraftBlocks.THATCH_STAIRS_FUZZY.get()), (int)4).func_200472_a("C  ").func_200472_a("XC ").func_200472_a("XXC").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftBlocks.THATCH_BUNDLE.get()).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222065_kN).func_200465_a("has_thatch_bundle", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftBlocks.THATCH_BUNDLE.get()))).func_200464_a(consumer);
        this.slab((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_SLAB, "wooden_slab", false, consumer);
        this.slab((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_SLAB, null, false, consumer);
        this.slab((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_SLAB, null, false, consumer);
        this.slab((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_SLAB, null, true, consumer);
        this.fence((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_FENCE, "wooden_fence", consumer);
        this.fence((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_FENCE, null, consumer);
        this.fence((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_FENCE, null, consumer);
        this.fence((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_FENCE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_FENCE_GATE, "wooden_fence_gate", consumer);
        this.fenceGate((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_FENCE_GATE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_FENCE_GATE, null, consumer);
        this.fenceGate((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_FENCE_GATE, null, consumer);
        this.wall((Supplier)TropicraftBlocks.CHUNK, (Supplier)TropicraftBlocks.CHUNK_WALL, consumer);
        this.door((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_DOOR, "wooden_door", consumer);
        this.door((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_DOOR, null, consumer);
        this.door((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_DOOR, null, consumer);
        this.trapDoor((Supplier)TropicraftBlocks.PALM_PLANKS, (Supplier)TropicraftBlocks.PALM_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.MAHOGANY_PLANKS, (Supplier)TropicraftBlocks.MAHOGANY_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.MANGROVE_PLANKS, (Supplier)TropicraftBlocks.MANGROVE_TRAPDOOR, "wooden_trapdoor", consumer);
        this.trapDoor((Supplier)TropicraftBlocks.THATCH_BUNDLE, (Supplier)TropicraftBlocks.THATCH_TRAPDOOR, null, consumer);
        this.trapDoor((Supplier)TropicraftBlocks.BAMBOO_BUNDLE, (Supplier)TropicraftBlocks.BAMBOO_TRAPDOOR, null, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 1, (Supplier)TropicraftBlocks.SMALL_BONGO_DRUM, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 2, (Supplier)TropicraftBlocks.MEDIUM_BONGO_DRUM, consumer);
        this.bongo((Supplier)TropicraftItems.IGUANA_LEATHER, (Supplier)TropicraftBlocks.MAHOGANY_PLANKS, 3, (Supplier)TropicraftBlocks.LARGE_BONGO_DRUM, consumer);
        this.goggles((Supplier)TropicraftItems.PINK_SCUBA_GOGGLES, (Supplier)Items.field_196118_bi.delegate, consumer);
        this.goggles((Supplier)TropicraftItems.YELLOW_SCUBA_GOGGLES, (Supplier)Items.field_222081_ls.delegate, consumer);
        this.flippers((Supplier)TropicraftItems.PINK_SCUBA_FLIPPERS, (Supplier)Items.field_196118_bi.delegate, consumer);
        this.flippers((Supplier)TropicraftItems.YELLOW_SCUBA_FLIPPERS, (Supplier)Items.field_222081_ls.delegate, consumer);
        this.harness((Supplier)TropicraftItems.PINK_SCUBA_HARNESS, (Supplier)Items.field_196118_bi.delegate, consumer);
        this.harness((Supplier)TropicraftItems.YELLOW_SCUBA_HARNESS, (Supplier)Items.field_222081_ls.delegate, consumer);
        this.ponyBottle((Supplier)TropicraftItems.PINK_PONY_BOTTLE, (Supplier)Items.field_196118_bi.delegate, consumer);
        this.ponyBottle((Supplier)TropicraftItems.YELLOW_PONY_BOTTLE, (Supplier)Items.field_222081_ls.delegate, consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TropicraftItems.WATER_WAND.get()), (int)1).func_200472_a("  X").func_200472_a(" Y ").func_200472_a("Y  ").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftItems.AZURITE.get()).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151043_k).func_200465_a("has_" + this.safeName(TropicraftItems.AZURITE.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.AZURITE.get()))).func_200465_a("has_gold_ingot", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_ITEM_FRAME.get()), (int)1).func_200472_a("XXX").func_200472_a("XYX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222068_kQ).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151116_aA).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200465_a("has_leather", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TropicraftBlocks.AIR_COMPRESSOR.get()), (int)1).func_200472_a("XXX").func_200472_a("XYX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftBlocks.CHUNK.get()).func_200462_a(Character.valueOf('Y'), (IItemProvider)TropicraftItems.AZURITE.get()).func_200465_a("has_" + this.safeName(TropicraftBlocks.CHUNK.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftBlocks.CHUNK.get()))).func_200465_a("has_" + this.safeName(TropicraftItems.AZURITE.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.AZURITE.get()))).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)TropicraftBlocks.BAMBOO_LADDER.get()), (int)4).func_200472_a("S S").func_200472_a("BSB").func_200472_a("S S").func_200462_a(Character.valueOf('S'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_222068_kQ).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
        this.boardwalk((Supplier)TropicraftBlocks.BAMBOO_SLAB, (Supplier)TropicraftBlocks.BAMBOO_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.PALM_SLAB, (Supplier)TropicraftBlocks.PALM_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.MAHOGANY_SLAB, (Supplier)TropicraftBlocks.MAHOGANY_BOARDWALK, consumer);
        this.boardwalk((Supplier)TropicraftBlocks.MANGROVE_SLAB, (Supplier)TropicraftBlocks.MANGROVE_BOARDWALK, consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.BAMBOO_CHEST.get())).func_200472_a("BBB").func_200472_a("B B").func_200472_a("BBB").func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_222068_kQ).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.SIFTER.get())).func_200472_a("XXX").func_200472_a("XIX").func_200472_a("XXX").func_200469_a(Character.valueOf('X'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.GLASS).func_200473_b("tropicraft:sifter").func_200465_a("has_glass", (ICriterionInstance)TropicraftRecipeProvider.func_200409_a((ITag)Tags.Items.GLASS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.SIFTER.get())).func_200472_a("XXX").func_200472_a("XIX").func_200472_a("XXX").func_200469_a(Character.valueOf('X'), (ITag)ItemTags.field_199905_b).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.GLASS_PANES).func_200473_b("tropicraft:sifter").func_200465_a("has_glass_pane", (ICriterionInstance)TropicraftRecipeProvider.func_200409_a((ITag)Tags.Items.GLASS_PANES)).func_200467_a(consumer, new ResourceLocation("tropicraft", "sifter_with_glass_pane"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.DRINK_MIXER.get())).func_200472_a("XXX").func_200472_a("XYX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftBlocks.CHUNK.get()).func_200462_a(Character.valueOf('Y'), (IItemProvider)TropicraftItems.BAMBOO_MUG.get()).func_200465_a("has_bamboo_mug", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_MUG.get()))).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.TIKI_TORCH.get())).func_200472_a("Y").func_200472_a("X").func_200472_a("X").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200469_a(Character.valueOf('Y'), (ITag)ItemTags.field_219775_L).func_200465_a("has_bamboo_stick", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_STICK.get()))).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftBlocks.BAMBOO_FLOWER_POT.get())).func_200472_a("# #").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_222068_kQ).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)((RegistryObject)TropicraftItems.COCKTAILS.get((Object)Drink.PINA_COLADA)).get())).func_200487_b((IItemProvider)TropicraftItems.BAMBOO_MUG.get()).func_200487_b((IItemProvider)TropicraftItems.COCONUT_CHUNK.get()).func_200487_b((IItemProvider)TropicraftItems.PINEAPPLE_CUBES.get()).func_200483_a("has_bamboo_mug", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_MUG.get()))).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)TropicraftItems.TROPICAL_FERTILIZER.get())).func_200487_b((IItemProvider)TropicraftFlower.MAGIC_MUSHROOM.get()).func_200487_b((IItemProvider)TropicraftFlower.CROTON.get()).func_200483_a("has_magic_mushroom", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)TropicraftFlower.MAGIC_MUSHROOM.get())).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.DAGGER.get())).func_200472_a("X").func_200472_a("I").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftBlocks.CHUNK.get()).func_200462_a(Character.valueOf('I'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName(TropicraftBlocks.CHUNK.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftBlocks.CHUNK.get()))).func_200465_a("has_bamboo", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)TropicraftItems.BLOW_GUN.get())).func_200472_a("X  ").func_200472_a(" I ").func_200472_a("  X").func_200462_a(Character.valueOf('X'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200462_a(Character.valueOf('I'), (IItemProvider)TropicraftItems.ZIRCON.get()).func_200465_a("has_" + this.safeName(TropicraftItems.ZIRCON.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.ZIRCON.get()))).func_200465_a("has_" + this.safeName(TropicraftItems.BAMBOO_STICK.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.BAMBOO_STICK.get()))).func_200464_a(consumer);
    }

    private ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(id.func_110624_b(), this.safeName(id));
    }

    private ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    private String safeName(ResourceLocation nameSource) {
        return nameSource.func_110623_a().replace('/', '_');
    }

    private String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void ore(ITag.INamedTag<Item> source, Supplier<T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(source.func_230234_a_()), (ICriterionInstance)TropicraftRecipeProvider.func_200409_a(source)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199805_a(source), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(source.func_230234_a_()), (ICriterionInstance)TropicraftRecipeProvider.func_200409_a(source)).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_blasting");
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void food(Supplier<? extends T> source, Supplier<? extends T> result, float xp, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218630_a(consumer);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_smoking");
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (float)xp, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_" + this.safeName(((IForgeRegistryEntry)((IItemProvider)source.get())).getRegistryName()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218632_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_campfire");
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_at_least_9_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)input.get()), (int)9).func_200487_b((IItemProvider)output.get()).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)output.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)output.get()))).func_200484_a(consumer, this.safeId((IForgeRegistryEntry)input.get()) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void pickaxe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XXX").func_200472_a(" B ").func_200472_a(" B ").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Items.field_222068_kQ), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void shovel(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a(" X ").func_200472_a(" B ").func_200472_a(" B ").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Items.field_222068_kQ), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void axe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XX ").func_200472_a("XB ").func_200472_a(" B ").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Items.field_222068_kQ), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void hoe(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XX ").func_200472_a(" B ").func_200472_a(" B ").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Items.field_222068_kQ), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void sword(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a(" X ").func_200472_a(" X ").func_200472_a(" B ").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)TropicraftItems.BAMBOO_STICK.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Items.field_222068_kQ), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Items.field_222068_kQ)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void helmet(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XXX").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void chestplate(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void leggings(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void boots(Supplier<? extends T> input, Supplier<? extends T> output, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200472_a("X X").func_200472_a("X X").func_200462_a(Character.valueOf('X'), (IItemProvider)input.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)input.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)input.get()))).func_200464_a(consumer);
    }

    @CheckReturnValue
    private <T extends IItemProvider & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)amount).func_200491_b((IItemProvider)source.get(), required).func_200483_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get())));
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void dye(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).func_200485_a(consumer, new ResourceLocation("tropicraft", ((IForgeRegistryEntry)((IItemProvider)result.get())).getRegistryName().func_110623_a()));
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void singleItem(Supplier<? extends T> source, Supplier<? extends T> result, int required, int amount, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, required, amount).func_200482_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void planks(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        this.singleItemUnfinished(source, result, 1, 4).func_200490_a("planks").func_200482_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void bark(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)source.get()).func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Blocks.field_196621_O)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void stairs(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("X  ").func_200472_a("XX ").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get())).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void slab(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, boolean stone, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
        if (stone) {
            SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get()), (int)2).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
        }
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void boardwalk(Supplier<? extends T> slab, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("XXX").func_200472_a("S S").func_200462_a(Character.valueOf('X'), (IItemProvider)slab.get()).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("tropicraft:boardwalk").func_200465_a("has_" + this.safeName((IForgeRegistryEntry)slab.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)slab.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void fence(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("W#W").func_200472_a("W#W").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void fenceGate(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("#W#").func_200472_a("#W#").func_200462_a(Character.valueOf('W'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void wall(Supplier<? extends T> source, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)source.get()}), (IItemProvider)((IItemProvider)result.get())).func_218643_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_218645_a(consumer, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName((IForgeRegistryEntry)source.get()) + "_stonecutting");
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void door(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("XX").func_200472_a("XX").func_200472_a("XX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void trapDoor(Supplier<? extends T> source, Supplier<? extends T> result, @Nullable String group, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)2).func_200472_a("XXX").func_200472_a("XXX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200473_b(group).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void bongo(Supplier<? extends T> top, Supplier<? extends T> bottom, int size, Supplier<? extends T> result, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a(StringUtils.repeat((char)'T', (int)size)).func_200472_a(StringUtils.repeat((char)'B', (int)size)).func_200472_a(StringUtils.repeat((char)'B', (int)size)).func_200462_a(Character.valueOf('T'), (IItemProvider)top.get()).func_200462_a(Character.valueOf('B'), (IItemProvider)bottom.get()).func_200473_b("tropicraft:bongos").func_200465_a("has_" + this.safeName((IForgeRegistryEntry)top.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)top.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void goggles(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("YYY").func_200472_a("X X").func_200472_a(" Z ").func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('Y'), (IItemProvider)TropicraftItems.ZIRCON.get()).func_200462_a(Character.valueOf('Z'), (IItemProvider)source.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200465_a("has_" + this.safeName(TropicraftItems.ZIRCON.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.ZIRCON.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void flippers(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("XX").func_200472_a("YY").func_200472_a("XX").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200462_a(Character.valueOf('Y'), (IItemProvider)TropicraftItems.ZIRCON.get()).func_200465_a("has_" + this.safeName((IForgeRegistryEntry)source.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)source.get()))).func_200465_a("has_" + this.safeName(TropicraftItems.ZIRCON.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.ZIRCON.get()))).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void ponyBottle(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("Y").func_200472_a("X").func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_196764_gF).func_200462_a(Character.valueOf('Y'), (IItemProvider)Blocks.field_150442_at).func_200465_a("has_" + this.safeName((IForgeRegistryEntry<?>)Blocks.field_196764_gF), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)Blocks.field_196764_gF)).func_200464_a(consumer);
    }

    private <T extends IItemProvider & IForgeRegistryEntry<?>> void harness(Supplier<? extends T> result, Supplier<? extends T> source, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)1).func_200472_a("Y Y").func_200472_a("YXY").func_200472_a("YZY").func_200462_a(Character.valueOf('X'), (IItemProvider)source.get()).func_200469_a(Character.valueOf('Y'), TropicraftTags.Items.LEATHER).func_200462_a(Character.valueOf('Z'), (IItemProvider)TropicraftItems.AZURITE.get()).func_200465_a("has_" + this.safeName(TropicraftItems.AZURITE.get()), (ICriterionInstance)TropicraftRecipeProvider.func_200403_a((IItemProvider)((IItemProvider)TropicraftItems.AZURITE.get()))).func_200464_a(consumer);
    }
}

