/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.EntityFlagsPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.data.loot.MatchSwordCondition;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.neutral.TreeFrogEntity;
import net.tropicraft.core.common.item.RecordMusic;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropicraftLootTableProvider
extends LootTableProvider {
    public TropicraftLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new Entities(), (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationresults) {
    }

    private static class Blocks
    extends BlockLootTables {
        private static final float[] FRUIT_SAPLING_RATES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
        private static final float[] SAPLING_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] RARE_SAPLING_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

        private Blocks() {
        }

        protected void addTables() {
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.AZURITE_ORE, (Supplier<? extends IItemProvider>)TropicraftItems.AZURITE);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_ORE, (Supplier<? extends IItemProvider>)TropicraftItems.EUDIALYTE);
            this.dropsOreItem((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_ORE, (Supplier<? extends IItemProvider>)TropicraftItems.ZIRCON);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SHAKA_ORE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_ORE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.AZURITE_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ZIRCONIUM_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SHAKA_BLOCK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_BLOCK);
            TropicraftBlocks.FLOWERS.values().forEach(this::dropsSelf);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PACKED_PURIFIED_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CORAL_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.FOAMY_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.VOLCANIC_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MINERAL_SAND);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MUD);
            this.func_218507_a((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get(), (LootTable.Builder)Blocks.func_218552_a((IItemProvider)((IItemProvider)TropicraftBlocks.MUD_WITH_PIANGUAS.get()), (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TropicraftBlocks.MUD_WITH_PIANGUAS.get())).func_212840_b_(field_218573_a)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TropicraftBlocks.MUD.get()))))).func_216040_a(LootPool.func_216096_a().func_212840_b_(field_218574_b).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TropicraftItems.PIANGUAS.get())).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BUNDLE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_BUNDLE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_ROOTS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_LOG);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_WOOD);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_STAIRS);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_STAIRS_FUZZY);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.BAMBOO_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.THATCH_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.CHUNK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.PALM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.MAHOGANY_SLAB);
            this.slab((Supplier<? extends SlabBlock>)TropicraftBlocks.MANGROVE_SLAB);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.MAHOGANY_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.MAHOGANY_SAPLING, RARE_SAPLING_RATES);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.PALM_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.PALM_SAPLING, SAPLING_RATES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.KAPOK_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.FRUIT_LEAVES);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.GRAPEFRUIT_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.GRAPEFRUIT_SAPLING, (Supplier<? extends IItemProvider>)TropicraftItems.GRAPEFRUIT);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.LEMON_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.LEMON_SAPLING, (Supplier<? extends IItemProvider>)TropicraftItems.LEMON);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.LIME_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.LIME_SAPLING, (Supplier<? extends IItemProvider>)TropicraftItems.LIME);
            this.fruitLeaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.ORANGE_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.ORANGE_SAPLING, (Supplier<? extends IItemProvider>)TropicraftItems.ORANGE);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.RED_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.TALL_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.TEA_MANGROVE_LEAVES);
            this.leavesNoSapling((Supplier<? extends LeavesBlock>)TropicraftBlocks.BLACK_MANGROVE_LEAVES);
            this.leaves((Supplier<? extends LeavesBlock>)TropicraftBlocks.PAPAYA_LEAVES, (Supplier<? extends SaplingBlock>)TropicraftBlocks.PAPAYA_SAPLING, SAPLING_RATES);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LEMON_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LIME_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.ORANGE_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_SAPLING);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.TALL_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.TEA_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_PROPAGULE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_FENCE_GATE);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.CHUNK_WALL);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.THATCH_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_DOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_DOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.THATCH_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_TRAPDOOR);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_TRAPDOOR);
            this.doubleBlock((Supplier<? extends Block>)TropicraftBlocks.IRIS);
            this.func_218522_a((Block)TropicraftBlocks.PINEAPPLE.get(), b -> Blocks.droppingChunks(b, TropicraftItems.PINEAPPLE_CUBES, (ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.REEDS);
            this.func_218522_a((Block)TropicraftBlocks.PAPAYA.get(), b -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)Blocks.func_218552_a((IItemProvider)b, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)((PapayaBlock)TropicraftBlocks.PAPAYA.get()).func_199767_j()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PapayaBlock.AGE, 1))))))));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SMALL_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MEDIUM_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.LARGE_BONGO_DRUM);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.PALM_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_BOARDWALK);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_CHEST);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.SIFTER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.DRINK_MIXER);
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.AIR_COMPRESSOR);
            this.func_218522_a((Block)TropicraftBlocks.TIKI_TORCH.get(), b -> Blocks.func_218562_a((Block)b, TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.UPPER)));
            this.func_218522_a((Block)TropicraftBlocks.COCONUT.get(), b -> Blocks.droppingChunks(b, TropicraftItems.COCONUT_CHUNK));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT);
            TropicraftBlocks.ALL_POTTED_PLANTS.forEach(ro -> this.func_218522_a((Block)ro.get(), b -> Blocks.droppingFlowerPotAndFlower((FlowerPotBlock)b)));
            this.func_218507_a((Block)TropicraftBlocks.COFFEE_BUSH.get(), Blocks.dropNumberOfItems((Block)TropicraftBlocks.COFFEE_BUSH.get(), TropicraftItems.RAW_COFFEE_BEAN, 1, 3));
            this.dropsSelf((Supplier<? extends Block>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
            this.dropsOther((Supplier<? extends Block>)TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN, (Supplier<? extends IItemProvider>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
            this.dropsOther((Supplier<? extends Block>)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN, (Supplier<? extends IItemProvider>)TropicraftBlocks.GOLDEN_LEATHER_FERN);
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.func_218492_c(block.get());
        }

        private void dropsOther(Supplier<? extends Block> block, Supplier<? extends IItemProvider> drops) {
            this.func_218493_a(block.get(), drops.get());
        }

        private void dropsOreItem(Supplier<? extends Block> block, Supplier<? extends IItemProvider> item) {
            this.func_218522_a(block.get(), b -> Blocks.func_218476_a((Block)b, (Item)((IItemProvider)item.get()).func_199767_j()));
        }

        private void slab(Supplier<? extends SlabBlock> block) {
            this.func_218522_a((Block)block.get(), BlockLootTables::func_218513_d);
        }

        private void leaves(Supplier<? extends LeavesBlock> block, Supplier<? extends SaplingBlock> sapling, float[] rates) {
            this.func_218522_a((Block)block.get(), b -> Blocks.func_218540_a((Block)b, (Block)((Block)sapling.get()), (float[])rates));
        }

        private void leavesNoSapling(Supplier<? extends LeavesBlock> block) {
            this.func_218522_a((Block)block.get(), Blocks::droppingWithSticks);
        }

        private void fruitLeaves(Supplier<? extends LeavesBlock> block, Supplier<? extends SaplingBlock> sapling, Supplier<? extends IItemProvider> fruit) {
            this.func_218522_a((Block)block.get(), b -> Blocks.droppingWithChancesSticksAndFruit(b, (Block)sapling.get(), (IItemProvider)fruit.get(), FRUIT_SAPLING_RATES));
        }

        protected static LootTable.Builder onlyWithSilkTouchOrShears(Block block) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(field_218576_d).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)));
        }

        protected static LootTable.Builder droppingWithSticks(Block block) {
            return Blocks.onlyWithSilkTouchOrShears(block).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(field_218577_e).func_216045_a(((StandaloneLootEntry.Builder)Blocks.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        protected static LootTable.Builder droppingWithChancesSticksAndFruit(Block block, Block sapling, IItemProvider fruit, float[] chances) {
            return Blocks.func_218540_a((Block)block, (Block)sapling, (float[])chances).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(field_218577_e).func_216045_a((LootEntry.Builder)Blocks.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)fruit))));
        }

        private void doubleBlock(Supplier<? extends Block> block) {
            this.func_218522_a(block.get(), b -> Blocks.func_218562_a((Block)b, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        }

        protected static LootTable.Builder droppingFlowerPotAndFlower(FlowerPotBlock fullPot) {
            return LootTable.func_216119_b().func_216040_a((LootPool.Builder)Blocks.func_218560_a((IItemProvider)fullPot.getEmptyPot(), (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)fullPot.getEmptyPot())))).func_216040_a((LootPool.Builder)Blocks.func_218560_a((IItemProvider)fullPot.func_220276_d(), (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)fullPot.func_220276_d()))));
        }

        private static LootPool.Builder droppingChunksPool(Block block, Supplier<? extends IItemProvider> chunk) {
            return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)chunk.get()).func_212840_b_(MatchSwordCondition.builder())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))).func_216080_a((LootEntry.Builder)Blocks.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)block))));
        }

        protected static LootTable.Builder droppingChunks(Block block, Supplier<? extends IItemProvider> chunk) {
            return LootTable.func_216119_b().func_216040_a(Blocks.droppingChunksPool(block, chunk));
        }

        protected static LootTable.Builder droppingChunks(Block block, Supplier<? extends IItemProvider> chunk, ILootCondition.IBuilder condition) {
            return LootTable.func_216119_b().func_216040_a(Blocks.droppingChunksPool(block, chunk).func_212840_b_(condition));
        }

        private static LootTable.Builder dropNumberOfItems(Block block, Supplier<? extends IItemProvider> drop, int minDrops, int maxDrops) {
            return LootTable.func_216119_b().func_216040_a((LootPool.Builder)Blocks.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minDrops, (float)maxDrops)))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TropicraftBlocks.BLOCKS.getEntries().stream().map(Supplier::get).filter(block -> {
                ResourceLocation lootTable = block.func_220068_i();
                return lootTable != null && lootTable.func_110624_b().equals("tropicraft");
            }).collect(Collectors.toList());
        }
    }

    private static class Entities
    extends EntityLootTables {
        private Entities() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)TropicraftEntities.TROPI_CREEPER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)((RegistryObject)TropicraftItems.MUSIC_DISCS.get((Object)RecordMusic.EASTERN_ISLES)).get()))).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217989_a((ITag)EntityTypeTags.field_219764_a)))));
            this.dropItemsWithEnchantBonus(TropicraftEntities.IGUANA, TropicraftItems.IGUANA_LEATHER, TropicraftItems.SCALE, (IRandomRange)ConstantRange.func_215835_a((int)3));
            this.noDrops(TropicraftEntities.TROPI_SKELLY);
            this.dropItemsWithEnchantBonus(TropicraftEntities.EIH, ((Block)TropicraftBlocks.CHUNK.get()).func_199767_j(), (IRandomRange)ConstantRange.func_215835_a((int)3));
            this.dropItem(TropicraftEntities.SEA_TURTLE, TropicraftItems.TURTLE_SHELL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.MARLIN, TropicraftItems.FRESH_MARLIN, (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.FAILGULL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.DOLPHIN, TropicraftItems.TROPICAL_FERTILIZER, (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.SEAHORSE);
            this.func_218582_a((EntityType)TropicraftEntities.TREE_FROG.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217987_a(new EntityFlagsPredicate(null, null, null, null, Boolean.valueOf(false))).func_209365_a(new NBTPredicate((CompoundNBT)Util.func_200696_a((Object)new CompoundNBT(), c -> c.func_74768_a("Type", TreeFrogEntity.Type.GREEN.ordinal())))))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TropicraftItems.POISON_FROG_SKIN.get())))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)TropicraftItems.FROG_LEG.get())))));
            this.dropItem(TropicraftEntities.SEA_URCHIN, TropicraftItems.SEA_URCHIN_ROE);
            this.noDrops(TropicraftEntities.SEA_URCHIN_EGG_ENTITY);
            this.dropItem(TropicraftEntities.STARFISH, TropicraftItems.STARFISH);
            this.noDrops(TropicraftEntities.STARFISH_EGG);
            this.noDrops(TropicraftEntities.V_MONKEY);
            this.noDrops(TropicraftEntities.RIVER_SARDINE);
            this.dropItem(TropicraftEntities.RIVER_SARDINE, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.PIRANHA, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.TROPICAL_FISH, TropicraftItems.RAW_FISH);
            this.dropItem(TropicraftEntities.EAGLE_RAY, TropicraftItems.RAW_RAY);
            this.noDrops(TropicraftEntities.TROPI_SPIDER);
            this.noDrops(TropicraftEntities.TROPI_SPIDER_EGG);
            this.noDrops(TropicraftEntities.ASHEN);
            this.dropItemsWithEnchantBonus(TropicraftEntities.HAMMERHEAD, TropicraftItems.TROPICAL_FERTILIZER, (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f));
            this.noDrops(TropicraftEntities.SEA_TURTLE_EGG);
            this.noDrops(TropicraftEntities.TROPI_BEE);
            this.noDrops(TropicraftEntities.COWKTAIL);
            this.dropItemsWithEnchantBonus(TropicraftEntities.MAN_O_WAR, Items.field_151123_aH, (IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)4.0f));
            this.noDrops(TropicraftEntities.TAPIR);
            this.noDrops(TropicraftEntities.JAGUAR);
            this.noDrops(TropicraftEntities.BROWN_BASILISK_LIZARD);
            this.noDrops(TropicraftEntities.GREEN_BASILISK_LIZARD);
            this.noDrops(TropicraftEntities.HUMMINGBIRD);
            this.noDrops(TropicraftEntities.FIDDLER_CRAB);
            this.noDrops(TropicraftEntities.SPIDER_MONKEY);
            this.noDrops(TropicraftEntities.WHITE_LIPPED_PECCARY);
            this.dropItem(TropicraftEntities.CUBERA, TropicraftItems.RAW_FISH);
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot, RegistryObject<Item> multiLoot, IRandomRange range) {
            this.func_218582_a((EntityType)entity.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)loot.get())))).func_216040_a(LootPool.func_216096_a().func_216046_a(range).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)multiLoot.get())).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)0.33333334f))))));
        }

        public <T extends LivingEntity> void dropItem(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot) {
            this.func_218582_a((EntityType)entity.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)loot.get())))));
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, RegistryObject<Item> loot, IRandomRange range) {
            this.dropItemsWithEnchantBonus(entity, (Item)loot.get(), range);
        }

        public <T extends LivingEntity> void dropItemsWithEnchantBonus(RegistryObject<EntityType<T>> entity, Item loot, IRandomRange range) {
            this.func_218582_a((EntityType)entity.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a(range).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)loot).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)0.33333334f))))));
        }

        public <T extends LivingEntity> void noDrops(RegistryObject<EntityType<T>> entity) {
            this.func_218582_a((EntityType)entity.get(), LootTable.func_216119_b());
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return TropicraftEntities.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

