/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class MapBiomesCommand {
    private static final int SIZE = 4096;
    private static final int SIZE2 = 2048;
    private static final int SIZE8 = 512;
    private static final Object2IntOpenHashMap<ResourceLocation> COLORS = new Object2IntOpenHashMap();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mapbiomes").requires(s -> s.func_197034_c(2))).executes(c -> MapBiomesCommand.execute((CommandSource)c.getSource())));
    }

    private static int execute(CommandSource source) {
        if (!source.func_197023_e().func_234923_W_().equals(TropicraftDimension.WORLD)) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Can't execute this in non-tropicraft world!"));
        }
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        MutableRegistry biomes = source.func_197023_e().func_241828_r().func_243612_b(Registry.field_239720_u_);
        for (int x = -2048; x < 2048; ++x) {
            if (x % 512 == 0) {
                source.func_197030_a((ITextComponent)new StringTextComponent((double)(x + 2048) / 4096.0 * 100.0 + "%"), false);
            }
            for (int z = -2048; z < 2048; ++z) {
                Biome biome = source.func_197023_e().func_225604_a_(x, 0, z);
                ResourceLocation name = biomes.func_177774_c((Object)biome);
                img.setRGB(x + 2048, z + 2048, COLORS.getOrDefault((Object)name, 0xFFFFFF));
            }
        }
        Path p = Paths.get("biome_colors.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
            source.func_197030_a((ITextComponent)new StringTextComponent("Mapped biome colors!"), false);
        }
        catch (IOException e) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Something went wrong, check the log!"), true);
            e.printStackTrace();
        }
        return 0;
    }

    static {
        COLORS.put((Object)TropicraftBiomes.TROPICS.func_240901_a_(), 8183411);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST_PLAINS.func_240901_a_(), 4175157);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST_HILLS.func_240901_a_(), 4175157);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST_MOUNTAINS.func_240901_a_(), 4175157);
        COLORS.put((Object)TropicraftBiomes.RAINFOREST_ISLAND_MOUNTAINS.func_240901_a_(), 3981872);
        COLORS.put((Object)TropicraftBiomes.OSA_RAINFOREST.func_240901_a_(), 5820749);
        COLORS.put((Object)TropicraftBiomes.BAMBOO_RAINFOREST.func_240901_a_(), 5751356);
        COLORS.put((Object)TropicraftBiomes.MANGROVES.func_240901_a_(), 4491059);
        COLORS.put((Object)TropicraftBiomes.OVERGROWN_MANGROVES.func_240901_a_(), 6129459);
        COLORS.put((Object)TropicraftBiomes.TROPICS_OCEAN.func_240901_a_(), 5226953);
        COLORS.put((Object)TropicraftBiomes.TROPICS_RIVER.func_240901_a_(), 5226953);
        COLORS.put((Object)TropicraftBiomes.KELP_FOREST.func_240901_a_(), 5228975);
        COLORS.put((Object)TropicraftBiomes.TROPICS_BEACH.func_240901_a_(), 15262615);
    }
}

