/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.jigarbov;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum JigarbovTorchType implements IStringSerializable
{
    ACACIA("acacia", () -> Blocks.field_196621_O),
    BIRCH("birch", () -> Blocks.field_196619_M),
    DARK_OAK("dark_oak", () -> Blocks.field_196623_P),
    JUNGLE("jungle", () -> Blocks.field_196620_N),
    OAK("oak", () -> Blocks.field_196617_K),
    SPRUCE("spruce", () -> Blocks.field_196618_L),
    BLACK_MANGROVE("black_mangrove", (Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG),
    LIGHT_MANGROVE("light_mangrove", (Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG),
    RED_MANGROVE("red_mangrove", (Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);

    private static final JigarbovTorchType[] VALUES;
    private final String name;
    private final Supplier<? extends Block> log;

    private JigarbovTorchType(String name, Supplier<? extends Block> log) {
        this.name = name;
        this.log = log;
    }

    @Nullable
    public static JigarbovTorchType byBlock(Block block) {
        if (block.func_203417_a((ITag)BlockTags.field_200031_h)) {
            for (JigarbovTorchType type : VALUES) {
                if (!type.matchesLog(block)) continue;
                return type;
            }
            return OAK;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean matchesLog(Block block) {
        return this.log.get() == block;
    }

    public String func_176610_l() {
        return this.name;
    }

    static {
        VALUES = JigarbovTorchType.values();
    }
}

