/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.tileentity.SimpleItemStackRenderer;
import net.tropicraft.core.common.Foods;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.Builder;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;
import net.tropicraft.core.common.block.GrowableSinglePlantBlock;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.PortalWaterBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.SifterBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftTrees;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import net.tropicraft.core.common.block.tileentity.AirCompressorTileEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestTileEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerTileEntity;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;

public class TropicraftBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tropicraft");
    public static final DeferredRegister<Item> BLOCKITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tropicraft");
    public static final RegistryObject<PortalWaterBlock> PORTAL_WATER = TropicraftBlocks.registerNoItem("portal_water", () -> new PortalWaterBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_222380_e()));
    public static final RegistryObject<Block> CHUNK = TropicraftBlocks.register("chunk", Builder.block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(6.0f, 30.0f)));
    public static final RegistryObject<Block> AZURITE_ORE = TropicraftBlocks.register("azurite_ore", Builder.ore(MaterialColor.field_151670_w));
    public static final RegistryObject<Block> EUDIALYTE_ORE = TropicraftBlocks.register("eudialyte_ore", Builder.ore(MaterialColor.field_151670_w));
    public static final RegistryObject<Block> MANGANESE_ORE = TropicraftBlocks.register("manganese_ore", Builder.ore(MaterialColor.field_151646_E));
    public static final RegistryObject<Block> SHAKA_ORE = TropicraftBlocks.register("shaka_ore", Builder.ore(MaterialColor.field_151646_E));
    public static final RegistryObject<Block> ZIRCON_ORE = TropicraftBlocks.register("zircon_ore", Builder.ore(MaterialColor.field_151670_w));
    public static final RegistryObject<Block> AZURITE_BLOCK = TropicraftBlocks.register("azurite_block", Builder.oreBlock(MaterialColor.field_151674_s));
    public static final RegistryObject<Block> EUDIALYTE_BLOCK = TropicraftBlocks.register("eudialyte_block", Builder.oreBlock(MaterialColor.field_151671_v));
    public static final RegistryObject<Block> MANGANESE_BLOCK = TropicraftBlocks.register("manganese_block", Builder.oreBlock(MaterialColor.field_151678_z));
    public static final RegistryObject<Block> SHAKA_BLOCK = TropicraftBlocks.register("shaka_block", Builder.oreBlock(MaterialColor.field_151649_A));
    public static final RegistryObject<Block> ZIRCON_BLOCK = TropicraftBlocks.register("zircon_block", Builder.oreBlock(MaterialColor.field_151645_D));
    public static final RegistryObject<Block> ZIRCONIUM_BLOCK = TropicraftBlocks.register("zirconium_block", Builder.oreBlock(MaterialColor.field_151671_v));
    public static final Map<TropicraftFlower, RegistryObject<FlowerBlock>> FLOWERS = Arrays.stream(TropicraftFlower.values()).collect(Collectors.toMap(Function.identity(), f -> TropicraftBlocks.register(f.getId(), Builder.flower(f)), (f1, f2) -> {
        throw new IllegalStateException();
    }, () -> new EnumMap(TropicraftFlower.class)));
    public static final RegistryObject<Block> PURIFIED_SAND = TropicraftBlocks.register("purified_sand", Builder.sand(MaterialColor.field_151658_d));
    public static final RegistryObject<Block> PACKED_PURIFIED_SAND = TropicraftBlocks.register("packed_purified_sand", Builder.sand(MaterialColor.field_151658_d, 2.0f, 30.0f));
    public static final RegistryObject<Block> CORAL_SAND = TropicraftBlocks.register("coral_sand", Builder.sand(MaterialColor.field_151671_v));
    public static final RegistryObject<Block> FOAMY_SAND = TropicraftBlocks.register("foamy_sand", Builder.sand(MaterialColor.field_151651_C));
    public static final RegistryObject<Block> VOLCANIC_SAND = TropicraftBlocks.register("volcanic_sand", Builder.volcanicSand(MaterialColor.field_197656_x));
    public static final RegistryObject<Block> MINERAL_SAND = TropicraftBlocks.register("mineral_sand", Builder.sand(MaterialColor.field_151658_d));
    public static final RegistryObject<Block> MUD = TropicraftBlocks.register("mud", Builder.mud());
    public static final RegistryObject<Block> MUD_WITH_PIANGUAS = TropicraftBlocks.register("mud_with_pianguas", Builder.mud());
    public static final RegistryObject<RotatedPillarBlock> BAMBOO_BUNDLE = TropicraftBlocks.register("bamboo_bundle", Builder.bundle(AbstractBlock.Properties.func_200949_a((Material)Material.field_215713_z, (MaterialColor)MaterialColor.field_151669_i).func_200947_a(SoundType.field_222468_o).func_200948_a(0.2f, 5.0f)));
    public static final RegistryObject<RotatedPillarBlock> THATCH_BUNDLE = TropicraftBlocks.register("thatch_bundle", Builder.bundle(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151663_o).func_200947_a(SoundType.field_185850_c).func_200948_a(0.2f, 5.0f)));
    public static final RegistryObject<Block> MAHOGANY_PLANKS = TropicraftBlocks.register("mahogany_planks", Builder.plank(MaterialColor.field_151650_B));
    public static final RegistryObject<Block> PALM_PLANKS = TropicraftBlocks.register("palm_planks", Builder.plank(MaterialColor.field_151663_o));
    public static final RegistryObject<RotatedPillarBlock> MAHOGANY_LOG = TropicraftBlocks.register("mahogany_log", Builder.log(MaterialColor.field_151663_o, MaterialColor.field_151650_B));
    public static final RegistryObject<RotatedPillarBlock> PALM_LOG = TropicraftBlocks.register("palm_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B));
    public static final RegistryObject<RotatedPillarBlock> MAHOGANY_WOOD = TropicraftBlocks.register("mohogany_wood", Builder.wood(MaterialColor.field_151663_o));
    public static final RegistryObject<RotatedPillarBlock> PALM_WOOD = TropicraftBlocks.register("palm_wood", Builder.wood(MaterialColor.field_151670_w));
    public static final RegistryObject<StairsBlock> PALM_STAIRS = TropicraftBlocks.register("palm_stairs", Builder.stairs(PALM_PLANKS));
    public static final RegistryObject<StairsBlock> MAHOGANY_STAIRS = TropicraftBlocks.register("mahogany_stairs", Builder.stairs(MAHOGANY_PLANKS));
    public static final RegistryObject<StairsBlock> THATCH_STAIRS = TropicraftBlocks.register("thatch_stairs", Builder.stairs(THATCH_BUNDLE));
    public static final RegistryObject<StairsBlock> THATCH_STAIRS_FUZZY = TropicraftBlocks.register("thatch_stairs_fuzzy", Builder.stairs(THATCH_BUNDLE));
    public static final RegistryObject<StairsBlock> BAMBOO_STAIRS = TropicraftBlocks.register("bamboo_stairs", Builder.stairs(BAMBOO_BUNDLE));
    public static final RegistryObject<StairsBlock> CHUNK_STAIRS = TropicraftBlocks.register("chunk_stairs", Builder.stairs(CHUNK));
    public static final RegistryObject<Block> COCONUT = TropicraftBlocks.register("coconut", () -> new CoconutBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151572_C).func_200943_b(2.0f).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<SlabBlock> BAMBOO_SLAB = TropicraftBlocks.register("bamboo_slab", Builder.slab(BAMBOO_BUNDLE));
    public static final RegistryObject<SlabBlock> THATCH_SLAB = TropicraftBlocks.register("thatch_slab", Builder.slab(THATCH_BUNDLE));
    public static final RegistryObject<SlabBlock> CHUNK_SLAB = TropicraftBlocks.register("chunk_slab", Builder.slab(CHUNK));
    public static final RegistryObject<SlabBlock> PALM_SLAB = TropicraftBlocks.register("palm_slab", Builder.slab(PALM_PLANKS));
    public static final RegistryObject<SlabBlock> MAHOGANY_SLAB = TropicraftBlocks.register("mahogany_slab", Builder.slab(MAHOGANY_PLANKS));
    public static final RegistryObject<LeavesBlock> MAHOGANY_LEAVES = TropicraftBlocks.register("mahogany_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> PALM_LEAVES = TropicraftBlocks.register("palm_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> KAPOK_LEAVES = TropicraftBlocks.register("kapok_leaves", Builder.leaves(false));
    public static final RegistryObject<LeavesBlock> FRUIT_LEAVES = TropicraftBlocks.register("fruit_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> GRAPEFRUIT_LEAVES = TropicraftBlocks.register("grapefruit_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> LEMON_LEAVES = TropicraftBlocks.register("lemon_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> LIME_LEAVES = TropicraftBlocks.register("lime_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> ORANGE_LEAVES = TropicraftBlocks.register("orange_leaves", Builder.leaves(true));
    public static final RegistryObject<LeavesBlock> PAPAYA_LEAVES = TropicraftBlocks.register("papaya_leaves", Builder.leaves(false));
    public static final RegistryObject<SaplingBlock> GRAPEFRUIT_SAPLING = TropicraftBlocks.register("grapefruit_sapling", Builder.sapling(TropicraftTrees.GRAPEFRUIT, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> LEMON_SAPLING = TropicraftBlocks.register("lemon_sapling", Builder.sapling(TropicraftTrees.LEMON, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> LIME_SAPLING = TropicraftBlocks.register("lime_sapling", Builder.sapling(TropicraftTrees.LIME, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> ORANGE_SAPLING = TropicraftBlocks.register("orange_sapling", Builder.sapling(TropicraftTrees.ORANGE, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> PAPAYA_SAPLING = TropicraftBlocks.register("papaya_sapling", Builder.sapling(TropicraftTrees.PAPAYA, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> MAHOGANY_SAPLING = TropicraftBlocks.register("mahogany_sapling", Builder.sapling(TropicraftTrees.RAINFOREST, new Supplier[0]));
    public static final RegistryObject<SaplingBlock> PALM_SAPLING = TropicraftBlocks.register("palm_sapling", Builder.sapling(TropicraftTrees.PALM, new Supplier[]{() -> Blocks.field_150354_m, CORAL_SAND, FOAMY_SAND, VOLCANIC_SAND, PURIFIED_SAND, MINERAL_SAND}));
    public static final RegistryObject<RotatedPillarBlock> PAPAYA_LOG = TropicraftBlocks.register("papaya_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B));
    public static final RegistryObject<RotatedPillarBlock> PAPAYA_WOOD = TropicraftBlocks.register("papaya_wood", Builder.wood(MaterialColor.field_151670_w));
    public static final RegistryObject<RotatedPillarBlock> RED_MANGROVE_LOG = TropicraftBlocks.register("red_mangrove_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> RED_MANGROVE_WOOD = TropicraftBlocks.register("red_mangrove_wood", Builder.wood(MaterialColor.field_151670_w, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> RED_MANGROVE_ROOTS = TropicraftBlocks.register("red_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<RotatedPillarBlock> LIGHT_MANGROVE_LOG = TropicraftBlocks.register("light_mangrove_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> LIGHT_MANGROVE_WOOD = TropicraftBlocks.register("light_mangrove_wood", Builder.wood(MaterialColor.field_151670_w, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> LIGHT_MANGROVE_ROOTS = TropicraftBlocks.register("light_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<RotatedPillarBlock> BLACK_MANGROVE_LOG = TropicraftBlocks.register("black_mangrove_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B, () -> STRIPPED_MANGROVE_LOG));
    public static final RegistryObject<RotatedPillarBlock> BLACK_MANGROVE_WOOD = TropicraftBlocks.register("black_mangrove_wood", Builder.wood(MaterialColor.field_151670_w, () -> STRIPPED_MANGROVE_WOOD));
    public static final RegistryObject<Block> BLACK_MANGROVE_ROOTS = TropicraftBlocks.register("black_mangrove_roots", Builder.mangroveRoots());
    public static final RegistryObject<LeavesBlock> RED_MANGROVE_LEAVES = TropicraftBlocks.register("red_mangrove_leaves", Builder.mangroveLeaves(() -> RED_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> TALL_MANGROVE_LEAVES = TropicraftBlocks.register("tall_mangrove_leaves", Builder.mangroveLeaves(() -> TALL_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> TEA_MANGROVE_LEAVES = TropicraftBlocks.register("tea_mangrove_leaves", Builder.mangroveLeaves(() -> TEA_MANGROVE_PROPAGULE));
    public static final RegistryObject<LeavesBlock> BLACK_MANGROVE_LEAVES = TropicraftBlocks.register("black_mangrove_leaves", Builder.mangroveLeaves(() -> BLACK_MANGROVE_PROPAGULE));
    public static final RegistryObject<PropaguleBlock> RED_MANGROVE_PROPAGULE = TropicraftBlocks.register("red_mangrove_propagule", Builder.propagule(TropicraftTrees.RED_MANGROVE));
    public static final RegistryObject<PropaguleBlock> TALL_MANGROVE_PROPAGULE = TropicraftBlocks.register("tall_mangrove_propagule", Builder.propagule(TropicraftTrees.TALL_MANGROVE));
    public static final RegistryObject<PropaguleBlock> TEA_MANGROVE_PROPAGULE = TropicraftBlocks.register("tea_mangrove_propagule", Builder.propagule(TropicraftTrees.TEA_MANGROVE));
    public static final RegistryObject<PropaguleBlock> BLACK_MANGROVE_PROPAGULE = TropicraftBlocks.register("black_mangrove_propagule", Builder.propagule(TropicraftTrees.BLACK_MANGROVE));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_MANGROVE_LOG = TropicraftBlocks.register("stripped_mangrove_log", Builder.log(MaterialColor.field_151670_w, MaterialColor.field_151650_B));
    public static final RegistryObject<RotatedPillarBlock> STRIPPED_MANGROVE_WOOD = TropicraftBlocks.register("stripped_mangrove_wood", Builder.wood(MaterialColor.field_151670_w));
    public static final RegistryObject<Block> MANGROVE_PLANKS = TropicraftBlocks.register("mangrove_planks", Builder.plank(MaterialColor.field_151663_o));
    public static final RegistryObject<StairsBlock> MANGROVE_STAIRS = TropicraftBlocks.register("mangrove_stairs", Builder.stairs(MANGROVE_PLANKS));
    public static final RegistryObject<SlabBlock> MANGROVE_SLAB = TropicraftBlocks.register("mangrove_slab", Builder.slab(MANGROVE_PLANKS));
    public static final RegistryObject<FenceBlock> MANGROVE_FENCE = TropicraftBlocks.register("mangrove_fence", Builder.fence(MANGROVE_PLANKS));
    public static final RegistryObject<FenceGateBlock> MANGROVE_FENCE_GATE = TropicraftBlocks.register("mangrove_fence_gate", Builder.fenceGate(MANGROVE_PLANKS));
    public static final RegistryObject<DoorBlock> MANGROVE_DOOR = TropicraftBlocks.register("mangrove_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao)){});
    public static final RegistryObject<TrapDoorBlock> MANGROVE_TRAPDOOR = TropicraftBlocks.register("mangrove_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)MANGROVE_DOOR.get()))){});
    public static final RegistryObject<ReedsBlock> REEDS = TropicraftBlocks.register("reeds", () -> new ReedsBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196608_cF)));
    public static final RegistryObject<PapayaBlock> PAPAYA = TropicraftBlocks.registerWithFood("papaya", () -> new PapayaBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_200948_a(0.2f, 3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_()), Foods.PAPAYA);
    public static final RegistryObject<FenceBlock> BAMBOO_FENCE = TropicraftBlocks.register("bamboo_fence", Builder.fence(BAMBOO_BUNDLE));
    public static final RegistryObject<FenceBlock> THATCH_FENCE = TropicraftBlocks.register("thatch_fence", Builder.fence(THATCH_BUNDLE));
    public static final RegistryObject<FenceBlock> CHUNK_FENCE = TropicraftBlocks.register("chunk_fence", Builder.fence(CHUNK));
    public static final RegistryObject<FenceBlock> PALM_FENCE = TropicraftBlocks.register("palm_fence", Builder.fence(PALM_PLANKS));
    public static final RegistryObject<FenceBlock> MAHOGANY_FENCE = TropicraftBlocks.register("mahogany_fence", Builder.fence(MAHOGANY_PLANKS));
    public static final RegistryObject<FenceGateBlock> BAMBOO_FENCE_GATE = TropicraftBlocks.register("bamboo_fence_gate", Builder.fenceGate(BAMBOO_BUNDLE));
    public static final RegistryObject<FenceGateBlock> THATCH_FENCE_GATE = TropicraftBlocks.register("thatch_fence_gate", Builder.fenceGate(THATCH_BUNDLE));
    public static final RegistryObject<FenceGateBlock> CHUNK_FENCE_GATE = TropicraftBlocks.register("chunk_fence_gate", Builder.fenceGate(CHUNK));
    public static final RegistryObject<FenceGateBlock> PALM_FENCE_GATE = TropicraftBlocks.register("palm_fence_gate", Builder.fenceGate(PALM_PLANKS));
    public static final RegistryObject<FenceGateBlock> MAHOGANY_FENCE_GATE = TropicraftBlocks.register("mahogany_fence_gate", Builder.fenceGate(MAHOGANY_PLANKS));
    public static final RegistryObject<WallBlock> CHUNK_WALL = TropicraftBlocks.register("chunk_wall", Builder.wall(CHUNK));
    public static final RegistryObject<DoorBlock> BAMBOO_DOOR = TropicraftBlocks.register("bamboo_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)BAMBOO_BUNDLE.get())).func_200943_b(1.0f)){});
    public static final RegistryObject<DoorBlock> PALM_DOOR = TropicraftBlocks.register("palm_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao)){});
    public static final RegistryObject<DoorBlock> MAHOGANY_DOOR = TropicraftBlocks.register("mahogany_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_180413_ao)){});
    public static final RegistryObject<DoorBlock> THATCH_DOOR = TropicraftBlocks.register("thatch_door", () -> new DoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)THATCH_BUNDLE.get()))){});
    public static final RegistryObject<TrapDoorBlock> BAMBOO_TRAPDOOR = TropicraftBlocks.register("bamboo_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)BAMBOO_DOOR.get())).func_226896_b_()){});
    public static final RegistryObject<TrapDoorBlock> PALM_TRAPDOOR = TropicraftBlocks.register("palm_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)PALM_DOOR.get()))){});
    public static final RegistryObject<TrapDoorBlock> MAHOGANY_TRAPDOOR = TropicraftBlocks.register("mahogany_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)MAHOGANY_DOOR.get()))){});
    public static final RegistryObject<TrapDoorBlock> THATCH_TRAPDOOR = TropicraftBlocks.register("thatch_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)THATCH_BUNDLE.get()))){});
    public static final RegistryObject<TallFlowerBlock> IRIS = TropicraftBlocks.register("iris", () -> new TallFlowerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)));
    public static final RegistryObject<PineappleBlock> PINEAPPLE = TropicraftBlocks.register("pineapple", () -> new PineappleBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200944_c().func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)));
    public static final RegistryObject<BongoDrumBlock> SMALL_BONGO_DRUM = TropicraftBlocks.register("small_bongo_drum", Builder.bongo(BongoDrumBlock.Size.SMALL));
    public static final RegistryObject<BongoDrumBlock> MEDIUM_BONGO_DRUM = TropicraftBlocks.register("medium_bongo_drum", Builder.bongo(BongoDrumBlock.Size.MEDIUM));
    public static final RegistryObject<BongoDrumBlock> LARGE_BONGO_DRUM = TropicraftBlocks.register("large_bongo_drum", Builder.bongo(BongoDrumBlock.Size.LARGE));
    public static final RegistryObject<LadderBlock> BAMBOO_LADDER = TropicraftBlocks.register("bamboo_ladder", () -> new LadderBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_222405_kQ)){});
    public static final RegistryObject<Block> BAMBOO_BOARDWALK = TropicraftBlocks.register("bamboo_boardwalk", () -> new BoardwalkBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)BAMBOO_SLAB.get())).func_226896_b_()));
    public static final RegistryObject<Block> PALM_BOARDWALK = TropicraftBlocks.register("palm_boardwalk", () -> new BoardwalkBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)PALM_SLAB.get())).func_226896_b_()));
    public static final RegistryObject<Block> MAHOGANY_BOARDWALK = TropicraftBlocks.register("mahogany_boardwalk", () -> new BoardwalkBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)MAHOGANY_SLAB.get())).func_226896_b_()));
    public static final RegistryObject<Block> MANGROVE_BOARDWALK = TropicraftBlocks.register("mangrove_boardwalk", () -> new BoardwalkBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)MANGROVE_SLAB.get())).func_226896_b_()));
    public static final RegistryObject<BambooChestBlock> BAMBOO_CHEST = TropicraftBlocks.register("bamboo_chest", () -> new BambooChestBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)BAMBOO_BUNDLE.get())).func_200943_b(1.0f), () -> (TileEntityType)TropicraftTileEntityTypes.BAMBOO_CHEST.get()), () -> TropicraftBlocks.chestRenderer());
    public static final RegistryObject<SifterBlock> SIFTER = TropicraftBlocks.register("sifter", () -> new SifterBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196662_n).func_226896_b_()));
    public static final RegistryObject<DrinkMixerBlock> DRINK_MIXER = TropicraftBlocks.register("drink_mixer", () -> new DrinkMixerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 30.0f).func_226896_b_()), () -> TropicraftBlocks.drinkMixerRenderer());
    public static final RegistryObject<AirCompressorBlock> AIR_COMPRESSOR = TropicraftBlocks.register("air_compressor", () -> new AirCompressorBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 30.0f).func_226896_b_()), () -> TropicraftBlocks.airCompressorRenderer());
    public static final RegistryObject<VolcanoBlock> VOLCANO = TropicraftBlocks.registerNoItem("volcano", () -> new VolcanoBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150357_h).func_222380_e()));
    public static final RegistryObject<TikiTorchBlock> TIKI_TORCH = TropicraftBlocks.register("tiki_torch", () -> new TikiTorchBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150478_aa).func_200947_a(SoundType.field_185848_a).func_235838_a_(state -> state.func_177229_b(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? 15 : 0)));
    public static final RegistryObject<FlowerPotBlock> BAMBOO_FLOWER_POT = TropicraftBlocks.register("bamboo_flower_pot", Builder.tropicraftPot());
    public static final RegistryObject<CoffeeBushBlock> COFFEE_BUSH = TropicraftBlocks.registerNoItem("coffee_bush", () -> new CoffeeBushBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151661_c).func_200943_b(0.15f).func_200947_a(SoundType.field_185850_c).func_226896_b_()));
    public static final RegistryObject<BushBlock> GOLDEN_LEATHER_FERN = TropicraftBlocks.register("small_golden_leather_fern", () -> new GrowableSinglePlantBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196554_aH), () -> TALL_GOLDEN_LEATHER_FERN));
    public static final RegistryObject<DoublePlantBlock> TALL_GOLDEN_LEATHER_FERN = TropicraftBlocks.registerNoItem("tall_golden_leather_fern", () -> new GrowableDoublePlantBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196805_gi), () -> LARGE_GOLDEN_LEATHER_FERN).setPickItem(() -> GOLDEN_LEATHER_FERN));
    public static final RegistryObject<HugePlantBlock> LARGE_GOLDEN_LEATHER_FERN = TropicraftBlocks.registerNoItem("golden_leather_fern", () -> new HugePlantBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c)).setPickItem(() -> GOLDEN_LEATHER_FERN));
    private static final Set<RegistryObject<? extends Block>> POTTABLE_PLANTS = ImmutableSet.builder().add((Object[])new RegistryObject[]{PALM_SAPLING, MAHOGANY_SAPLING, GRAPEFRUIT_SAPLING, LEMON_SAPLING, LIME_SAPLING, ORANGE_SAPLING}).add(IRIS).addAll(FLOWERS.values()).build();
    public static final List<RegistryObject<FlowerPotBlock>> BAMBOO_POTTED_TROPICS_PLANTS = ImmutableList.copyOf((Collection)POTTABLE_PLANTS.stream().map(b -> TropicraftBlocks.registerNoItem("bamboo_potted_" + b.getId().func_110623_a(), Builder.tropicraftPot((Supplier<? extends Block>)b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> VANILLA_POTTED_TROPICS_PLANTS = ImmutableList.copyOf((Collection)POTTABLE_PLANTS.stream().map(b -> TropicraftBlocks.registerNoItem("potted_" + b.getId().func_110623_a(), Builder.vanillaPot((Supplier<? extends Block>)b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> BAMBOO_POTTED_VANILLA_PLANTS = ImmutableList.copyOf((Collection)Stream.of(Blocks.field_196674_t, Blocks.field_196675_u, Blocks.field_196676_v, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y, Blocks.field_196554_aH, Blocks.field_196605_bc, Blocks.field_196606_bd, Blocks.field_196607_be, Blocks.field_196609_bf, Blocks.field_196610_bg, Blocks.field_196612_bh, Blocks.field_196613_bi, Blocks.field_196614_bj, Blocks.field_196615_bk, Blocks.field_196616_bl, Blocks.field_222387_by, Blocks.field_222383_bA, Blocks.field_222388_bz, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_196555_aI, Blocks.field_150434_aF).map(b -> TropicraftBlocks.registerNoItem("bamboo_potted_" + b.getRegistryName().func_110623_a(), Builder.tropicraftPot(() -> b))).collect(Collectors.toList()));
    public static final List<RegistryObject<FlowerPotBlock>> ALL_POTTED_PLANTS = ImmutableList.builder().addAll(BAMBOO_POTTED_TROPICS_PLANTS).addAll(VANILLA_POTTED_TROPICS_PLANTS).addAll(BAMBOO_POTTED_VANILLA_PLANTS).build();
    public static final Map<JigarbovTorchType, RegistryObject<RedstoneWallTorchBlock>> JIGARBOV_WALL_TORCHES = Arrays.stream(JigarbovTorchType.values()).collect(Collectors.toMap(Function.identity(), type -> TropicraftBlocks.registerNoItem("jigarbov_" + type.getName() + "_wall_torch", () -> new RedstoneWallTorchBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196677_cy).lootFrom(() -> Blocks.field_150429_aA)){

        public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
            return new ItemStack((IItemProvider)Items.field_221764_cr);
        }
    })));

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup) {
        return TropicraftBlocks.register(name, sup, TropicraftBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> registerWithFood(String name, Supplier<? extends T> sup, Food foo) {
        return TropicraftBlocks.register(name, sup, TropicraftBlocks::itemDefault);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Supplier<Callable<ItemStackTileEntityRenderer>> renderMethod) {
        return TropicraftBlocks.register(name, sup, (RegistryObject<T> block) -> TropicraftBlocks.item((RegistryObject<? extends Block>)block, renderMethod));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, ItemGroup tab) {
        return TropicraftBlocks.register(name, sup, (RegistryObject<T> block) -> TropicraftBlocks.item((RegistryObject<? extends Block>)block, tab));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = TropicraftBlocks.registerNoItem(name, sup);
        BLOCKITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> itemDefault(RegistryObject<? extends Block> block) {
        return TropicraftBlocks.item(block, Tropicraft.TROPICRAFT_ITEM_GROUP);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Food food) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(Tropicraft.TROPICRAFT_ITEM_GROUP).func_221540_a(food));
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Supplier<Callable<ItemStackTileEntityRenderer>> renderMethod) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(Tropicraft.TROPICRAFT_ITEM_GROUP).setISTER(renderMethod));
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, ItemGroup itemGroup) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(itemGroup));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestRenderer() {
        return () -> new SimpleItemStackRenderer<BambooChestTileEntity>(BambooChestTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> drinkMixerRenderer() {
        return () -> new SimpleItemStackRenderer<DrinkMixerTileEntity>(DrinkMixerTileEntity::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> airCompressorRenderer() {
        return () -> new SimpleItemStackRenderer<AirCompressorTileEntity>(AirCompressorTileEntity::new);
    }
}

