/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TikiTorchBlock
extends Block {
    public static final EnumProperty<TorchSection> SECTION = EnumProperty.func_177709_a((String)"section", TorchSection.class);
    protected static final VoxelShape BASE_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.999999, 0.6));
    protected static final VoxelShape TOP_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.6, 0.6));

    public TikiTorchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)TorchSection.UPPER)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SECTION});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        if (section == TorchSection.UPPER) {
            return TOP_SHAPE;
        }
        return BASE_SHAPE;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (TikiTorchBlock.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP)) {
            return true;
        }
        BlockState blockstate = world.func_180495_p(pos.func_177977_b());
        return blockstate.func_177230_c() == this && blockstate.func_177229_b(SECTION) != TorchSection.UPPER && super.func_196260_a(state, world, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (this.placeShortTorchOn(context.func_195991_k().func_180495_p(blockpos.func_177977_b()))) {
            return (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)TorchSection.UPPER));
        }
        BlockState ret = (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)TorchSection.LOWER));
        return blockpos.func_177956_o() < context.func_195991_k().func_234938_ad_() - 1 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) && context.func_195991_k().func_180495_p(blockpos.func_177981_b(2)).func_196953_a(context) ? ret : null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k() == Direction.Axis.Y && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        if (section == TorchSection.UPPER) {
            return;
        }
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)TorchSection.MIDDLE)), 3);
        worldIn.func_180501_a(pos.func_177981_b(2), (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)((Object)TorchSection.UPPER)), 3);
    }

    private boolean placeShortTorchOn(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G) || state.func_177230_c().func_203417_a((ITag)BlockTags.field_219757_z);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        BlockPos base = pos.func_177979_c(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.func_177981_b(otherSection.height);
            BlockState state2 = world.func_180495_p(pos2);
            if (state2.func_177230_c() != this || state2.func_177229_b(SECTION) != otherSection) continue;
            super.func_180657_a(world, player, pos2, state2, te, stack);
            world.func_180501_a(pos2, world.func_204610_c(pos2).func_206883_i(), world.field_72995_K ? 11 : 3);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        boolean ret = false;
        TorchSection section = (TorchSection)((Object)state.func_177229_b(SECTION));
        BlockPos base = pos.func_177979_c(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.func_177981_b(otherSection.height);
            BlockState state2 = world.func_180495_p(pos2);
            if (state2.func_177230_c() != this || state2.func_177229_b(SECTION) != otherSection) continue;
            if (player.func_184812_l_()) {
                ret |= super.removedByPlayer(state2, world, pos2, player, willHarvest, fluid);
                continue;
            }
            this.func_176208_a(world, pos2, state2, player);
            ret = true;
        }
        return ret;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        boolean isTop;
        boolean bl = isTop = state.func_177229_b(SECTION) == TorchSection.UPPER;
        if (isTop) {
            double d = (float)pos.func_177958_n() + 0.5f;
            double d1 = (float)pos.func_177956_o() + 0.7f;
            double d2 = (float)pos.func_177952_p() + 0.5f;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d, d1, d2, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static enum TorchSection implements IStringSerializable
    {
        UPPER(2),
        MIDDLE(1),
        LOWER(0);

        final int height;

        private TorchSection(int height) {
            this.height = height;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

