/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.trees.Tree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.WaterloggableSaplingBlock;

public final class PropaguleBlock
extends WaterloggableSaplingBlock {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final int GROW_CHANCE = 7;
    public static final BooleanProperty PLANTED = BooleanProperty.func_177716_a((String)"planted");

    public PropaguleBlock(Tree tree, AbstractBlock.Properties properties) {
        super(tree, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176479_b, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PLANTED, (Comparable)Boolean.valueOf(true)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_149739_a() + ".desc").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)PLANTED)).booleanValue()) {
            BlockPos groundPos = pos.func_177977_b();
            return this.func_200014_a_(world.func_180495_p(groundPos), (IBlockReader)world, groundPos);
        }
        BlockPos topPos = pos.func_177984_a();
        return world.func_180495_p(topPos).func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return super.func_200014_a_(state, world, pos) || state.func_235714_a_((ITag)BlockTags.field_203436_u) || state.func_235714_a_(TropicraftTags.Blocks.MUD);
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)PLANTED);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            this.func_226942_a_(world, pos, state, random);
        }
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((Property)PLANTED);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)PLANTED, (Comparable)Boolean.valueOf(context.func_196000_l() != Direction.DOWN));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PLANTED});
    }
}

