/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class PineappleBlock
extends TallFlowerBlock
implements IGrowable,
IPlantable {
    public static final int TOTAL_GROW_TICKS = 7;
    public static final IntegerProperty STAGE = BlockStateProperties.field_208170_W;

    public PineappleBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176492_b, STAGE});
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState blockState, boolean b) {
        return blockState.func_177230_c() == TropicraftBlocks.PINEAPPLE.get() && blockState.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER && world.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        int currentStage = (Integer)state.func_177229_b((Property)STAGE);
        if (currentStage < 7) {
            BlockState growthState = (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(currentStage + 1));
            world.func_180501_a(pos, growthState, 4);
        } else {
            BlockState above = world.func_180495_p(pos.func_177984_a());
            if (above.func_177230_c() == this) {
                return;
            }
            if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.UPPER) {
                return;
            }
            BlockState fullGrowth = (BlockState)state.func_206870_a((Property)field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
            world.func_180501_a(pos.func_177984_a(), fullGrowth, 3);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (pos.func_177956_o() > world.func_217301_I() - 2) {
            return;
        }
        int growth = (Integer)state.func_177229_b((Property)STAGE);
        if (state.func_177230_c() == this && growth <= 7 && world.func_175623_d(pos.func_177984_a()) && state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER) {
            if (growth >= 6) {
                BlockState growthState = (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(7));
                world.func_180501_a(pos, growthState, 7);
                BlockState fullGrowth = (BlockState)growthState.func_206870_a((Property)field_176492_b, (Comparable)DoubleBlockHalf.UPPER);
                world.func_180501_a(pos.func_177984_a(), fullGrowth, 3);
            } else {
                BlockState growthState = (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(growth + 1));
                world.func_180501_a(pos, growthState, 7);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER) {
            super.func_176208_a(worldIn, pos, state, player);
        } else {
            worldIn.func_217378_a(player, 2001, pos, PineappleBlock.func_196246_j((BlockState)state));
            PineappleBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.UPPER) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == TropicraftBlocks.PINEAPPLE.get();
        }
        return this.canPlaceBlockAt(worldIn, pos);
    }

    private boolean canPlaceBlockAt(IWorldReader worldIn, BlockPos pos) {
        BlockState belowState = worldIn.func_180495_p(pos.func_177977_b());
        return belowState.func_177230_c().canSustainPlant(belowState, (IBlockReader)worldIn, pos.func_177977_b(), Direction.UP, (IPlantable)this);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }
}

