/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.block.PropaguleBlock;

public class MangroveLeavesBlock
extends LeavesBlock {
    private static final int PROPAGULE_GROW_CHANCE = 200;
    private static final int SPACING = 2;
    private final Supplier<PropaguleBlock> propaguleBlock;

    public MangroveLeavesBlock(AbstractBlock.Properties props, Supplier<PropaguleBlock> propaguleBlock) {
        super(props);
        this.propaguleBlock = propaguleBlock;
    }

    public boolean func_149653_t(BlockState state) {
        return this.canGrowPropagules(state) || super.func_149653_t(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225542_b_(state, world, pos, random);
        if (this.canGrowPropagules(state) && random.nextInt(200) == 0) {
            this.tryGrowPropagule(world, pos);
        }
    }

    private void tryGrowPropagule(ServerWorld world, BlockPos pos) {
        BlockPos growPos = pos.func_177977_b();
        if (world.func_175623_d(growPos) && world.func_175623_d(growPos.func_177977_b()) && !this.hasNearPropagule(world, pos)) {
            BlockState propagule = (BlockState)this.propaguleBlock.get().func_176223_P().func_206870_a((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false));
            world.func_175656_a(growPos, propagule);
        }
    }

    private boolean canGrowPropagules(BlockState state) {
        return (Integer)state.func_177229_b((Property)field_208494_a) <= 3;
    }

    private boolean hasNearPropagule(ServerWorld world, BlockPos source) {
        PropaguleBlock propagule = this.propaguleBlock.get();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)source.func_177982_a(-2, -2, -2), (BlockPos)source.func_177982_a(2, 0, 2))) {
            if (!world.func_180495_p(pos).func_203425_a((Block)propagule)) continue;
            return true;
        }
        return false;
    }
}

