/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;

public final class GrowableDoublePlantBlock
extends DoublePlantBlock
implements IGrowable {
    private final Supplier<RegistryObject<HugePlantBlock>> growInto;
    private Supplier<RegistryObject<? extends IItemProvider>> pickItem;

    public GrowableDoublePlantBlock(AbstractBlock.Properties properties, Supplier<RegistryObject<HugePlantBlock>> growInto) {
        super(properties);
        this.growInto = growInto;
    }

    public GrowableDoublePlantBlock setPickItem(Supplier<RegistryObject<? extends IItemProvider>> item) {
        this.pickItem = item;
        return this;
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        BlockPos lowerPos = state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        HugePlantBlock growBlock = (HugePlantBlock)this.growInto.get().get();
        BlockState growState = growBlock.func_176223_P();
        if (growState.func_196955_c((IWorldReader)world, lowerPos)) {
            growBlock.placeAt((IWorld)world, lowerPos, 2);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b((Property)field_176492_b) == DoubleBlockHalf.LOWER) {
            return super.func_220076_a(state, builder);
        }
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.pickItem != null) {
            return new ItemStack((IItemProvider)this.pickItem.get().get());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

