/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.trees.Tree;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.MangroveLeavesBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.MudBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;
import net.tropicraft.core.common.block.TropicraftLogBlock;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.WaterloggableSaplingBlock;

public class Builder {
    public static Supplier<Block> block(AbstractBlock.Properties properties) {
        return Builder.block(() -> properties);
    }

    public static Supplier<Block> block(Supplier<AbstractBlock.Properties> properties) {
        return Builder.block(Block::new, properties);
    }

    public static <T extends Block> Supplier<T> block(Function<AbstractBlock.Properties, T> ctor, AbstractBlock.Properties properties) {
        return Builder.block(ctor, () -> properties);
    }

    public static <T extends Block> Supplier<T> block(Function<AbstractBlock.Properties, T> ctor, Supplier<AbstractBlock.Properties> properties) {
        return () -> (Block)ctor.apply((AbstractBlock.Properties)properties.get());
    }

    public static Supplier<Block> ore(MaterialColor color) {
        return Builder.block(Builder.prop(Material.field_151576_e, color).func_200948_a(3.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2));
    }

    public static Supplier<Block> oreBlock(MaterialColor color) {
        return Builder.block(Builder.prop(Material.field_151573_f, color).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 6.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2));
    }

    public static Supplier<TropicsFlowerBlock> flower(TropicraftFlower type) {
        return Builder.block((AbstractBlock.Properties p) -> new TropicsFlowerBlock(type.getEffect(), type.getEffectDuration(), type.getShape(), (AbstractBlock.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196606_bd.delegate));
    }

    public static Supplier<BlockTropicraftSand> sand(MaterialColor color) {
        return Builder.sand(color, 0.5f, 0.5f);
    }

    public static Supplier<BlockTropicraftSand> sand(MaterialColor color, float hardness, float resistance) {
        return Builder.sand(BlockTropicraftSand::new, color, hardness, resistance);
    }

    public static Supplier<VolcanicSandBlock> volcanicSand(MaterialColor color) {
        return Builder.sand(VolcanicSandBlock::new, color, 0.5f, 0.5f);
    }

    public static <T extends BlockTropicraftSand> Supplier<T> sand(Function<AbstractBlock.Properties, T> ctor, MaterialColor color, float hardness, float resistance) {
        return Builder.block(ctor, Builder.prop(Material.field_151595_p, color).func_200947_a(SoundType.field_185855_h).harvestTool(ToolType.SHOVEL).func_200948_a(hardness, resistance));
    }

    public static Supplier<MudBlock> mud() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150346_d).func_226897_b_(0.5f).harvestTool(ToolType.SHOVEL).func_235827_a_((s, w, p, e) -> true).func_235828_a_((s, w, p) -> true).func_235847_c_((s, w, p) -> true).func_235842_b_((s, w, p) -> true);
        return Builder.block(MudBlock::new, properties);
    }

    public static Supplier<RotatedPillarBlock> bundle(AbstractBlock.Properties properties) {
        return Builder.block(RotatedPillarBlock::new, properties);
    }

    public static Supplier<Block> plank(MaterialColor color) {
        return Builder.block(Builder.prop(Material.field_151575_d, color).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public static Supplier<RotatedPillarBlock> log(MaterialColor topColor, MaterialColor sideColor) {
        return Builder.block(RotatedPillarBlock::new, Builder.logProperties(topColor, sideColor));
    }

    public static Supplier<RotatedPillarBlock> log(MaterialColor topColor, MaterialColor sideColor, Supplier<RegistryObject<RotatedPillarBlock>> stripped) {
        return Builder.block((AbstractBlock.Properties properties) -> new TropicraftLogBlock((AbstractBlock.Properties)properties, () -> Builder.lambda$null$8((Supplier)stripped)), Builder.logProperties(topColor, sideColor));
    }

    private static AbstractBlock.Properties logProperties(MaterialColor topColor, MaterialColor sideColor) {
        return Builder.prop(Material.field_151575_d, (BlockState state) -> state.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? topColor : sideColor).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
    }

    public static Supplier<RotatedPillarBlock> wood(MaterialColor color) {
        return Builder.block(RotatedPillarBlock::new, Builder.woodProperties(color));
    }

    public static Supplier<RotatedPillarBlock> wood(MaterialColor color, Supplier<RegistryObject<RotatedPillarBlock>> stripped) {
        return Builder.block((AbstractBlock.Properties properties) -> new TropicraftLogBlock((AbstractBlock.Properties)properties, () -> Builder.lambda$null$11((Supplier)stripped)), Builder.woodProperties(color));
    }

    private static AbstractBlock.Properties woodProperties(MaterialColor color) {
        return Builder.prop(Material.field_151575_d, color).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
    }

    public static Supplier<StairsBlock> stairs(RegistryObject<? extends Block> source) {
        return Builder.block((AbstractBlock.Properties p) -> new StairsBlock(source.lazyMap(Block::func_176223_P), p), Builder.lazyProp(source));
    }

    public static Supplier<SlabBlock> slab(Supplier<? extends Block> source) {
        return Builder.block(SlabBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<LeavesBlock> leaves(boolean decay) {
        return Builder.block(decay ? LeavesBlock::new : TropicraftLeavesBlock::new, Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196642_W.delegate));
    }

    public static Supplier<LeavesBlock> mangroveLeaves(Supplier<RegistryObject<PropaguleBlock>> propagule) {
        return Builder.block((AbstractBlock.Properties properties) -> new MangroveLeavesBlock(properties.func_200944_c(), () -> Builder.lambda$null$14((Supplier)propagule)), Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196642_W.delegate));
    }

    public static Supplier<Block> mangroveRoots() {
        return () -> new MangroveRootsBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.0f).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235828_a_((state, world, pos) -> false).func_235852_d_((state, world, pos) -> true));
    }

    @SafeVarargs
    public static Supplier<SaplingBlock> sapling(Tree tree, final Supplier<? extends Block> ... validPlantBlocks) {
        return Builder.block((AbstractBlock.Properties p) -> new SaplingBlock(tree, (AbstractBlock.Properties)p){

            protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
                Block block = state.func_177230_c();
                if (validPlantBlocks == null || validPlantBlocks.length == 0) {
                    return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150458_ak;
                }
                return Arrays.stream(validPlantBlocks).map(Supplier::get).anyMatch(b -> b == block);
            }
        }, Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196674_t.delegate));
    }

    public static Supplier<SaplingBlock> waterloggableSapling(Tree tree) {
        return Builder.block((AbstractBlock.Properties p) -> new WaterloggableSaplingBlock(tree, (AbstractBlock.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196674_t.delegate));
    }

    public static Supplier<PropaguleBlock> propagule(Tree tree) {
        return Builder.block((AbstractBlock.Properties p) -> new PropaguleBlock(tree, (AbstractBlock.Properties)p), Builder.lazyProp((Supplier<? extends Block>)Blocks.field_196674_t.delegate));
    }

    public static Supplier<FenceBlock> fence(Supplier<? extends Block> source) {
        return Builder.block(FenceBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<FenceGateBlock> fenceGate(Supplier<? extends Block> source) {
        return Builder.block(FenceGateBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<WallBlock> wall(Supplier<? extends Block> source) {
        return Builder.block(WallBlock::new, Builder.lazyProp(source));
    }

    public static Supplier<BongoDrumBlock> bongo(BongoDrumBlock.Size bongoSize) {
        return Builder.block((AbstractBlock.Properties p) -> new BongoDrumBlock(bongoSize, (AbstractBlock.Properties)p), Builder.woodProperties(MaterialColor.field_193561_M));
    }

    public static Supplier<FlowerPotBlock> pot(Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> flower, Supplier<AbstractBlock.Properties> properties) {
        return Builder.block((AbstractBlock.Properties p) -> new FlowerPotBlock(emptyPot, flower, p), properties);
    }

    public static Supplier<FlowerPotBlock> tropicraftPot() {
        return Builder.pot(null, (Supplier<? extends Block>)Blocks.field_150350_a.delegate, Builder.lazyProp(Material.field_151594_q).then(p -> p.func_200948_a(0.2f, 5.0f).func_200947_a(SoundType.field_222468_o)));
    }

    public static Supplier<FlowerPotBlock> tropicraftPot(Supplier<? extends Block> block) {
        return Builder.pot(TropicraftBlocks.BAMBOO_FLOWER_POT, block, Builder.lazyProp(Material.field_151594_q).then(p -> p.func_200948_a(0.2f, 5.0f).func_200947_a(SoundType.field_222468_o)));
    }

    public static Supplier<FlowerPotBlock> vanillaPot(Supplier<? extends Block> block) {
        return Builder.pot(() -> (FlowerPotBlock)Blocks.field_150457_bL.delegate.get(), block, Builder.lazyProp((Supplier<? extends Block>)Blocks.field_150457_bL.delegate));
    }

    private static AbstractBlock.Properties prop(Material material) {
        return AbstractBlock.Properties.func_200945_a((Material)material);
    }

    private static AbstractBlock.Properties prop(Material material, MaterialColor color) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color);
    }

    private static AbstractBlock.Properties prop(Material material, Function<BlockState, MaterialColor> color) {
        return AbstractBlock.Properties.func_235836_a_((Material)material, color);
    }

    private static ComposableSupplier<AbstractBlock.Properties> lazyProp(Material material) {
        return () -> Builder.prop(material);
    }

    private static ComposableSupplier<AbstractBlock.Properties> lazyProp(Material material, MaterialColor color) {
        return () -> Builder.prop(material, color);
    }

    private static ComposableSupplier<AbstractBlock.Properties> lazyProp(Supplier<? extends Block> source) {
        return () -> {
            Objects.requireNonNull(source.get(), "Must register source block before using it");
            return AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)source.get()));
        };
    }

    private static /* synthetic */ PropaguleBlock lambda$null$14(Supplier propagule) {
        return (PropaguleBlock)((RegistryObject)propagule.get()).get();
    }

    private static /* synthetic */ RotatedPillarBlock lambda$null$11(Supplier stripped) {
        return (RotatedPillarBlock)((RegistryObject)stripped.get()).get();
    }

    private static /* synthetic */ RotatedPillarBlock lambda$null$8(Supplier stripped) {
        return (RotatedPillarBlock)((RegistryObject)stripped.get()).get();
    }

    static interface ComposableSupplier<T>
    extends Supplier<T> {
        default public <R> ComposableSupplier<R> then(Function<T, R> func) {
            return () -> func.apply(this.get());
        }
    }
}

