/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class BoardwalkBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BoardwalkBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a(TYPE, (Comparable)((Object)Type.SHORT))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Type type = (Type)((Object)state.func_177229_b(TYPE));
        if (type.isTall()) {
            return type.hasPost() ? VoxelShapes.func_197868_b() : TOP_SHAPE;
        }
        return BOTTOM_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        boolean tall = context.func_221532_j().field_72448_b - (double)pos.func_177956_o() > 0.5;
        BlockState state = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_195992_f().func_176740_k())).func_206870_a(TYPE, (Comparable)((Object)(tall ? Type.TALL : Type.SHORT)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
        state = this.applyConnections(state, (IWorld)world, pos);
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing != Direction.UP) {
            return this.applyConnections(state, world, currentPos);
        }
        return state;
    }

    private BlockState applyConnections(BlockState state, IWorld world, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS);
        boolean tall = ((Type)((Object)state.func_177229_b(TYPE))).isTall();
        BlockPos downPos = pos.func_177977_b();
        boolean posted = BoardwalkBlock.func_220055_a((IWorldReader)world, (BlockPos)downPos, (Direction)Direction.UP);
        if (tall) {
            boolean front = this.connectsTo(world, pos, axis, Direction.AxisDirection.POSITIVE);
            boolean back = this.connectsTo(world, pos, axis, Direction.AxisDirection.NEGATIVE);
            if (front || back) {
                posted = true;
            }
            Type type = Type.tall(posted, front, back);
            return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)type));
        }
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)(posted ? Type.SHORT_POST : Type.SHORT)));
    }

    private boolean connectsTo(IWorld world, BlockPos pos, Direction.Axis axis, Direction.AxisDirection direction) {
        BlockPos connectPos = pos.func_177972_a(Direction.func_211699_a((Direction.Axis)axis, (Direction.AxisDirection)direction));
        BlockState connectState = world.func_180495_p(connectPos);
        return connectState.func_203425_a((Block)this) && ((Type)((Object)connectState.func_177229_b(TYPE))).isShort();
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS, TYPE, WATERLOGGED});
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public static enum Type implements IStringSerializable
    {
        TALL("tall"),
        TALL_POST("tall_post"),
        TALL_POST_FRONT("tall_post_front"),
        TALL_POST_BACK("tall_post_back"),
        TALL_POST_FRONT_BACK("tall_post_front_back"),
        SHORT("short"),
        SHORT_POST("short_post");

        public static final Type[] TALLS;
        public static final Type[] SHORTS;
        public static final Type[] TALL_POSTS;
        public static final Type[] SHORT_POSTS;
        public static final Type[] FRONTS;
        public static final Type[] BACKS;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type tall(boolean posted, boolean front, boolean back) {
            if (posted) {
                if (front && back) {
                    return TALL_POST_FRONT_BACK;
                }
                if (front) {
                    return TALL_POST_FRONT;
                }
                if (back) {
                    return TALL_POST_BACK;
                }
                return TALL_POST;
            }
            return TALL;
        }

        public boolean isShort() {
            return this == SHORT || this == SHORT_POST;
        }

        public boolean isTall() {
            return !this.isShort();
        }

        public boolean hasPost() {
            return this == TALL_POST || this == TALL_POST_FRONT || this == TALL_POST_BACK || this == TALL_POST_FRONT_BACK;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            TALLS = new Type[]{TALL, TALL_POST, TALL_POST_FRONT, TALL_POST_BACK, TALL_POST_FRONT_BACK};
            SHORTS = new Type[]{SHORT, SHORT_POST};
            TALL_POSTS = new Type[]{TALL_POST, TALL_POST_FRONT, TALL_POST_BACK, TALL_POST_FRONT_BACK};
            SHORT_POSTS = new Type[]{SHORT_POST};
            FRONTS = new Type[]{TALL_POST_FRONT, TALL_POST_FRONT_BACK};
            BACKS = new Type[]{TALL_POST_BACK, TALL_POST_FRONT_BACK};
        }
    }
}

