/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.block.tileentity.AirCompressorTileEntity;

public class AirCompressorBlock
extends Block {
    @Nonnull
    public static final EnumProperty<Direction> FACING = HorizontalBlock.field_185512_D;

    public AirCompressorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_149739_a() + ".desc").func_240699_a_(TextFormatting.GRAY));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184614_ca();
        AirCompressorTileEntity mixer = (AirCompressorTileEntity)world.func_175625_s(pos);
        if (mixer.isDoneCompressing()) {
            mixer.ejectTank();
            return ActionResultType.CONSUME;
        }
        if (stack.func_190926_b()) {
            mixer.ejectTank();
            return ActionResultType.CONSUME;
        }
        ItemStack ingredientStack = stack.func_77946_l();
        ingredientStack.func_190920_e(1);
        if (mixer.addTank(ingredientStack)) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.field_72995_K) {
            AirCompressorTileEntity te = (AirCompressorTileEntity)world.func_175625_s(pos);
            te.ejectTank();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AirCompressorTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState ret = super.func_196258_a(context);
        return (BlockState)ret.func_206870_a(FACING, (Comparable)context.func_195992_f());
    }
}

