/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static boolean tryMoveToEntityLivingLongDist(MobEntity entSource, Entity entityTo, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(entSource, entityTo.func_233580_cy_(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(MobEntity ent, BlockPos pos, double moveSpeedAmp) {
        return Util.tryMoveToXYZLongDist(ent, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(MobEntity ent, int x, int y, int z, double moveSpeedAmp) {
        World world = ent.field_70170_p;
        boolean success = false;
        if (ent.func_70661_as().func_75500_f()) {
            double followDist;
            double distToPlayer = Util.getDistance((Entity)ent, x, y, z);
            if (distToPlayer <= (followDist = ent.func_110148_a(Attributes.field_233819_b_).func_111126_e())) {
                success = ent.func_70661_as().func_75492_a((double)x, (double)y, (double)z, moveSpeedAmp);
            } else {
                int tries;
                int gatherZ;
                int gatherY;
                double d = (double)((float)x + 0.5f) - ent.func_226277_ct_();
                double d2 = (double)((float)z + 0.5f) - ent.func_226281_cx_();
                double d1 = (double)((float)y + 0.5f) - (ent.func_226278_cu_() + (double)ent.func_70047_e());
                double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                MobEntity center = ent;
                Random rand = world.field_73012_v;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.func_226277_ct_() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.func_226278_cu_(), gatherZ = (int)Math.floor(center.func_226281_cx_() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.func_175667_e(pos)) {
                    return false;
                }
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!world.func_175623_d(pos)) {
                    for (tries = 0; !(tries >= 30 || world.func_175623_d(pos) && world.func_175623_d(pos.func_177984_a())); ++tries) {
                        pos = new BlockPos(gatherX, ++gatherY, gatherZ);
                        state = world.func_180495_p(pos);
                        block = state.func_177230_c();
                    }
                } else {
                    while (tries < 30 && (world.func_175623_d(pos) || !state.func_185904_a().func_76220_a() && world.func_180495_p(pos).func_185904_a() != Material.field_151586_h)) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.func_180495_p(pos);
                        block = state.func_177230_c();
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = ent.func_70661_as().func_75492_a((double)gatherX, (double)gatherY, (double)gatherZ, moveSpeedAmp);
                }
            }
        }
        return success;
    }

    public static BlockPos findBlock(MobEntity entity, int scanRange, BiPredicate<World, BlockPos> predicate) {
        int scanSize = scanRange;
        int scanSizeY = scanRange / 2;
        int adjustRangeY = 10;
        int tryY = MathHelper.func_76128_c((double)entity.func_226278_cu_()) - 1;
        for (int ii = 0; ii <= 10; ++ii) {
            int tryMax;
            if (ii <= 3) {
                scanSize = 20;
                scanSizeY = 5;
            } else {
                scanSize = scanRange;
                scanSizeY = scanRange / 2;
            }
            int tryX = MathHelper.func_76128_c((double)entity.func_226277_ct_()) + (entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2);
            int i = tryY + entity.field_70170_p.field_73012_v.nextInt(scanSizeY) - scanSizeY / 2;
            int tryZ = MathHelper.func_76128_c((double)entity.func_226281_cx_()) + entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2;
            BlockPos posTry = new BlockPos(tryX, tryY, tryZ);
            boolean foundBlock = false;
            int newY = i;
            if (!entity.field_70170_p.func_175623_d(posTry)) {
                tryMax = adjustRangeY;
                while (!entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, ++newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry) && predicate.test(entity.field_70170_p, posTry.func_177982_a(0, -1, 0))) {
                    foundBlock = true;
                }
            } else {
                tryMax = adjustRangeY;
                while (entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, --newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry.func_177982_a(0, 1, 0)) && predicate.test(entity.field_70170_p, posTry)) {
                    foundBlock = true;
                }
            }
            if (!foundBlock) continue;
            return posTry;
        }
        return null;
    }

    public static boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }

    public static boolean isDeepWater(World world, BlockPos pos) {
        boolean clearAbove = world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3));
        boolean deep = world.func_180495_p(pos).func_185904_a() == Material.field_151586_h && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h;
        boolean notUnderground = false;
        if (deep) {
            int height = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos).func_177956_o() - 1;
            notUnderground = height == pos.func_177956_o();
        }
        return deep && notUnderground && clearAbove;
    }

    public static boolean isLand(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76220_a();
    }

    public static boolean isFire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151581_o;
    }

    public static double getDistance(Entity ent, double x, double y, double z) {
        double d0 = ent.func_226277_ct_() - x;
        double d1 = ent.func_226278_cu_() - y;
        double d2 = ent.func_226281_cx_() - z;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new UnableToFindFieldException(failed);
    }

    public static int randFlip(Random rand, int i) {
        return rand.nextBoolean() ? rand.nextInt(i) : -rand.nextInt(i);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static Direction.Axis getAxisBetween(BlockPos start, BlockPos end) {
        int zOffset;
        Direction.Axis axis = Direction.Axis.Y;
        int xOffset = Math.abs(end.func_177958_n() - start.func_177958_n());
        int maxOffset = Math.max(xOffset, zOffset = Math.abs(end.func_177952_p() - start.func_177952_p()));
        if (maxOffset > 0) {
            axis = xOffset == maxOffset ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    @Nullable
    public static BlockPos findLowestBlock(List<BlockPos> blocks) {
        if (blocks.isEmpty()) {
            return null;
        }
        BlockPos lowest = blocks.get(0);
        for (int i = 1; i < blocks.size(); ++i) {
            BlockPos block = blocks.get(i);
            if (lowest.func_177956_o() <= block.func_177956_o()) continue;
            lowest = block;
        }
        return lowest;
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private UnableToFindFieldException(Exception e) {
            super(e);
        }
    }
}

