/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.block.tileentity.BambooChestTileEntity;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BambooChestRenderer
extends ChestTileEntityRenderer<BambooChestTileEntity> {
    public static final RenderMaterial BAMBOO_CHEST_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal");
    public static final RenderMaterial BAMBOO_CHEST_LEFT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal_left");
    public static final RenderMaterial BAMBOO_CHEST_RIGHT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal_right");

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            event.addSprite(BAMBOO_CHEST_MATERIAL.func_229313_b_());
            event.addSprite(BAMBOO_CHEST_LEFT_MATERIAL.func_229313_b_());
            event.addSprite(BAMBOO_CHEST_RIGHT_MATERIAL.func_229313_b_());
        }
    }

    private static RenderMaterial getChestMaterial(ChestType chestType, RenderMaterial normalMaterial, RenderMaterial leftMaterial, RenderMaterial rightMaterial) {
        switch (chestType) {
            case LEFT: {
                return leftMaterial;
            }
            case RIGHT: {
                return rightMaterial;
            }
        }
        return normalMaterial;
    }

    private static RenderMaterial getChestMaterial(String chestName) {
        return new RenderMaterial(Atlases.field_228747_f_, new ResourceLocation("tropicraft", "block/te/" + chestName));
    }

    public BambooChestRenderer(TileEntityRendererDispatcher renderDispatcher) {
        super(renderDispatcher);
    }

    protected RenderMaterial getMaterial(BambooChestTileEntity tileEntity, ChestType chestType) {
        return BambooChestRenderer.getChestMaterial(chestType, BAMBOO_CHEST_MATERIAL, BAMBOO_CHEST_LEFT_MATERIAL, BAMBOO_CHEST_RIGHT_MATERIAL);
    }
}

