/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;
import org.apache.commons.lang3.time.DurationFormatUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaHUD {
    @SubscribeEvent
    public static void renderHUD(RenderGameOverlayEvent event) {
        PlayerEntity player;
        ItemStack chestStack;
        Item chestItem;
        Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && renderViewEntity instanceof PlayerEntity && (chestItem = (chestStack = (player = (PlayerEntity)renderViewEntity).func_184582_a(EquipmentSlotType.CHEST)).func_77973_b()) instanceof ScubaArmorItem) {
            LazyOptional data = player.getCapability(ScubaData.CAPABILITY);
            int airRemaining = ((ScubaArmorItem)chestItem).getRemainingAir(chestStack);
            TextFormatting airColor = ScubaHUD.getAirTimeColor(airRemaining, player.field_70170_p);
            double depth = ScubaData.getDepth(player);
            String depthStr = depth > 0.0 ? String.format("%.1fm", depth) : TropicraftLangKeys.NA.getLocalizedText();
            data.ifPresent(d -> ScubaHUD.drawHUDStrings(event.getMatrixStack(), new ITextComponent[]{TropicraftLangKeys.SCUBA_AIR_TIME.format(airColor + ScubaHUD.formatTime(airRemaining)), TropicraftLangKeys.SCUBA_DIVE_TIME.format(ScubaHUD.formatTime(d.getDiveTime())), TropicraftLangKeys.SCUBA_DEPTH.format(depthStr), TropicraftLangKeys.SCUBA_MAX_DEPTH.format(String.format("%.1fm", d.getMaxDepth()))}));
        }
    }

    public static String formatTime(long time) {
        return DurationFormatUtils.formatDuration((long)(time * 50L), (String)"HH:mm:ss");
    }

    public static TextFormatting getAirTimeColor(int airRemaining, @Nullable World world) {
        if (airRemaining < 1200) {
            int speed = airRemaining < 200 ? 5 : 10;
            return world != null && world.func_82737_E() / (long)speed % 4L == 0L ? TextFormatting.WHITE : TextFormatting.RED;
        }
        if (airRemaining < 6000) {
            return TextFormatting.GOLD;
        }
        return TextFormatting.GREEN;
    }

    private static void drawHUDStrings(MatrixStack matrixStack, ITextComponent ... components) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        int n = mw.func_198087_p() - 5;
        fr.getClass();
        int startY = n - 9 * components.length;
        int startX = mw.func_198107_o() - 5;
        for (ITextComponent text : components) {
            String s = text.getString();
            fr.func_238405_a_(matrixStack, s, (float)(startX - fr.func_78256_a(s)), (float)startY, -1);
            fr.getClass();
            startY += 9;
        }
    }
}

