/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaAmbienceTicker {
    public static final SoundEvent SHALLOW_SCUBA = new SoundEvent(new ResourceLocation("tropicraft", "scuba.shallow"));
    public static final SoundEvent DEEP_SCUBA = new SoundEvent(new ResourceLocation("tropicraft", "scuba.deep"));
    private static SoundEvent currentSound;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            ActiveRenderInfo renderInfo = mc.func_175598_ae().field_217783_c;
            Entity renderViewEntity = mc.func_175606_aa();
            if (renderInfo != null && renderViewEntity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)renderViewEntity;
                if (renderInfo.func_216771_k().func_206884_a((ITag)FluidTags.field_206959_a) && player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ScubaArmorItem) {
                    if (ScubaData.getDepth(player) < 60.0) {
                        ScubaAmbienceTicker.play(SHALLOW_SCUBA);
                        return;
                    }
                    ScubaAmbienceTicker.play(DEEP_SCUBA);
                    return;
                }
            }
        }
        ScubaAmbienceTicker.stop();
    }

    private static void play(SoundEvent sound) {
        if (currentSound != sound) {
            ScubaAmbienceTicker.stop();
            currentSound = sound;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(sound.func_187503_a(), SoundCategory.AMBIENT, 0.4f, 1.0f, true, 0, ISound.AttenuationType.NONE, 0.0, 0.0, 0.0, true));
        }
    }

    private static void stop() {
        if (currentSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_195478_a(currentSound.func_187503_a(), SoundCategory.AMBIENT);
            currentSound = null;
        }
    }
}

