/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.AshenModel;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

@OnlyIn(value=Dist.CLIENT)
public class AshenHeldItemLayer<T extends AshenEntity, M extends EntityModel<T>>
extends HeldItemLayer<T, M> {
    private AshenModel model;

    public AshenHeldItemLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void setAshenModel(AshenModel model) {
        this.model = model;
    }

    protected ResourceLocation getEntityTexture(AshenEntity entityIn) {
        return TropicraftRenderUtils.getTextureEntity("ashen/ashen");
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn, T ashen, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack blowGunHand = ashen.func_184614_ca();
        ItemStack daggerHand = ashen.func_184592_cb();
        if (!blowGunHand.func_190926_b() || !daggerHand.func_190926_b()) {
            stack.func_227860_a_();
            if (this.model.field_217114_e) {
                stack.func_227861_a_(0.0, 0.625, 0.0);
                stack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-20.0f));
                stack.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            HandSide side = ((AshenEntity)((Object)ashen)).func_184591_cq();
            this.renderHeldItem((AshenEntity)((Object)ashen), blowGunHand, side, stack, buffer, packedLightIn);
            side = side.func_188468_a();
            this.renderHeldItem((AshenEntity)((Object)ashen), daggerHand, side, stack, buffer, packedLightIn);
            stack.func_227865_b_();
        }
    }

    private void renderHeldItem(AshenEntity entity, ItemStack itemstack, HandSide handSide, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn) {
        if (itemstack.func_190926_b()) {
            return;
        }
        if (entity.getActionState() == AshenEntity.AshenState.HOSTILE) {
            float scale = 0.5f;
            if (handSide == HandSide.LEFT) {
                stack.func_227860_a_();
                this.model.leftArm.func_228307_a_(stack);
                stack.func_227861_a_((double)0.3f, (double)-0.3f, (double)-0.045f);
                stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(10.0f));
                stack.func_227862_a_(scale, scale, scale);
                Minecraft.func_71410_x().func_175599_af().func_229109_a_((LivingEntity)entity, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, stack, buffer, entity.field_70170_p, combinedLightIn, OverlayTexture.field_229196_a_);
                stack.func_227865_b_();
            } else {
                stack.func_227860_a_();
                this.model.rightArm.func_228307_a_(stack);
                stack.func_227861_a_(-0.375, (double)-0.35f, -0.125);
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                stack.func_227862_a_(scale, scale, scale);
                Minecraft.func_71410_x().func_175599_af().func_229109_a_((LivingEntity)entity, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, false, stack, buffer, entity.field_70170_p, combinedLightIn, OverlayTexture.field_229196_a_);
                stack.func_227865_b_();
            }
        }
    }
}

