/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.AbstractFishModel;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TropicraftFishRenderer<T extends AbstractFishEntity, M extends AbstractFishModel<T>>
extends MobRenderer<T, M> {
    private TropicraftSpecialRenderHelper renderHelper = new TropicraftSpecialRenderHelper();
    private static final Logger LOGGER = LogManager.getLogger();

    public TropicraftFishRenderer(EntityRendererManager manager, M modelbase, float f) {
        super(manager, modelbase, f);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        boolean shouldRender;
        boolean isVisible = this.func_225622_a_((LivingEntity)entity);
        boolean bl = shouldRender = !isVisible && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (isVisible || shouldRender) {
            boolean glowing = Minecraft.func_71410_x().func_238206_b_(entity);
            this.renderFishy(entity, partialTicks, matrixStackIn, bufferIn.getBuffer(this.func_230496_a_((LivingEntity)entity, isVisible, shouldRender, glowing)), packedLightIn, TropicraftFishRenderer.func_229117_c_(entity, (float)this.func_225625_b_((LivingEntity)entity, partialTicks)));
        }
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderFishy(T entity, float partialTicks, MatrixStack stack, IVertexBuilder buffer, int light, int overlay) {
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-MathHelper.func_219799_g((float)partialTicks, (float)((AbstractFishEntity)entity).field_70758_at, (float)((AbstractFishEntity)entity).field_70759_as)));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        stack.func_227862_a_(0.3f, 0.3f, 0.5f);
        stack.func_227861_a_((double)0.85f, (double)-0.3f, 0.0);
        int fishTex = 0;
        if (entity instanceof IAtlasFish) {
            fishTex = ((IAtlasFish)entity).getAtlasSlot() * 2;
        }
        this.renderHelper.renderFish(stack, buffer, fishTex, light, overlay);
        stack.func_227861_a_((double)-1.7f, 0.0, 0.0);
        stack.func_227861_a_((double)0.85f, 0.0, (double)0.025f);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(((AbstractFishModel)this.field_77045_g).tail.field_78796_g));
        stack.func_227861_a_((double)-0.85f, 0.0, (double)-0.025f);
        this.renderHelper.renderFish(stack, buffer, fishTex + 1, light, overlay);
        stack.func_227865_b_();
    }

    protected void preRenderCallback(T entity, MatrixStack stack, float partialTickTime) {
        stack.func_227862_a_(0.75f, 0.2f, 0.2f);
    }

    public ResourceLocation getEntityTexture(T entity) {
        return TropicraftRenderUtils.getTextureEntity("tropical_fish");
    }
}

