/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.client.entity.model.TropiCreeperModel;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;

@OnlyIn(value=Dist.CLIENT)
public class TropiCreeperRenderer
extends MobRenderer<TropiCreeperEntity, TropiCreeperModel> {
    private static final ResourceLocation CREEPER_TEXTURE = new ResourceLocation("tropicraft", "textures/entity/tropicreeper.png");

    public TropiCreeperRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)new TropiCreeperModel(), 0.5f);
    }

    protected void preRenderCallback(TropiCreeperEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        matrixStackIn.func_227862_a_(f2, f3, f2);
    }

    protected float getOverlayProgress(TropiCreeperEntity livingEntityIn, float partialTicks) {
        float f = livingEntityIn.getCreeperFlashIntensity(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : MathHelper.func_76131_a((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getEntityTexture(TropiCreeperEntity e) {
        return CREEPER_TEXTURE;
    }
}

