/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.data;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import net.tropicraft.core.client.data.TropicraftLangProvider;

public enum TropicraftLangKeys {
    NA("general", "na", "N/A"),
    SCUBA_AIR_TIME("scuba", "air_time", "Air Remaining: %s"),
    SCUBA_DIVE_TIME("scuba", "dive_time", "Dive Time: %s"),
    SCUBA_DEPTH("scuba", "depth", "Current Depth: %s"),
    SCUBA_MAX_DEPTH("scuba", "max_depth", "Max Depth: %s"),
    SCUBA_VISIBILITY_STAT("scuba", "scuba.visibility", "Underwater Fog Reduction");

    protected final String key;
    protected final String value;
    private final TranslationTextComponent component;

    private TropicraftLangKeys(String type, String key) {
        this(type, key, net.tropicraft.core.common.Util.toEnglishName(key));
    }

    private TropicraftLangKeys(String type, String key, String value) {
        this.key = Util.func_200697_a((String)type, (ResourceLocation)new ResourceLocation("tropicraft", key));
        this.value = value;
        this.component = new TranslationTextComponent(this.key);
    }

    public String getKey() {
        return this.key;
    }

    public TranslationTextComponent getComponent() {
        return this.component;
    }

    public TranslationTextComponent format(Object ... args) {
        return new TranslationTextComponent(this.getComponent().func_150268_i(), args);
    }

    public String getLocalizedText() {
        return this.getComponent().getString();
    }

    protected void register(TropicraftLangProvider prov) {
        prov.add(this.key, this.value);
    }

    public static void generate(TropicraftLangProvider prov) {
        for (TropicraftLangKeys lang : TropicraftLangKeys.values()) {
            lang.register(prov);
        }
    }
}

