/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.data;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import org.apache.commons.lang3.ArrayUtils;

public class TropicraftBlockstateProvider
extends BlockStateProvider {
    public TropicraftBlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "tropicraft", exFileHelper);
    }

    public ExistingFileHelper getExistingHelper() {
        return this.models().existingFileHelper;
    }

    public String func_200397_b() {
        return "Tropicraft Blockstates/Block Models";
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.CHUNK, TropicraftBlockstateProvider.applyRotations());
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.AZURITE_ORE);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_ORE);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_ORE);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.SHAKA_ORE);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_ORE);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.AZURITE_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.EUDIALYTE_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MANGANESE_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.SHAKA_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCON_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.ZIRCONIUM_BLOCK);
        BlockModelProvider models = this.models();
        TropicraftBlocks.FLOWERS.entrySet().forEach(e -> this.simpleBlock((Supplier<? extends Block>)((Supplier)e.getValue()), (ModelFile)((BlockModelBuilder)models.withExistingParent(((TropicraftFlower)e.getKey()).getId(), "block/cross")).texture("cross", "tropicraft:block/flower/" + ((TropicraftFlower)e.getKey()).getId())));
        ModelFile normal = this.cubeAll((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND);
        ModelFile calcified = this.cubeTop((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND, "calcified");
        ModelFile dune1 = this.cubeTop((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND, "dune1");
        ModelFile dune2 = this.cubeTop((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND, "dune2");
        ModelFile starfish = this.cubeTop((Supplier<? extends Block>)TropicraftBlocks.PURIFIED_SAND, "starfish");
        this.getVariantBuilder((Block)TropicraftBlocks.PURIFIED_SAND.get()).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)calcified, (int)0, (boolean)false, (int)5)).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)dune1, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)dune2, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)starfish, (int)0, (boolean)false));
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.PACKED_PURIFIED_SAND, TropicraftBlockstateProvider.applyRotations());
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.CORAL_SAND, TropicraftBlockstateProvider.applyRotations());
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.FOAMY_SAND, TropicraftBlockstateProvider.applyRotations());
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.VOLCANIC_SAND, TropicraftBlockstateProvider.applyRotations());
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MINERAL_SAND, TropicraftBlockstateProvider.applyRotations());
        ConfiguredModel[] mudModels = (ConfiguredModel[])ArrayUtils.addAll((Object[])ConfiguredModel.allYRotations((ModelFile)models.cubeAll("mud", this.modBlockLoc("mud")), (int)0, (boolean)false, (int)5), (Object[])ConfiguredModel.allYRotations((ModelFile)models.cubeAll("mud_with_stones", this.modBlockLoc("mud_with_stones")), (int)0, (boolean)false, (int)1));
        this.simpleBlock((Block)TropicraftBlocks.MUD.get(), mudModels);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MUD_WITH_PIANGUAS, TropicraftBlockstateProvider.applyYRotations(0));
        this.axisBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.BAMBOO_BUNDLE, "bamboo");
        this.axisBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.THATCH_BUNDLE, "thatch");
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get());
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.PALM_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.MAHOGANY_WOOD, (Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LOG);
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.PALM_WOOD, (Supplier<? extends Block>)TropicraftBlocks.PALM_LOG);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.RED_MANGROVE_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.RED_MANGROVE_WOOD, (Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.LIGHT_MANGROVE_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.LIGHT_MANGROVE_WOOD, (Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.BLACK_MANGROVE_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.BLACK_MANGROVE_WOOD, (Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG);
        this.mangroveRoots((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_ROOTS);
        this.mangroveRoots((Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_ROOTS);
        this.mangroveRoots((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_ROOTS);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.STRIPPED_MANGROVE_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.STRIPPED_MANGROVE_WOOD, (Supplier<? extends Block>)TropicraftBlocks.STRIPPED_MANGROVE_LOG);
        this.logBlock((RotatedPillarBlock)TropicraftBlocks.PAPAYA_LOG.get());
        this.woodBlock((Supplier<? extends RotatedPillarBlock>)TropicraftBlocks.PAPAYA_WOOD, (Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LOG);
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.BAMBOO_STAIRS, "bamboo_side", "bamboo_end");
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.THATCH_STAIRS, "thatch_side", "thatch_end");
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.CHUNK_STAIRS, "chunk");
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.PALM_STAIRS, "palm_planks");
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.MAHOGANY_STAIRS, "mahogany_planks");
        this.stairsBlock((Supplier<? extends StairsBlock>)TropicraftBlocks.MANGROVE_STAIRS, "mangrove_planks");
        ModelFile fuzzyThatch = this.fuzzyStairs("thatch_stairs_fuzzy", "thatch_side", "thatch_end", "thatch_grass");
        ModelFile fuzzyThatchOuter = this.fuzzyStairsOuter("thatch_stairs_fuzzy_outer", "thatch_side", "thatch_end", "thatch_grass");
        this.stairsBlock((StairsBlock)TropicraftBlocks.THATCH_STAIRS_FUZZY.get(), fuzzyThatch, (ModelFile)models.getExistingFile(this.modLoc("thatch_stairs_inner")), fuzzyThatchOuter);
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.BAMBOO_SLAB, (Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BUNDLE, "bamboo_side", "bamboo_end");
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.THATCH_SLAB, (Supplier<? extends Block>)TropicraftBlocks.THATCH_BUNDLE, "thatch_side", "thatch_end");
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.CHUNK_SLAB, (Supplier<? extends Block>)TropicraftBlocks.CHUNK);
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.PALM_SLAB, (Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS);
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.MAHOGANY_SLAB, (Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS);
        this.slabBlock((Supplier<? extends SlabBlock>)TropicraftBlocks.MANGROVE_SLAB, (Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.PALM_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.KAPOK_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.FRUIT_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.LEMON_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.LIME_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.ORANGE_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.PAPAYA_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.TALL_MANGROVE_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.TEA_MANGROVE_LEAVES);
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LEAVES);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.MAHOGANY_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.PALM_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.GRAPEFRUIT_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.LEMON_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.LIME_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.ORANGE_SAPLING);
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.PAPAYA_SAPLING);
        this.propagule((Supplier<? extends PropaguleBlock>)TropicraftBlocks.RED_MANGROVE_PROPAGULE);
        this.propagule((Supplier<? extends PropaguleBlock>)TropicraftBlocks.TALL_MANGROVE_PROPAGULE);
        this.propagule((Supplier<? extends PropaguleBlock>)TropicraftBlocks.TEA_MANGROVE_PROPAGULE);
        this.propagule((Supplier<? extends PropaguleBlock>)TropicraftBlocks.BLACK_MANGROVE_PROPAGULE);
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.BAMBOO_FENCE, "bamboo_side");
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.THATCH_FENCE, "thatch_side");
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.CHUNK_FENCE, "chunk");
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.PALM_FENCE, "palm_planks");
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.MAHOGANY_FENCE, "mahogany_planks");
        this.fenceBlock((Supplier<? extends FenceBlock>)TropicraftBlocks.MANGROVE_FENCE, "mangrove_planks");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.BAMBOO_FENCE_GATE, "bamboo_side");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.THATCH_FENCE_GATE, "thatch_side");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.CHUNK_FENCE_GATE, "chunk");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.PALM_FENCE_GATE, "palm_planks");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.MAHOGANY_FENCE_GATE, "mahogany_planks");
        this.fenceGateBlock((Supplier<? extends FenceGateBlock>)TropicraftBlocks.MANGROVE_FENCE_GATE, "mangrove_planks");
        this.wallBlock((Supplier<? extends WallBlock>)TropicraftBlocks.CHUNK_WALL, "chunk");
        this.doorBlock((Supplier<? extends DoorBlock>)TropicraftBlocks.BAMBOO_DOOR);
        this.doorBlock((Supplier<? extends DoorBlock>)TropicraftBlocks.THATCH_DOOR);
        this.doorBlock((Supplier<? extends DoorBlock>)TropicraftBlocks.PALM_DOOR);
        this.doorBlock((Supplier<? extends DoorBlock>)TropicraftBlocks.MAHOGANY_DOOR);
        this.doorBlock((Supplier<? extends DoorBlock>)TropicraftBlocks.MANGROVE_DOOR);
        this.trapdoorBlock((Supplier<? extends TrapDoorBlock>)TropicraftBlocks.BAMBOO_TRAPDOOR);
        this.trapdoorBlock((Supplier<? extends TrapDoorBlock>)TropicraftBlocks.THATCH_TRAPDOOR);
        this.trapdoorBlock((Supplier<? extends TrapDoorBlock>)TropicraftBlocks.PALM_TRAPDOOR);
        this.trapdoorBlock((Supplier<? extends TrapDoorBlock>)TropicraftBlocks.MAHOGANY_TRAPDOOR);
        this.trapdoorBlock((Supplier<? extends TrapDoorBlock>)TropicraftBlocks.MANGROVE_TRAPDOOR);
        this.doublePlant((Supplier<? extends DoublePlantBlock>)TropicraftBlocks.IRIS);
        this.doublePlant((Supplier<? extends DoublePlantBlock>)TropicraftBlocks.PINEAPPLE);
        this.reedsBlock((Supplier<? extends ReedsBlock>)TropicraftBlocks.REEDS);
        this.bongo((Supplier<? extends BongoDrumBlock>)TropicraftBlocks.SMALL_BONGO_DRUM);
        this.bongo((Supplier<? extends BongoDrumBlock>)TropicraftBlocks.MEDIUM_BONGO_DRUM);
        this.bongo((Supplier<? extends BongoDrumBlock>)TropicraftBlocks.LARGE_BONGO_DRUM);
        ModelBuilder bambooLadder = ((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(this.name((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER), "ladder")).texture("particle", this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER))).texture("texture", this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_LADDER));
        this.getVariantBuilder((Block)TropicraftBlocks.BAMBOO_LADDER.get()).forAllStatesExcept(arg_0 -> TropicraftBlockstateProvider.lambda$registerStatesAndModels$1((ModelFile)bambooLadder, arg_0), new Property[]{LadderBlock.field_204612_b});
        this.boardwalk((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_BOARDWALK, this.modBlockLoc("bamboo_side"));
        this.boardwalk((Supplier<? extends Block>)TropicraftBlocks.PALM_BOARDWALK, this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.PALM_PLANKS));
        this.boardwalk((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_BOARDWALK, this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.MAHOGANY_PLANKS));
        this.boardwalk((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_BOARDWALK, this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.MANGROVE_PLANKS));
        this.noModelBlock((Supplier<? extends Block>)TropicraftBlocks.BAMBOO_CHEST, this.modBlockLoc("bamboo_side"));
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.SIFTER);
        this.noModelBlock((Supplier<? extends Block>)TropicraftBlocks.DRINK_MIXER, this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.CHUNK));
        this.noModelBlock((Supplier<? extends Block>)TropicraftBlocks.AIR_COMPRESSOR, this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.CHUNK));
        this.getVariantBuilder((Block)TropicraftBlocks.COFFEE_BUSH.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.coffeeBush((Integer)state.func_177229_b((Property)CoffeeBushBlock.AGE))).build());
        this.plant((Supplier<? extends BushBlock>)TropicraftBlocks.GOLDEN_LEATHER_FERN, this.modBlockLoc("small_golden_leather_fern"));
        this.doublePlant((Supplier<? extends DoublePlantBlock>)TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN);
        this.hugePlant((Supplier<? extends HugePlantBlock>)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN, this.modBlockLoc("large_golden_leather_fern"), this.blockTexture((Supplier<? extends Block>)TropicraftBlocks.GOLDEN_LEATHER_FERN));
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.VOLCANO, (ModelFile)models.getExistingFile(this.mcLoc("block/bedrock")));
        ModelBuilder tikiLower = models.torch("tiki_torch_lower", this.modBlockLoc("tiki_torch_lower"));
        ModelBuilder tikiUpper = models.torch("tiki_torch_upper", this.modBlockLoc("tiki_torch_upper"));
        this.getVariantBuilder((Block)TropicraftBlocks.TIKI_TORCH.get()).forAllStates(arg_0 -> TropicraftBlockstateProvider.lambda$registerStatesAndModels$3((ModelFile)tikiUpper, (ModelFile)tikiLower, arg_0));
        this.simpleBlock((Supplier<? extends Block>)TropicraftBlocks.COCONUT, (ModelFile)models.cross("coconut", this.modBlockLoc("coconut")));
        this.flowerPot((Supplier<? extends FlowerPotBlock>)TropicraftBlocks.BAMBOO_FLOWER_POT, (Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT, this.modBlockLoc("bamboo_side"));
        for (RegistryObject<FlowerPotBlock> block2 : TropicraftBlocks.BAMBOO_POTTED_TROPICS_PLANTS) {
            this.flowerPot((Supplier<? extends FlowerPotBlock>)block2, (Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT, this.modBlockLoc("bamboo_side"));
        }
        for (RegistryObject<FlowerPotBlock> block2 : TropicraftBlocks.VANILLA_POTTED_TROPICS_PLANTS) {
            this.flowerPot((Supplier<? extends FlowerPotBlock>)block2, (Supplier<? extends Block>)Blocks.field_150457_bL.delegate);
        }
        for (RegistryObject<FlowerPotBlock> block2 : TropicraftBlocks.BAMBOO_POTTED_VANILLA_PLANTS) {
            this.flowerPot((Supplier<? extends FlowerPotBlock>)block2, (Supplier<? extends Block>)TropicraftBlocks.BAMBOO_FLOWER_POT, this.modBlockLoc("bamboo_side"));
        }
        ((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent("bamboo_item_frame", "item_frame")).texture("particle", this.modBlockLoc("bamboo_side"))).texture("wood", this.modBlockLoc("bamboo_side"));
        ((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent("bamboo_item_frame_map", "item_frame_map")).texture("particle", this.modBlockLoc("bamboo_side"))).texture("wood", this.modBlockLoc("bamboo_side"));
        TropicraftBlocks.JIGARBOV_WALL_TORCHES.forEach((type, block) -> this.jigarbovTorch((Supplier<? extends RedstoneTorchBlock>)block, (JigarbovTorchType)((Object)type)));
        ((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent("papaya_stage0", "cocoa_stage2")).texture("particle", this.modBlockLoc("papaya_stage0"))).texture("cocoa", this.modBlockLoc("papaya_stage0"));
    }

    private static Function<ModelFile, ConfiguredModel[]> applyRotations() {
        return f -> ConfiguredModel.allRotations((ModelFile)f, (boolean)false);
    }

    private static Function<ModelFile, ConfiguredModel[]> applyYRotations(int x) {
        return f -> ConfiguredModel.allYRotations((ModelFile)f, (int)x, (boolean)false);
    }

    private String name(Supplier<? extends Block> block) {
        return block.get().getRegistryName().func_110623_a();
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "block/" + base.func_110623_a());
    }

    private ResourceLocation itemTexture(Supplier<? extends IItemProvider> item) {
        ResourceLocation base = item.get().func_199767_j().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "item/" + base.func_110623_a());
    }

    private ResourceLocation modBlockLoc(String texture) {
        return this.modLoc("block/" + texture);
    }

    private ModelFile cubeAll(Supplier<? extends Block> block) {
        return this.cubeAll(block.get());
    }

    private ModelFile cubeTop(Supplier<? extends Block> block, String suffix) {
        return this.models().cubeTop(this.name(block) + "_" + suffix, this.blockTexture(block), this.modBlockLoc(this.name(block) + "_" + suffix));
    }

    private void simpleBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    private void simpleBlock(Supplier<? extends Block> block, ModelFile model) {
        this.simpleBlock(block.get(), model);
    }

    private void simpleBlock(Supplier<? extends Block> block, Function<ModelFile, ConfiguredModel[]> expander) {
        this.simpleBlock(block.get(), expander);
    }

    private void noModelBlock(Supplier<? extends Block> block) {
        this.noModelBlock(block, this.blockTexture(block));
    }

    private void noModelBlock(Supplier<? extends Block> block, ResourceLocation particle) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", particle));
    }

    private void axisBlock(Supplier<? extends RotatedPillarBlock> block, String texture) {
        this.axisBlock(block.get(), this.modBlockLoc(texture));
    }

    private void stairsBlock(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block, name, name);
    }

    private void stairsBlock(Supplier<? extends StairsBlock> block, String side, String topBottom) {
        this.stairsBlock(block.get(), this.modBlockLoc(side), this.modBlockLoc(topBottom), this.modBlockLoc(topBottom));
    }

    private void woodBlock(Supplier<? extends RotatedPillarBlock> wood, Supplier<? extends Block> bark) {
        ResourceLocation barkTexture = this.blockTexture(bark.get());
        this.axisBlock(wood.get(), barkTexture, barkTexture);
    }

    private ModelFile fuzzyStairs(String name, String parent, String side, String end, String cross) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc(parent))).texture("side", this.modBlockLoc(side))).texture("bottom", this.modBlockLoc(end))).texture("top", this.modBlockLoc(end))).texture("cross", this.modBlockLoc(cross));
    }

    private ModelFile coffeeBush(int age) {
        return ((BlockModelBuilder)this.models().withExistingParent("coffee_bush_stage_" + age, this.modLoc("coffee_bush"))).texture("bush", this.modBlockLoc("coffee_bush_stage" + age));
    }

    private ModelFile fuzzyStairs(String name, String side, String end, String cross) {
        return this.fuzzyStairs(name, "stairs_fuzzy", side, end, cross);
    }

    private ModelFile fuzzyStairsOuter(String name, String side, String end, String cross) {
        return this.fuzzyStairs(name, "stairs_fuzzy_outer", side, end, cross);
    }

    private void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab) {
        this.slabBlock(block, doubleslab, this.name(doubleslab));
    }

    private void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String texture) {
        this.slabBlock(block, doubleslab, texture, texture);
    }

    private void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String side, String end) {
        this.slabBlock(block.get(), doubleslab.get().getRegistryName(), this.modBlockLoc(side), this.modBlockLoc(end), this.modBlockLoc(end));
    }

    private void plant(Supplier<? extends BushBlock> block) {
        this.plant(block, this.blockTexture(block));
    }

    private void plant(Supplier<? extends BushBlock> block, ResourceLocation texture) {
        this.simpleBlock(block, (ModelFile)this.models().cross(this.name(block), texture));
    }

    private void propagule(Supplier<? extends PropaguleBlock> block) {
        String name = this.name(block);
        BlockModelBuilder planted = (BlockModelBuilder)this.models().cross(name + "_planted", this.modBlockLoc(name + "_planted"));
        BlockModelBuilder hanging = (BlockModelBuilder)this.models().cross(name + "_hanging", this.modBlockLoc(name));
        this.getVariantBuilder((Block)block.get()).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)hanging)}).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)planted)});
    }

    private void fenceBlock(Supplier<? extends FenceBlock> block, String texture) {
        this.fenceBlock(block.get(), this.modBlockLoc(texture));
        this.models().fenceInventory(this.name(block) + "_inventory", this.modBlockLoc(texture));
    }

    private void fenceGateBlock(Supplier<? extends FenceGateBlock> block, String texture) {
        this.fenceGateBlock(block.get(), this.modBlockLoc(texture));
    }

    private void wallBlock(Supplier<? extends WallBlock> block, String texture) {
        this.wallBlock(block.get(), this.modBlockLoc(texture));
        this.models().wallInventory(this.name(block) + "_inventory", this.modBlockLoc(texture));
    }

    private void doorBlock(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.modBlockLoc(this.name(block) + "_bottom"), this.modBlockLoc(this.name(block) + "_top"));
    }

    private void trapdoorBlock(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.blockTexture(block), true);
    }

    private void doublePlant(Supplier<? extends DoublePlantBlock> block) {
        String name = this.name(block);
        BlockModelProvider models = this.models();
        this.getVariantBuilder((Block)block.get()).partialState().with((Property)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(name + "_bottom", this.modBlockLoc(name + "_bottom")))}).partialState().with((Property)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(name + "_top", this.modBlockLoc(name + "_top")))});
    }

    private void reedsBlock(Supplier<? extends ReedsBlock> block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block.get());
        for (ReedsBlock.Type type : ReedsBlock.Type.values()) {
            VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(ReedsBlock.TYPE, (Comparable)((Object)type));
            for (String texture : type.getTextures()) {
                partialState.addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().crop(texture, this.modBlockLoc(texture)))});
            }
        }
    }

    private void bongo(Supplier<? extends BongoDrumBlock> block) {
        BongoDrumBlock.Size size = block.get().getSize();
        AxisAlignedBB bb = size.shape.func_197752_a();
        this.simpleBlock(block.get(), (ModelFile)((BlockModelBuilder)this.models().cubeBottomTop(this.name(block), this.modBlockLoc("bongo_side"), this.modBlockLoc("bongo_bottom"), this.modBlockLoc("bongo_top"))).element().from((float)bb.field_72340_a * 16.0f, (float)bb.field_72338_b * 16.0f, (float)bb.field_72339_c * 16.0f).to((float)bb.field_72336_d * 16.0f, (float)bb.field_72337_e * 16.0f, (float)bb.field_72334_f * 16.0f).allFaces((dir, face) -> face.texture(dir.func_176740_k().func_176722_c() ? "#side" : (dir == Direction.DOWN ? "#bottom" : "#top")).cullface((Direction)(dir.func_176740_k().func_200128_b() ? dir : null))).end());
    }

    private void mangroveRoots(Supplier<? extends Block> block) {
        String name = this.name(block);
        ResourceLocation roots = this.modBlockLoc(name);
        ModelBuilder stem = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_stem", this.modBlockLoc("mangrove_roots/stem"))).texture("roots", roots);
        ModelBuilder stemShort = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_stem_short", this.modBlockLoc("mangrove_roots/stem_short"))).texture("roots", roots);
        ModelBuilder connectionLow = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_connection_low", this.modBlockLoc("mangrove_roots/connection_low"))).texture("roots", roots);
        ModelBuilder connectionHigh = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_connection_high", this.modBlockLoc("mangrove_roots/connection_high"))).texture("roots", roots);
        ModelBuilder appendagesHigh = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_appendages_high", this.modBlockLoc("mangrove_roots/appendages"))).texture("appendages", this.modBlockLoc(name + "_appendages_high"));
        ModelBuilder appendagesHighShort = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_appendages_high_short", this.modBlockLoc("mangrove_roots/appendages"))).texture("appendages", this.modBlockLoc(name + "_appendages_high_short"));
        ModelBuilder appendagesGrounded = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_appendages_ground", this.modBlockLoc("mangrove_roots/appendages"))).texture("appendages", this.modBlockLoc(name + "_appendages_ground"));
        ModelBuilder appendagesGroundedShort = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_appendages_ground_short", this.modBlockLoc("mangrove_roots/appendages"))).texture("appendages", this.modBlockLoc(name + "_appendages_ground_short"));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stem).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stemShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGrounded).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGroundedShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHigh).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHighShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
        for (int i = 0; i < 4; ++i) {
            EnumProperty<MangroveRootsBlock.Connection> connection = MangroveRootsBlock.CONNECTIONS[i];
            int rotation = (i * 90 + 270) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionHigh).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.HIGH});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionLow).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.LOW});
        }
    }

    private void boardwalk(Supplier<? extends Block> block, ResourceLocation texture) {
        Direction.Axis[] horizontals;
        ModelBuilder shortModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_short", this.modBlockLoc("boardwalk/short"))).texture("planks", texture);
        ModelBuilder shortPostModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_short_post", this.modBlockLoc("boardwalk/short_post"))).texture("planks", texture);
        ModelBuilder tallModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_tall", this.modBlockLoc("boardwalk/tall"))).texture("planks", texture);
        ModelBuilder tallPostModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_tall_post", this.modBlockLoc("boardwalk/tall_post"))).texture("planks", texture);
        ModelBuilder tallConnectionModel = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_tall_connection", this.modBlockLoc("boardwalk/tall_connection"))).texture("planks", texture);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block.get());
        for (Direction.Axis axis : horizontals = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
            int rotation = axis == Direction.Axis.X ? 270 : 0;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALLS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.BACKS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY((rotation + 180) % 360).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.FRONTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORT_POSTS);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALL_POSTS);
    }

    private void flowerPot(Supplier<? extends FlowerPotBlock> full, Supplier<? extends Block> empty) {
        this.flowerPot(full, empty, this.blockTexture(empty));
    }

    private void flowerPot(Supplier<? extends FlowerPotBlock> full, Supplier<? extends Block> empty, ResourceLocation particle) {
        Block flower = full.get().func_220276_d();
        boolean isVanilla = flower.getRegistryName().func_110624_b().equals("minecraft");
        String parent = flower == Blocks.field_150350_a ? "flower_pot" : (!isVanilla ? "flower_pot_cross" : "block/potted_" + this.name((Supplier<? extends Block>)flower.delegate));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(full), parent)).texture("flowerpot", this.blockTexture(empty))).texture("dirt", this.mcLoc("block/dirt"))).texture("particle", this.modBlockLoc("bamboo_side"));
        if (!isVanilla) {
            if (flower instanceof TropicsFlowerBlock) {
                model.texture("plant", this.modLoc("block/flower/" + this.name((Supplier<? extends Block>)flower.delegate)));
            } else if (flower instanceof TallFlowerBlock) {
                model.texture("plant", this.modLoc("block/" + this.name((Supplier<? extends Block>)flower.delegate) + "_top"));
            } else {
                model.texture("plant", this.blockTexture(flower));
            }
        }
        this.simpleBlock(full, (ModelFile)model);
    }

    private void hugePlant(Supplier<? extends HugePlantBlock> block, ResourceLocation texture, ResourceLocation particle) {
        BlockModelBuilder cross = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modBlockLoc("huge_cross"))).texture("cross", texture)).texture("particle", particle);
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)cross).addModel()).condition(HugePlantBlock.TYPE, (Comparable[])new HugePlantBlock.Type[]{HugePlantBlock.Type.CENTER});
    }

    private void jigarbovTorch(Supplier<? extends RedstoneTorchBlock> block, JigarbovTorchType type) {
        ResourceLocation parent = this.modBlockLoc("jigarbov_wall_torch");
        ResourceLocation etchTexture = this.modBlockLoc("jigarbov/" + type.getName());
        BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), parent)).texture("torch", this.mcLoc("block/redstone_torch"))).texture("jigarbov", etchTexture);
        BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_off", parent)).texture("torch", this.mcLoc("block/redstone_torch_off"))).texture("jigarbov", etchTexture);
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            boolean lit = (Boolean)state.func_177229_b((Property)RedstoneTorchBlock.field_196528_a);
            Direction facing = (Direction)state.func_177229_b((Property)RedstoneWallTorchBlock.field_196530_b);
            int angle = ((int)facing.func_185119_l() + 90) % 360;
            return ConfiguredModel.builder().modelFile((ModelFile)(lit ? modelLit : modelOff)).rotationY(angle).build();
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$3(ModelFile tikiUpper, ModelFile tikiLower, BlockState state) {
        return ConfiguredModel.builder().modelFile(state.func_177229_b(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? tikiUpper : tikiLower).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$1(ModelFile bambooLadder, BlockState state) {
        return ConfiguredModel.builder().modelFile(bambooLadder).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
    }
}

