/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class TropicraftRenderUtils {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, RenderMaterial> materialMap = Maps.newHashMap();

    public static IVertexBuilder getEntityCutoutBuilder(IRenderTypeBuffer buffer, ResourceLocation resourceLocation) {
        return buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)resourceLocation));
    }

    public static IBakedModel getBakedModel(ItemRenderer itemRenderer, ItemStack itemStack) {
        return itemRenderer.func_175037_a().func_178089_a(itemStack);
    }

    public static void renderModel(RenderMaterial material, Model model, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        model.func_225598_a_(stack, buffer.getBuffer(model.func_228282_a_(material.func_229313_b_())), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static RenderMaterial getBlockMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> TropicraftRenderUtils.createBlockMaterial(path));
    }

    private static RenderMaterial createBlockMaterial(String path) {
        return new RenderMaterial(AtlasTexture.field_110575_b, TropicraftRenderUtils.getTextureBlock(path));
    }

    public static RenderMaterial getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> TropicraftRenderUtils.createTEMaterial(path));
    }

    private static RenderMaterial createTEMaterial(String path) {
        return new RenderMaterial(AtlasTexture.field_110575_b, TropicraftRenderUtils.getTextureTE(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> TropicraftRenderUtils.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("tropicraft", path);
    }

    public static ResourceLocation getTextureArmor(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/models/armor/%s.png", path));
    }

    public static ResourceLocation getTextureBlock(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/block/%s.png", path));
    }

    public static ResourceLocation getTextureEntity(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/entity/%s.png", path));
    }

    public static ResourceLocation getTextureGui(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/gui/%s.png", path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/block/te/%s.png", path));
    }

    public static ResourceLocation bindTextureArmor(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureArmor(path));
    }

    public static ResourceLocation bindTextureEntity(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureEntity(path));
    }

    public static ResourceLocation bindTextureGui(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureGui(path));
    }

    public static ResourceLocation bindTextureTE(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureTE(path));
    }

    public static ResourceLocation bindTextureBlock(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureBlock(path));
    }

    public static ResourceLocation bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        return resource;
    }

    public static void renderItem(ItemStack itemStack, float scale, boolean leftHand, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        if (!itemStack.func_190926_b()) {
            stack.func_227860_a_();
            stack.func_227862_a_(scale, scale, scale);
            if (itemStack.func_77973_b() instanceof SkullItem) {
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, stack, buffer);
            stack.func_227865_b_();
        }
    }
}

