/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.tropicraft.core.client.BasicColorHandler;
import net.tropicraft.core.client.ClientSetup;
import net.tropicraft.core.client.data.TropicraftBlockstateProvider;
import net.tropicraft.core.client.data.TropicraftItemModelProvider;
import net.tropicraft.core.client.data.TropicraftLangProvider;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;
import net.tropicraft.core.common.command.CommandTropicsTeleport;
import net.tropicraft.core.common.command.debug.MapBiomesCommand;
import net.tropicraft.core.common.config.TropicraftConfig;
import net.tropicraft.core.common.data.TropicraftBlockTagsProvider;
import net.tropicraft.core.common.data.TropicraftEntityTypeTagsProvider;
import net.tropicraft.core.common.data.TropicraftItemTagsProvider;
import net.tropicraft.core.common.data.TropicraftLootTableProvider;
import net.tropicraft.core.common.data.TropicraftRecipeProvider;
import net.tropicraft.core.common.data.TropicraftWorldgenProvider;
import net.tropicraft.core.common.data.loot.TropicraftLootConditions;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeProvider;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.carver.TropicraftCarvers;
import net.tropicraft.core.common.dimension.carver.TropicraftConfiguredCarvers;
import net.tropicraft.core.common.dimension.chunk.TropicraftChunkGenerator;
import net.tropicraft.core.common.dimension.feature.TropicraftConfiguredFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftConfiguredStructures;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.block_placer.TropicraftBlockPlacerTypes;
import net.tropicraft.core.common.dimension.feature.block_state_provider.TropicraftBlockStateProviders;
import net.tropicraft.core.common.dimension.feature.jigsaw.AdjustBuildingHeightProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.AirToCaveAirProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureVoidProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorLists;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.HomeTreeBranchPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.SingleNoAirJigsawPiece;
import net.tropicraft.core.common.dimension.feature.pools.TropicraftTemplatePools;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftFoliagePlacers;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;
import net.tropicraft.core.common.dimension.surfacebuilders.TropicraftConfiguredSurfaceBuilders;
import net.tropicraft.core.common.dimension.surfacebuilders.TropicraftSurfaceBuilders;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.IColoredItem;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.scuba.ScubaData;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="tropicraft")
public class Tropicraft {
    public static final ItemGroup TROPICRAFT_ITEM_GROUP = new ItemGroup("tropicraft"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)TropicraftFlower.RED_ANTHURIUM.get());
        }
    };
    private static final ForgeConfigSpec SERVER_CONFIG;
    private static final Pattern QUALIFIER;

    public Tropicraft() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(Tropicraft::getCompatVersion, (s, v) -> Tropicraft.isCompatibleVersion(s)));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::gatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_CONFIG);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(this::setupClient);
            modBus.addListener(this::registerItemColors);
        });
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        TropicraftDimension.addDefaultDimensionKey();
        TropicraftBlocks.BLOCKS.register(modBus);
        TropicraftBlocks.BLOCKITEMS.register(modBus);
        TropicraftItems.ITEMS.register(modBus);
        ScubaGogglesItem.ATTRIBUTES.register(modBus);
        MixerRecipes.addMixerRecipes();
        TropicraftTileEntityTypes.TILE_ENTITIES.register(modBus);
        TropicraftEntities.ENTITIES.register(modBus);
        TropicraftCarvers.CARVERS.register(modBus);
        TropicraftFeatures.FEATURES.register(modBus);
        TropicraftFoliagePlacers.FOLIAGE_PLACERS.register(modBus);
        TropicraftTreeDecorators.TREE_DECORATORS.register(modBus);
        TropicraftFeatures.STRUCTURES.register(modBus);
        TropicraftSurfaceBuilders.SURFACE_BUILDERS.register(modBus);
        TropicraftBlockStateProviders.BLOCK_STATE_PROVIDERS.register(modBus);
        TropicraftBlockPlacerTypes.BLOCK_PLACER_TYPES.register(modBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            StateContainer frameState = new StateContainer.Builder((Object)Blocks.field_150350_a).func_206894_a(new Property[]{BooleanProperty.func_177716_a((String)"map")}).func_235882_a_(Block::func_176223_P, BlockState::new);
            ModelBakery.field_209607_C = ImmutableMap.builder().putAll(ModelBakery.field_209607_C).put((Object)TropicraftItems.BAMBOO_ITEM_FRAME.getId(), (Object)frameState).build();
        });
    }

    public static String getCompatVersion() {
        return Tropicraft.getCompatVersion(((ModContainer)ModList.get().getModContainerById("tropicraft").orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return Tropicraft.getCompatVersion().equals(Tropicraft.getCompatVersion(version));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setupClient(FMLClientSetupEvent event) {
        ClientSetup.setupBlockRenderLayers();
        ClientSetup.setupEntityRenderers(event);
        ClientSetup.setupTileEntityRenderers();
        ClientSetup.setupDimensionRenderInfo();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item evt) {
        BasicColorHandler basic = new BasicColorHandler();
        for (RegistryObject ro : TropicraftItems.ITEMS.getEntries()) {
            Item item = (Item)ro.get();
            if (!(item instanceof IColoredItem)) continue;
            evt.getItemColors().func_199877_a((IItemColor)basic, new IItemProvider[]{item});
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        TropicraftPackets.init();
        ScubaData.registerCapability();
        TropicraftEntities.registerSpawns();
        TropicraftChunkGenerator.register();
        TropicraftBiomeProvider.register();
        Reflection.initialize((Class[])new Class[]{SingleNoAirJigsawPiece.class, NoRotateSingleJigsawPiece.class, HomeTreeBranchPiece.class, AdjustBuildingHeightProcessor.class, AirToCaveAirProcessor.class, SinkInGroundProcessor.class, SmoothingGravityProcessor.class, SteepPathProcessor.class, StructureSupportsProcessor.class, StructureVoidProcessor.class, TropicraftTrunkPlacers.class, TropicraftLootConditions.class});
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        CommandTropicsTeleport.register((CommandDispatcher<CommandSource>)dispatcher);
        if (!FMLEnvironment.production) {
            MapBiomesCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            TropicraftBlockstateProvider blockstates = new TropicraftBlockstateProvider(gen, existingFileHelper);
            gen.func_200390_a((IDataProvider)blockstates);
            gen.func_200390_a((IDataProvider)new TropicraftItemModelProvider(gen, blockstates.getExistingHelper()));
            gen.func_200390_a((IDataProvider)new TropicraftLangProvider(gen));
        }
        if (event.includeServer()) {
            TropicraftBlockTagsProvider blockTags = new TropicraftBlockTagsProvider(gen, existingFileHelper);
            gen.func_200390_a((IDataProvider)blockTags);
            gen.func_200390_a((IDataProvider)new TropicraftItemTagsProvider(gen, blockTags, existingFileHelper));
            gen.func_200390_a((IDataProvider)new TropicraftRecipeProvider(gen));
            gen.func_200390_a((IDataProvider)new TropicraftLootTableProvider(gen));
            gen.func_200390_a((IDataProvider)new TropicraftEntityTypeTagsProvider(gen, existingFileHelper));
            this.gatherWorldgenData(gen);
        }
    }

    private void gatherWorldgenData(DataGenerator gen) {
        gen.func_200390_a((IDataProvider)new TropicraftWorldgenProvider(gen, generator -> {
            TropicraftConfiguredFeatures features = generator.addConfiguredFeatures(TropicraftConfiguredFeatures::new);
            TropicraftConfiguredSurfaceBuilders surfaceBuilders = generator.addConfiguredSurfaceBuilders(TropicraftConfiguredSurfaceBuilders::new);
            TropicraftConfiguredCarvers carvers = generator.addConfiguredCarvers(TropicraftConfiguredCarvers::new);
            TropicraftProcessorLists processors = generator.addProcessorLists(TropicraftProcessorLists::new);
            TropicraftTemplatePools templates = generator.addTemplatePools(consumer -> new TropicraftTemplatePools(consumer, features, processors));
            TropicraftConfiguredStructures structures = generator.addConfiguredStructures(consumer -> new TropicraftConfiguredStructures(consumer, templates));
            generator.addBiomes(consumer -> new TropicraftBiomes(consumer, features, structures, carvers, surfaceBuilders));
        }));
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        TropicraftConfig.setupConfig(configBuilder);
        SERVER_CONFIG = configBuilder.build();
        QUALIFIER = Pattern.compile("-\\w+\\+\\d+");
    }
}

