/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.tileentity;

import cofh.thermal.cultivation.init.TCulReferences;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;

public class PotionCakeTile
extends TileEntity {
    protected CompoundNBT potionTag = new CompoundNBT();
    protected List<EffectInstance> effects = Collections.emptyList();

    public PotionCakeTile() {
        super(TCulReferences.POTION_CAKE_TILE);
    }

    public void cacheEffects(CompoundNBT nbt) {
        if (nbt != null) {
            this.potionTag = nbt.func_74737_b();
            this.effects = PotionUtils.func_185185_a((CompoundNBT)nbt);
        }
    }

    public void applyEffects(PlayerEntity player) {
        for (EffectInstance effect : this.effects) {
            if (effect.func_188419_a().func_76403_b()) {
                effect.func_188419_a().func_180793_a(null, null, (LivingEntity)player, effect.func_76458_c(), 0.5);
                continue;
            }
            EffectInstance potion = new EffectInstance(effect.func_188419_a(), effect.func_76459_b() / 4, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
            player.func_195064_c(potion);
        }
    }

    public int getColor() {
        return this.effects.isEmpty() ? 0xF800F8 : PotionUtils.func_185181_a(this.effects);
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        stack.func_77982_d(this.potionTag.func_74737_b());
        return stack;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_195045_e, pkt.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.cacheEffects(nbt.func_74775_l("Potion"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.potionTag != null && !this.potionTag.isEmpty()) {
            nbt.func_218657_a("Potion", (INBT)this.potionTag);
        }
        return nbt;
    }
}

