/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.RayTracer;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Triple;

public class WateringCanItem
extends FluidContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IMultiModeItem {
    private static final Set<Triple<BlockPos, BlockState, Block>> WATERED_BLOCKS = new ObjectOpenHashSet();
    protected static final int MB_PER_USE = 50;
    protected static boolean allowFakePlayers = false;
    protected static boolean removeSourceBlocks = true;
    protected static final Set<Block> EFFECTIVE_BLOCKS = new ObjectOpenHashSet();

    public WateringCanItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity, FluidHelper.IS_WATER);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity) -> (this.getFluidAmount(stack) > 0 ? 0.5f : 0.0f) + (this.hasActiveTag(stack) ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Area"});
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.single_block").func_240699_a_(TextFormatting.ITALIC));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius).func_240699_a_(TextFormatting.ITALIC));
        }
        if (this.getNumModes(stack) > 1) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getFluidAmount(oldStack) > 0 != this.getFluidAmount(newStack) > 0 || this.getFluidAmount(newStack) > 0 && this.hasActiveTag(oldStack) != this.hasActiveTag(newStack));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 4219135;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos offsetPos;
        BlockRayTraceResult traceResult;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (player == null || Utils.isFakePlayer((Entity)player) && !allowFakePlayers) {
            return ActionResultType.FAIL;
        }
        if (player.func_226563_dT_() && (traceResult = RayTracer.retrace((PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() != RayTraceResult.Type.MISS && FluidHelper.isWater((BlockState)world.func_180495_p(traceResult.func_216350_a()))) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        BlockPos blockPos = offsetPos = world.func_180495_p(pos).func_200132_m() ? pos.func_177972_a(context.func_196000_l()) : pos;
        if (this.getFluidAmount(stack) < this.getWaterPerUse(stack)) {
            return ActionResultType.FAIL;
        }
        this.setActive(stack, (LivingEntity)player);
        int radius = this.getMode(stack);
        int x = offsetPos.func_177958_n();
        int y = offsetPos.func_177956_o();
        int z = offsetPos.func_177952_p();
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int k = z - radius; k <= z + radius; ++k) {
                Utils.spawnParticles((World)world, (IParticleData)ParticleTypes.field_218425_n, (double)((double)i + world.field_73012_v.nextDouble()), (double)((double)(y - 1) + world.field_73012_v.nextDouble()), (double)((double)k + world.field_73012_v.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
        }
        Iterable area = BlockPos.func_218278_a((BlockPos)offsetPos.func_177982_a(-radius, -2, -radius), (BlockPos)offsetPos.func_177982_a(radius, 1, radius));
        for (BlockPos scan : area) {
            BlockState state = world.func_180495_p(scan);
            if (!(state.func_177230_c() instanceof FarmlandBlock) || (Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a) >= 7) continue;
            world.func_175656_a(scan, (BlockState)state.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)));
        }
        if (Utils.isServerWorld((World)world)) {
            if ((double)world.field_73012_v.nextFloat() < Math.max((double)this.getEffectiveness(stack), 0.05)) {
                for (BlockPos scan : area) {
                    BlockState plantState = world.func_180495_p(scan);
                    Block plant = plantState.func_177230_c();
                    if (!(plant instanceof IGrowable) && !(plant instanceof IPlantable) && !EFFECTIVE_BLOCKS.contains(plant)) continue;
                    WATERED_BLOCKS.add((Triple<BlockPos, BlockState, Block>)Triple.of((Object)new BlockPos((Vector3i)scan), (Object)plantState, (Object)plant));
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.drain(stack, this.getWaterPerUse(stack) * (this.getMode(stack) + 1) * 2, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockRayTraceResult traceResult = RayTracer.retrace((PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ItemStack stack = player.func_184586_b(hand);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        BlockPos tracePos = traceResult.func_216350_a();
        if (!player.func_226563_dT_() || !world.func_175660_a(player, tracePos) || Utils.isFakePlayer((Entity)player) && !allowFakePlayers) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (FluidHelper.isWater((BlockState)world.func_180495_p(tracePos)) && this.getSpace(stack) > 0) {
            if (removeSourceBlocks) {
                world.func_180501_a(tracePos, Blocks.field_150350_a.func_176223_P(), 11);
            }
            this.fill(stack, new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.hasActiveTag(stack)) {
            return;
        }
        long activeTime = stack.func_196082_o().func_74763_f("Active");
        if (entityIn.field_70170_p.func_82737_E() > activeTime) {
            stack.func_196082_o().func_82580_o("Active");
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"Radius");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected float getEffectiveness(ItemStack stack) {
        return 0.4f * this.getBaseMod(stack) - 0.05f * (float)this.getMode(stack);
    }

    protected int getRadius(ItemStack stack) {
        return (int)AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)0.0f) + 1;
    }

    protected int getWaterPerUse(ItemStack stack) {
        return 50;
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (this.getMode(container) >= this.getNumModes(container)) {
            this.setMode(container, this.getNumModes(container) - 1);
        }
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 0) {
            CompoundNBT nbt = item.func_179543_a("display");
            return nbt != null && nbt.func_150297_b("color", 99) ? nbt.func_74762_e("color") : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public int getNumModes(ItemStack stack) {
        return 1 + this.getRadius(stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 0.6f, 1.0f - 0.1f * (float)this.getMode(stack));
        int radius = this.getMode(stack) * 2 + 1;
        if (radius <= 1) {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.single_block"));
        } else {
            ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.cofh.area").func_240702_b_(": " + radius + "x" + radius));
        }
    }

    public static void growPlants(World world) {
        if (WATERED_BLOCKS.isEmpty()) {
            return;
        }
        for (Triple<BlockPos, BlockState, Block> entry : WATERED_BLOCKS) {
            BlockPos pos = (BlockPos)entry.getLeft();
            BlockState state = (BlockState)entry.getMiddle();
            Block block = (Block)entry.getRight();
            if (block.func_149653_t(state)) {
                block.func_225542_b_(state, (ServerWorld)world, pos, world.field_73012_v);
                world.func_184138_a(pos, state, state, 3);
                continue;
            }
            world.func_205220_G_().func_205360_a(pos, (Object)block, 0);
        }
        WATERED_BLOCKS.clear();
    }

    static {
        EFFECTIVE_BLOCKS.add(Blocks.field_150391_bh);
        EFFECTIVE_BLOCKS.add(Blocks.field_185766_cS);
    }
}

